/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.graphql.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLTypeExtension;
import com.liferay.portal.vulcan.graphql.contributor.GraphQLContributor;
import com.liferay.portal.vulcan.graphql.servlet.ServletData;
import com.liferay.portal.vulcan.internal.accept.language.AcceptLanguageImpl;
import com.liferay.portal.vulcan.internal.configuration.VulcanConfiguration;
import com.liferay.portal.vulcan.internal.configuration.util.ConfigurationUtil;
import com.liferay.portal.vulcan.internal.graphql.servlet.ServletDataAdapter;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.AggregationContextProvider;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.ContextProviderUtil;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.FilterContextProvider;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.SortContextProvider;
import com.liferay.portal.vulcan.internal.jaxrs.param.converter.provider.SiteParamConverterProvider;
import com.liferay.portal.vulcan.internal.jaxrs.validation.ValidationUtil;
import com.liferay.portal.vulcan.internal.multipart.MultipartUtil;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.Scalars;
import graphql.TypeResolutionEnvironment;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLTypeResolver;
import graphql.annotations.annotationTypes.GraphQLUnion;
import graphql.annotations.directives.DirectiveWirer;
import graphql.annotations.directives.DirectiveWiringMapRetriever;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.CannotCastMemberException;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.graphQLProcessors.GraphQLInputProcessor;
import graphql.annotations.processor.graphQLProcessors.GraphQLOutputProcessor;
import graphql.annotations.processor.retrievers.GraphQLExtensionsHandler;
import graphql.annotations.processor.retrievers.GraphQLFieldRetriever;
import graphql.annotations.processor.retrievers.GraphQLInterfaceRetriever;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.retrievers.GraphQLTypeRetriever;
import graphql.annotations.processor.retrievers.fieldBuilders.ArgumentBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.DeprecateBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.DirectivesBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.field.FieldNameBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.method.MethodNameBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.method.MethodTypeBuilder;
import graphql.annotations.processor.searchAlgorithms.BreadthFirstSearch;
import graphql.annotations.processor.searchAlgorithms.ParentalSearch;
import graphql.annotations.processor.searchAlgorithms.SearchAlgorithm;
import graphql.annotations.processor.typeBuilders.EnumBuilder;
import graphql.annotations.processor.typeBuilders.InputObjectBuilder;
import graphql.annotations.processor.typeBuilders.InterfaceBuilder;
import graphql.annotations.processor.typeBuilders.OutputObjectBuilder;
import graphql.annotations.processor.typeBuilders.UnionBuilder;
import graphql.annotations.processor.typeFunctions.DefaultTypeFunction;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.annotations.processor.util.NamingKit;
import graphql.annotations.processor.util.ReflectionKit;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.ExecutionStrategy;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.TypeResolver;
import graphql.servlet.ApolloScalars;
import graphql.servlet.DefaultExecutionStrategyProvider;
import graphql.servlet.ExecutionStrategyProvider;
import graphql.servlet.GraphQLConfiguration;
import graphql.servlet.GraphQLContext;
import graphql.servlet.GraphQLErrorHandler;
import graphql.servlet.GraphQLHttpServlet;
import graphql.servlet.GraphQLObjectMapper;
import graphql.servlet.GraphQLQueryInvoker;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import javax.validation.ValidationException;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.DatatypeConverter;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={})
public class GraphQLServletExtender {
    private static final Log _log = LogFactoryUtil.getLog(GraphQLServletExtender.class);
    private static final GraphQLScalarType _dateGraphQLScalarType;
    private static final GraphQLType _mapGraphQLType;
    private static final GraphQLScalarType _objectGraphQLScalarType;
    private static final ObjectMapper _objectMapper;
    private BundleContext _bundleContext;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    private DefaultTypeFunction _defaultTypeFunction;
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    @Reference
    private FilterParserProvider _filterParserProvider;
    private ServiceTracker<GraphQLContributor, GraphQLContributor> _graphQLContributorServiceTracker;
    private GraphQLFieldRetriever _graphQLFieldRetriever;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    private final Set<String> _registeredClassNames = new HashSet<String>();
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    private volatile Servlet _servlet;
    private ServiceRegistration<ServletContextHelper> _servletContextHelperServiceRegistration;
    private final List<ServletData> _servletDataList = new ArrayList<ServletData>();
    private ServiceTracker<ServletData, ServletData> _servletDataServiceTracker;
    private ServiceRegistration<Servlet> _servletServiceRegistration;
    @Reference
    private SortParserProvider _sortParserProvider;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._graphQLFieldRetriever = new LiferayGraphQLFieldRetriever();
        final GraphQLInterfaceRetriever graphQLInterfaceRetriever = new GraphQLInterfaceRetriever();
        final GraphQLObjectInfoRetriever graphQLObjectInfoRetriever = new GraphQLObjectInfoRetriever(){

            public String getTypeName(Class<?> objectClass) {
                String graphQLName = GraphQLServletExtender._getGraphQLNameValue(objectClass);
                if (graphQLName == null) {
                    return NamingKit.toGraphqlName((String)objectClass.getName());
                }
                return NamingKit.toGraphqlName((String)graphQLName);
            }

            public Boolean isGraphQLField(AnnotatedElement element) {
                GraphQLField graphQLField = element.getAnnotation(GraphQLField.class);
                if (graphQLField == null) {
                    return false;
                }
                return graphQLField.value();
            }
        };
        final BreadthFirstSearch breadthFirstSearch = new BreadthFirstSearch(graphQLObjectInfoRetriever);
        final ParentalSearch parentalSearch = new ParentalSearch(graphQLObjectInfoRetriever);
        final GraphQLExtensionsHandler graphQLExtensionsHandler = new GraphQLExtensionsHandler(){
            {
                this.setFieldRetriever(GraphQLServletExtender.this._graphQLFieldRetriever);
                this.setFieldSearchAlgorithm((SearchAlgorithm)parentalSearch);
                this.setGraphQLObjectInfoRetriever(graphQLObjectInfoRetriever);
                this.setMethodSearchAlgorithm((SearchAlgorithm)breadthFirstSearch);
            }
        };
        final GraphQLTypeRetriever graphQLTypeRetriever = new GraphQLTypeRetriever(){
            {
                this.setExtensionsHandler(graphQLExtensionsHandler);
                this.setFieldSearchAlgorithm((SearchAlgorithm)parentalSearch);
                this.setGraphQLFieldRetriever(GraphQLServletExtender.this._graphQLFieldRetriever);
                this.setGraphQLInterfaceRetriever(graphQLInterfaceRetriever);
                this.setGraphQLObjectInfoRetriever(graphQLObjectInfoRetriever);
                this.setMethodSearchAlgorithm((SearchAlgorithm)breadthFirstSearch);
            }

            public GraphQLType getGraphQLType(Class<?> clazz, ProcessingElementsContainer processingElementsContainer, boolean input) throws CannotCastMemberException, GraphQLAnnotationsException {
                Stack processingStack;
                String typeName;
                Map graphQLTypes = processingElementsContainer.getTypeRegistry();
                Object graphQLType = (GraphQLType)graphQLTypes.get(typeName = this._getTypeName(input, processingElementsContainer, graphQLObjectInfoRetriever.getTypeName(clazz)));
                if (graphQLType != null && !GraphQLServletExtender.this._registeredClassNames.contains(clazz.getName())) {
                    String name = clazz.getName();
                    name = name.replaceAll("\\.", "_");
                    typeName = this._getTypeName(input, processingElementsContainer, StringUtil.replace((String)name, (char)'$', (char)'_'));
                }
                if ((processingStack = processingElementsContainer.getProcessing()).contains(typeName)) {
                    return new GraphQLTypeReference(typeName);
                }
                graphQLType = (GraphQLType)graphQLTypes.get(typeName);
                if (graphQLType != null) {
                    return graphQLType;
                }
                processingStack.push(typeName);
                GraphQLServletExtender.this._registeredClassNames.add(clazz.getName());
                graphQLType = clazz.getAnnotation(GraphQLUnion.class) != null ? new UnionBuilder(graphQLObjectInfoRetriever).getUnionBuilder(clazz, processingElementsContainer).build() : (clazz.isAnnotationPresent(GraphQLTypeResolver.class) ? new InterfaceBuilder(graphQLObjectInfoRetriever, GraphQLServletExtender.this._graphQLFieldRetriever, graphQLExtensionsHandler).getInterfaceBuilder(clazz, processingElementsContainer).build() : (Enum.class.isAssignableFrom(clazz) ? new EnumBuilder(graphQLObjectInfoRetriever).getEnumBuilder(clazz).build() : (input ? new InputObjectBuilder(graphQLObjectInfoRetriever, (SearchAlgorithm)parentalSearch, (SearchAlgorithm)breadthFirstSearch, GraphQLServletExtender.this._graphQLFieldRetriever).getInputObjectBuilder(clazz, processingElementsContainer).build() : new OutputObjectBuilder(graphQLObjectInfoRetriever, (SearchAlgorithm)parentalSearch, (SearchAlgorithm)breadthFirstSearch, GraphQLServletExtender.this._graphQLFieldRetriever, graphQLInterfaceRetriever, graphQLExtensionsHandler).getOutputObjectBuilder(clazz, processingElementsContainer).build())));
                if (!StringUtil.equals((String)graphQLType.getName(), (String)typeName)) {
                    if (!this._equals((GraphQLType)graphQLTypes.get(graphQLType.getName()), (GraphQLType)graphQLType)) {
                        try {
                            Class<?> graphQLTypeClass = graphQLType.getClass();
                            Field field = graphQLTypeClass.getDeclaredField("name");
                            field.setAccessible(true);
                            field.set(graphQLType, typeName);
                        }
                        catch (Exception exception) {
                            if (_log.isDebugEnabled()) {
                                _log.debug((Object)exception, (Throwable)exception);
                            }
                        }
                    } else {
                        graphQLType = (GraphQLType)graphQLTypes.get(graphQLType.getName());
                    }
                }
                DirectiveWirer directiveWirer = new DirectiveWirer();
                DirectiveWiringMapRetriever directiveWiringMapRetriever = new DirectiveWiringMapRetriever();
                graphQLType = directiveWirer.wire((GraphQLDirectiveContainer)graphQLType, directiveWiringMapRetriever.getDirectiveWiringMap(clazz, processingElementsContainer), processingElementsContainer.getCodeRegistryBuilder(), null);
                graphQLTypes.put(graphQLType.getName(), graphQLType);
                processingStack.pop();
                return graphQLType;
            }

            private boolean _equals(GraphQLType graphQLType1, GraphQLType graphQLType2) {
                List childrenGraphQLType1 = graphQLType1.getChildren();
                List childrenGraphQLType2 = graphQLType2.getChildren();
                for (GraphQLType childGraphQLType1 : childrenGraphQLType1) {
                    boolean found = false;
                    for (GraphQLType childGraphQLType2 : childrenGraphQLType2) {
                        if (!StringUtil.equals((String)childGraphQLType2.getName(), (String)childGraphQLType1.getName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                return childrenGraphQLType1.size() == childrenGraphQLType2.size();
            }

            private String _getTypeName(boolean input, ProcessingElementsContainer processingElementsContainer, String typeName) {
                if (input) {
                    typeName = processingElementsContainer.getInputPrefix() + typeName + processingElementsContainer.getInputSuffix();
                }
                return typeName;
            }
        };
        graphQLInterfaceRetriever.setGraphQLTypeRetriever(graphQLTypeRetriever);
        this._defaultTypeFunction = new DefaultTypeFunction(new GraphQLInputProcessor(){
            {
                this.setGraphQLTypeRetriever(graphQLTypeRetriever);
            }
        }, new GraphQLOutputProcessor(){
            {
                this.setGraphQLTypeRetriever(graphQLTypeRetriever);
            }
        }){

            public GraphQLType buildType(boolean input, Class<?> clazz, AnnotatedType annotatedType, ProcessingElementsContainer processingElementsContainer) {
                GraphQLType graphQLType = super.buildType(input, clazz, annotatedType, processingElementsContainer);
                if (annotatedType != null && (annotatedType.isAnnotationPresent(NotEmpty.class) || annotatedType.isAnnotationPresent(NotNull.class))) {
                    graphQLType = new GraphQLNonNull(graphQLType);
                }
                return graphQLType;
            }
        };
        this._defaultTypeFunction.register((TypeFunction)new DateTypeFunction());
        this._defaultTypeFunction.register((TypeFunction)new MapTypeFunction());
        this._defaultTypeFunction.register((TypeFunction)new ObjectTypeFunction());
        this._graphQLContributorServiceTracker = new ServiceTracker(bundleContext, GraphQLContributor.class, (ServiceTrackerCustomizer)new GraphQLContributorServiceTrackerCustomizer());
        this._graphQLContributorServiceTracker.open();
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("osgi.http.whiteboard.context.name", "GraphQL");
        properties.put("osgi.http.whiteboard.context.path", "/graphql");
        properties.put("osgi.http.whiteboard.filter.servlet", "GraphQL");
        this._servletContextHelperServiceRegistration = bundleContext.registerService(ServletContextHelper.class, (Object)new ServletContextHelper(bundleContext.getBundle()){}, (Dictionary)properties);
        this._servletDataServiceTracker = new ServiceTracker(bundleContext, ServletData.class, (ServiceTrackerCustomizer)new ServletDataServiceTrackerCustomizer());
        this._servletDataServiceTracker.open();
        properties = new HashMapDictionary();
        properties.put("osgi.http.whiteboard.context.select", "GraphQL");
        properties.put("osgi.http.whiteboard.servlet.name", "GraphQL");
        properties.put("osgi.http.whiteboard.servlet.pattern", "/*");
        this._servletServiceRegistration = this._bundleContext.registerService(Servlet.class, (Object)((Servlet)ProxyUtil.newProxyInstance((ClassLoader)GraphQLServletExtender.class.getClassLoader(), (Class[])new Class[]{Servlet.class}, (InvocationHandler)new InvocationHandler(){
            private ServletConfig _servletConfig;

            @Override
            public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
                String methodName = method.getName();
                if (methodName.equals("destroy")) {
                    return null;
                }
                if (methodName.equals("getServletInfo")) {
                    return "";
                }
                if (methodName.equals("hashCode")) {
                    return this.hashCode();
                }
                if (methodName.equals("init") && arguments.length > 0) {
                    this._servletConfig = (ServletConfig)arguments[0];
                    return null;
                }
                Servlet servlet = GraphQLServletExtender.this._createServlet();
                servlet.init(this._servletConfig);
                try {
                    return method.invoke((Object)servlet, arguments);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
            }
        })), (Dictionary)properties);
    }

    @Deactivate
    protected void deactivate() {
        this._graphQLContributorServiceTracker.close();
        this._servletDataServiceTracker.close();
        this._servletServiceRegistration.unregister();
        this._servletContextHelperServiceRegistration.unregister();
    }

    private static Object _getAnnotationValue(AnnotatedElement annotatedElement, Class<?> clazz) {
        for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
            Class<? extends Annotation> typeClass = annotation.annotationType();
            String name = typeClass.getName();
            if (!name.equals(clazz.getName())) continue;
            try {
                Method method = typeClass.getMethod("value", new Class[0]);
                return method.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    private static String _getGraphQLNameValue(AnnotatedElement annotatedElement) {
        com.liferay.portal.vulcan.graphql.annotation.GraphQLName graphQLName = annotatedElement.getAnnotation(com.liferay.portal.vulcan.graphql.annotation.GraphQLName.class);
        if (graphQLName != null) {
            return graphQLName.value();
        }
        Object value = GraphQLServletExtender._getAnnotationValue(annotatedElement, GraphQLName.class);
        if (value == null) {
            return null;
        }
        return (String)value;
    }

    private static boolean _isMultipartBody(Parameter parameter) {
        Class<?> clazz = parameter.getType();
        String typeName = clazz.getTypeName();
        return typeName.contains("MultipartBody");
    }

    private void _collectObjectFields(GraphQLObjectType.Builder builder, Map<String, Configuration> configurations, Function<ServletData, Object> function, ProcessingElementsContainer processingElementsContainer, List<ServletData> servletDatas) {
        Stream stream = servletDatas.stream();
        Map<String, Optional<Method>> methods = stream.flatMap(servletData -> Stream.of(function.apply((ServletData)servletData)).filter(Objects::nonNull).map(Object::getClass).map(Class::getMethods).flatMap(Arrays::stream).filter(method -> this._isMethodEnabled(configurations, (Method)method, servletData.getPath()))).collect(Collectors.groupingBy(Method::getName, Collectors.maxBy(Comparator.comparingInt(this::_getVersion))));
        for (Optional<Method> methodOptional : methods.values()) {
            if (!methodOptional.isPresent()) continue;
            Method method = methodOptional.get();
            Class<?> clazz = method.getDeclaringClass();
            builder.field(this._graphQLFieldRetriever.getField(clazz.getSimpleName(), method, processingElementsContainer));
        }
    }

    private Message _createMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        MessageImpl message = new MessageImpl();
        String requestURL = String.valueOf(httpServletRequest.getRequestURL());
        message.put((Object)Message.ENDPOINT_ADDRESS, (Object)requestURL);
        String contextPath = GetterUtil.getString((String)httpServletRequest.getContextPath());
        String servletPath = GetterUtil.getString((String)httpServletRequest.getServletPath());
        message.put((Object)Message.PATH_INFO, (Object)(contextPath + servletPath + httpServletRequest.getPathInfo()));
        message.put((Object)Message.QUERY_STRING, (Object)httpServletRequest.getQueryString());
        message.put((Object)"Accept", (Object)httpServletRequest.getHeader("Accept"));
        message.put((Object)"Content-Type", (Object)httpServletRequest.getContentType());
        message.put((Object)"HTTP.REQUEST", (Object)httpServletRequest);
        message.put((Object)"HTTP.RESPONSE", (Object)httpServletResponse);
        message.put((Object)"org.apache.cxf.async.post.response.dispatch", (Object)true);
        message.put((Object)"org.apache.cxf.request.method", (Object)httpServletRequest.getMethod());
        message.put((Object)"org.apache.cxf.request.uri", (Object)httpServletRequest.getRequestURI());
        message.put((Object)"org.apache.cxf.request.url", (Object)requestURL);
        message.put((Object)"http.base.path", (Object)this._getBasePath(contextPath, httpServletRequest.getRequestURI(), requestURL, servletPath));
        message.setExchange((Exchange)new ExchangeImpl());
        return message;
    }

    private GraphQLFieldDefinition _createNodeGraphQLFieldDefinition(GraphQLOutputType graphQLOutputType) {
        GraphQLFieldDefinition.Builder graphQLFieldDefinitionbuilder = GraphQLFieldDefinition.newFieldDefinition();
        GraphQLArgument.Builder graphQLArgumentBuilder = GraphQLArgument.newArgument();
        graphQLFieldDefinitionbuilder.argument(graphQLArgumentBuilder.name("dataType").type((GraphQLInputType)Scalars.GraphQLString).build());
        graphQLArgumentBuilder = GraphQLArgument.newArgument();
        graphQLFieldDefinitionbuilder.argument(graphQLArgumentBuilder.name("id").type((GraphQLInputType)Scalars.GraphQLLong).build());
        graphQLFieldDefinitionbuilder.name("graphQLNode");
        graphQLFieldDefinitionbuilder.type(graphQLOutputType);
        return graphQLFieldDefinitionbuilder.build();
    }

    private GraphQLInterfaceType _createNodeGraphQLInterfaceType() {
        GraphQLInterfaceType.Builder interfaceBuilder = GraphQLInterfaceType.newInterface();
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition();
        interfaceBuilder.field(fieldBuilder.name("id").type((GraphQLOutputType)Scalars.GraphQLLong).build());
        interfaceBuilder.name("GraphQLNode");
        return interfaceBuilder.build();
    }

    private Object _createObject(DataFetchingEnvironment dataFetchingEnvironment, Method method) throws Exception {
        Map argumentsMap = dataFetchingEnvironment.getArguments();
        Parameter[] parameters = method.getParameters();
        Object[] arguments = new Object[parameters.length];
        Object instance = null;
        GraphQLFieldDefinition graphQLFieldDefinition = dataFetchingEnvironment.getFieldDefinition();
        if (dataFetchingEnvironment.getRoot() == dataFetchingEnvironment.getSource() || Objects.equals(graphQLFieldDefinition.getName(), "graphQLNode")) {
            instance = this._createQueryInstance(method.getDeclaringClass(), dataFetchingEnvironment);
        } else {
            Class<?> declaringClass = method.getDeclaringClass();
            Field field = declaringClass.getDeclaredField("this$0");
            Object queryInstance = this._createQueryInstance(field.getType(), dataFetchingEnvironment);
            Constructor<?>[] constructors = declaringClass.getConstructors();
            instance = ReflectionKit.constructNewInstance(constructors[0], (Object[])new Object[]{queryInstance, dataFetchingEnvironment.getSource()});
        }
        SiteParamConverterProvider siteParamConverterProvider = new SiteParamConverterProvider(this._depotEntryLocalService, this._groupLocalService);
        for (int i = 0; i < parameters.length; ++i) {
            List parts;
            Parameter parameter = parameters[i];
            String parameterName = null;
            String graphQLName = GraphQLServletExtender._getGraphQLNameValue(parameter);
            parameterName = graphQLName == null ? NamingKit.toGraphqlName((String)parameter.getName()) : NamingKit.toGraphqlName((String)graphQLName);
            Object argument = argumentsMap.get(parameterName);
            if (argument == null) {
                if (parameter.isAnnotationPresent(NotNull.class)) {
                    throw new ValidationException(parameterName + " is null");
                }
                if (parameterName.equals("page")) {
                    argument = 1;
                } else if (parameterName.equals("pageSize")) {
                    argument = 20;
                }
            }
            if (parameterName.equals("assetLibraryId") && argument != null) {
                try {
                    argument = String.valueOf(siteParamConverterProvider.getDepotGroupId((String)argument, CompanyThreadLocal.getCompanyId()));
                }
                catch (Exception exception) {
                    throw new Exception("Unable to convert asset library \"" + argument + "\" to group ID", exception);
                }
            }
            if (parameterName.equals("siteKey") && argument != null) {
                try {
                    argument = String.valueOf(siteParamConverterProvider.getGroupId(CompanyThreadLocal.getCompanyId(), (String)argument));
                }
                catch (Exception exception) {
                    throw new Exception("Unable to convert site key \"" + argument + "\" to group ID", exception);
                }
            }
            if (GraphQLServletExtender._isMultipartBody(parameter) && (parts = (List)argument) != null && !parts.isEmpty()) {
                Part metadataPart;
                String metadata;
                int index;
                HashMap binaryFiles = HashMapBuilder.put((Object)"file", () -> {
                    Part part = (Part)parts.get(0);
                    return new BinaryFile(part.getContentType(), MultipartUtil.getFileName(part), part.getInputStream(), part.getSize());
                }).build();
                HashMap<String, String> values = new HashMap<String, String>();
                if (parts.size() > 1 && (index = (metadata = StringUtil.read((InputStream)(metadataPart = (Part)parts.get(1)).getInputStream())).indexOf("=")) != -1) {
                    values.put(metadata.substring(0, index), metadata.substring(index + 1));
                }
                argument = MultipartBody.of((Map)binaryFiles, __ -> _objectMapper, values);
            }
            Class<Map> parameterClass = parameter.getClass();
            if (argument instanceof Map && !parameterClass.isAssignableFrom(Map.class)) {
                argument = _objectMapper.convertValue(argument, parameter.getType());
                ValidationUtil.validate(argument);
            }
            arguments[i] = argument;
        }
        ValidationUtil.validateArguments(instance, method, arguments);
        return method.invoke(instance, arguments);
    }

    private Object _createQueryInstance(Class<?> clazz, DataFetchingEnvironment dataFetchingEnvironment) throws Exception {
        GraphQLContext graphQLContext = (GraphQLContext)dataFetchingEnvironment.getContext();
        Optional httpServletRequestOptional = graphQLContext.getHttpServletRequest();
        HttpServletRequest httpServletRequest = httpServletRequestOptional.orElse(null);
        Optional httpServletResponseOptional = graphQLContext.getHttpServletResponse();
        HttpServletResponse httpServletResponse = httpServletResponseOptional.orElse(null);
        AcceptLanguageImpl acceptLanguage = new AcceptLanguageImpl(httpServletRequest, this._language, this._portal);
        Object instance = clazz.newInstance();
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            Class<Object> fieldClass = field.getType();
            if (fieldClass.equals(Object.class) && Objects.equals(field.getName(), "contextScopeChecker")) {
                field.setAccessible(true);
                field.set(instance, this._getScopeChecker());
                continue;
            }
            if (fieldClass.isAssignableFrom(AcceptLanguage.class)) {
                field.setAccessible(true);
                field.set(instance, acceptLanguage);
                continue;
            }
            if (fieldClass.isAssignableFrom(Company.class)) {
                field.setAccessible(true);
                field.set(instance, this._companyLocalService.getCompany(CompanyThreadLocal.getCompanyId().longValue()));
                continue;
            }
            if (fieldClass.isAssignableFrom(GroupLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._groupLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(HttpServletRequest.class)) {
                field.setAccessible(true);
                field.set(instance, httpServletRequest);
                continue;
            }
            if (fieldClass.isAssignableFrom(HttpServletResponse.class)) {
                field.setAccessible(true);
                field.set(instance, httpServletResponseOptional.orElse(null));
                continue;
            }
            if (fieldClass.isAssignableFrom(ResourceActionLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._resourceActionLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(ResourcePermissionLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._resourcePermissionLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(RoleLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._roleLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(UriInfo.class)) {
                field.setAccessible(true);
                field.set(instance, new UriInfoImpl(this._createMessage(httpServletRequest, httpServletResponse)));
                continue;
            }
            if (fieldClass.isAssignableFrom(User.class)) {
                field.setAccessible(true);
                field.set(instance, this._portal.getUser((HttpServletRequest)httpServletRequestOptional.orElse(null)));
                continue;
            }
            if (Objects.equals(field.getName(), "_aggregationBiFunction")) {
                field.setAccessible(true);
                BiFunction<Object, List, Aggregation> aggregationBiFunction = (resource, aggregations) -> {
                    try {
                        if (aggregations == null) {
                            return null;
                        }
                        AggregationContextProvider aggregationContextProvider = new AggregationContextProvider(this._language, this._portal);
                        return aggregationContextProvider.createContext(acceptLanguage, aggregations.toArray(new String[0]), this._getEntityModel(resource, httpServletRequest.getParameterMap()));
                    }
                    catch (Exception exception) {
                        throw new BadRequestException((Throwable)exception);
                    }
                };
                field.set(instance, aggregationBiFunction);
                continue;
            }
            if (Objects.equals(field.getName(), "_filterBiFunction")) {
                field.setAccessible(true);
                BiFunction<Object, String, Filter> filterBiFunction = (resource, filterString) -> {
                    try {
                        FilterContextProvider filterContextProvider = new FilterContextProvider(this._expressionConvert, this._filterParserProvider, this._language, this._portal);
                        return filterContextProvider.createContext(acceptLanguage, this._getEntityModel(resource, httpServletRequest.getParameterMap()), (String)filterString);
                    }
                    catch (Exception exception) {
                        throw new BadRequestException((Throwable)exception);
                    }
                };
                field.set(instance, filterBiFunction);
                continue;
            }
            if (!Objects.equals(field.getName(), "_sortsBiFunction")) continue;
            field.setAccessible(true);
            BiFunction<Object, String, Sort[]> sortsBiFunction = (resource, sortsString) -> {
                try {
                    SortContextProvider sortContextProvider = new SortContextProvider(this._language, this._portal, this._sortParserProvider);
                    return sortContextProvider.createContext(acceptLanguage, this._getEntityModel(resource, httpServletRequest.getParameterMap()), (String)sortsString);
                }
                catch (Exception exception) {
                    throw new BadRequestException((Throwable)exception);
                }
            };
            field.set(instance, sortsBiFunction);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Servlet _createServlet() throws Exception {
        Servlet servlet = this._servlet;
        if (servlet != null) {
            return servlet;
        }
        List<ServletData> list = this._servletDataList;
        synchronized (list) {
            if (this._servlet != null) {
                return this._servlet;
            }
            PropertyDataFetcher.clearReflectionCache();
            this._registeredClassNames.clear();
            ProcessingElementsContainer processingElementsContainer = new ProcessingElementsContainer((TypeFunction)this._defaultTypeFunction);
            Map classesMap = processingElementsContainer.getExtensionsTypeRegistry();
            ArrayList<ServletData> servletDatas = new ArrayList<ServletData>();
            for (ServletData servletData : this._servletDataList) {
                if (this._isGraphQLEnabled(servletData.getPath())) {
                    servletDatas.add(servletData);
                }
                Object query = servletData.getQuery();
                Class<?> queryClass = query.getClass();
                for (Class<?> innerClasses : queryClass.getClasses()) {
                    if (!innerClasses.isAnnotationPresent(GraphQLTypeExtension.class)) continue;
                    GraphQLTypeExtension graphQLTypeExtension = innerClasses.getAnnotation(GraphQLTypeExtension.class);
                    Class clazz = graphQLTypeExtension.value();
                    if (!classesMap.containsKey(clazz)) {
                        classesMap.put(clazz, new HashSet());
                    }
                    Set classes = (Set)classesMap.get(clazz);
                    classes.add(innerClasses);
                }
            }
            GraphQLSchema.Builder graphQLSchemaBuilder = GraphQLSchema.newSchema();
            GraphQLObjectType.Builder mutationBuilder = GraphQLObjectType.newObject();
            mutationBuilder.name("mutation");
            GraphQLObjectType.Builder graphQLObjectTypeBuilder = GraphQLObjectType.newObject();
            graphQLObjectTypeBuilder.name("query");
            Map<String, Configuration> configurations = ConfigurationUtil.getConfigurations(this._configurationAdmin);
            this._collectObjectFields(mutationBuilder, configurations, ServletData::getMutation, processingElementsContainer, servletDatas);
            this._collectObjectFields(graphQLObjectTypeBuilder, configurations, ServletData::getQuery, processingElementsContainer, servletDatas);
            graphQLSchemaBuilder.mutation(mutationBuilder.build());
            graphQLSchemaBuilder.query(graphQLObjectTypeBuilder.build());
            this._registerInterfaces(processingElementsContainer, graphQLObjectTypeBuilder, graphQLSchemaBuilder);
            GraphQLConfiguration.Builder graphQLConfigurationBuilder = GraphQLConfiguration.with((GraphQLSchema)graphQLSchemaBuilder.build());
            AsyncExecutionStrategy executionStrategy = new AsyncExecutionStrategy((DataFetcherExceptionHandler)new SanitizedDataFetcherExceptionHandler());
            DefaultExecutionStrategyProvider executionStrategyProvider = new DefaultExecutionStrategyProvider((ExecutionStrategy)executionStrategy);
            GraphQLQueryInvoker graphQLQueryInvoker = GraphQLQueryInvoker.newBuilder().withExecutionStrategyProvider((ExecutionStrategyProvider)executionStrategyProvider).build();
            graphQLConfigurationBuilder.with(graphQLQueryInvoker);
            GraphQLObjectMapper.Builder objectMapperBuilder = GraphQLObjectMapper.newBuilder();
            objectMapperBuilder.withGraphQLErrorHandler((GraphQLErrorHandler)new LiferayGraphQLErrorHandler());
            graphQLConfigurationBuilder.with(objectMapperBuilder.build());
            this._servlet = GraphQLHttpServlet.with((GraphQLConfiguration)graphQLConfigurationBuilder.build());
            return this._servlet;
        }
    }

    private String _getBasePath(String contextPath, String requestURI, String requestURL, String servletPath) {
        int index;
        if (!StringUtils.isEmpty((String)requestURI)) {
            int index2 = requestURL.indexOf(requestURI);
            if (index2 > 0) {
                return requestURL.substring(0, index2) + contextPath;
            }
        } else if (!StringUtils.isEmpty((String)servletPath) && requestURL.endsWith(servletPath) && (index = requestURL.lastIndexOf(servletPath)) > 0) {
            return requestURL.substring(0, index);
        }
        return null;
    }

    private EntityModel _getEntityModel(Object resource, Map<String, String[]> parameterMap) throws Exception {
        EntityModelResource entityModelResource = (EntityModelResource)resource;
        return entityModelResource.getEntityModel(ContextProviderUtil.getMultivaluedHashMap(parameterMap));
    }

    private Field _getFieldDefinitionsByNameField(GraphQLObjectType graphQLObjectType) throws Exception {
        Class<?> clazz = graphQLObjectType.getClass();
        Field field = clazz.getDeclaredField("fieldDefinitionsByName");
        field.setAccessible(true);
        return field;
    }

    private Boolean _getGraphQLFieldValue(AnnotatedElement annotatedElement) {
        GraphQLField graphQLField = annotatedElement.getAnnotation(GraphQLField.class);
        if (graphQLField != null) {
            return graphQLField.value();
        }
        Object value = GraphQLServletExtender._getAnnotationValue(annotatedElement, graphql.annotations.annotationTypes.GraphQLField.class);
        if (value == null) {
            return false;
        }
        return (Boolean)value;
    }

    private Object _getScopeChecker() {
        ServiceReference serviceReference = this._bundleContext.getServiceReference("com.liferay.oauth2.provider.scope.ScopeChecker");
        if (serviceReference != null) {
            return this._bundleContext.getService(serviceReference);
        }
        return null;
    }

    private Integer _getVersion(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        String packageString = String.valueOf(clazz.getPackage());
        String[] packageNames = packageString.split("\\.");
        String version = packageNames[packageNames.length - 1];
        return Integer.valueOf(version.replaceAll("\\D", ""));
    }

    private boolean _isGraphQLEnabled(String path) throws Exception {
        String filterString = String.format("(&(path=%s)(service.factoryPid=%s))", path.substring(0, path.indexOf("-graphql")), VulcanConfiguration.class.getName());
        Object[] configurations = this._configurationAdmin.listConfigurations(filterString);
        if (!ArrayUtil.isEmpty((Object[])configurations)) {
            Dictionary dictionary = configurations[0].getProperties();
            return (Boolean)dictionary.get("graphQLEnabled");
        }
        return true;
    }

    private boolean _isMethodEnabled(Map<String, Configuration> configurations, Method method, String path) {
        Configuration configuration;
        Dictionary properties;
        String excludedOperationIds;
        Set excludedOperationIdsList;
        String substring = path.substring(0, path.indexOf("-graphql"));
        if (configurations.containsKey(substring) && (excludedOperationIdsList = SetUtil.fromArray((Object[])(excludedOperationIds = GetterUtil.getString((properties = (configuration = configurations.get(substring)).getProperties()).get("excludedOperationIds"))).split(","))).contains(method.getName())) {
            return false;
        }
        return Boolean.TRUE.equals(this._getGraphQLFieldValue(method));
    }

    private void _registerInterfaces(ProcessingElementsContainer processingElementsContainer, GraphQLObjectType.Builder graphQLObjectTypeBuilder, GraphQLSchema.Builder graphQLSchemaBuilder) {
        try {
            Map graphQLTypes = processingElementsContainer.getTypeRegistry();
            GraphQLInterfaceType graphQLInterfaceType = this._createNodeGraphQLInterfaceType();
            graphQLTypes.put("GraphQLNode", graphQLInterfaceType);
            graphQLObjectTypeBuilder.field(this._createNodeGraphQLFieldDefinition((GraphQLOutputType)graphQLInterfaceType));
            GraphQLCodeRegistry.Builder builder = processingElementsContainer.getCodeRegistryBuilder();
            graphQLSchemaBuilder.codeRegistry(builder.dataFetcher(FieldCoordinates.coordinates((String)"query", (String)"graphQLNode"), (DataFetcher)new NodeDataFetcher()).typeResolver("GraphQLNode", (TypeResolver)new GraphQLNodeTypeResolver()).build());
            for (Map.Entry entry : graphQLTypes.entrySet()) {
                GraphQLObjectType graphQLObjectType;
                GraphQLFieldDefinition graphQLFieldDefinition;
                GraphQLType graphQLType = (GraphQLType)entry.getValue();
                if (!(graphQLType instanceof GraphQLObjectType) || (graphQLFieldDefinition = (graphQLObjectType = (GraphQLObjectType)graphQLType).getFieldDefinition("id")) == null || graphQLFieldDefinition.getType() != Scalars.GraphQLLong) continue;
                this._replaceFieldDefinition(graphQLInterfaceType, graphQLObjectType);
                this._replaceFieldNodes(builder, graphQLInterfaceType, graphQLObjectType, graphQLSchemaBuilder);
                this._replaceInterface(graphQLInterfaceType, graphQLObjectType);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void _replaceFieldDefinition(GraphQLInterfaceType graphQLInterfaceType, GraphQLObjectType graphQLObjectType) throws Exception {
        Field field = this._getFieldDefinitionsByNameField(graphQLObjectType);
        Map graphQLFieldDefinitions = (Map)field.get(graphQLObjectType);
        for (GraphQLFieldDefinition graphQLFieldDefinition : graphQLObjectType.getFieldDefinitions()) {
            GraphQLOutputType graphQLOutputType = graphQLFieldDefinition.getType();
            String typeName = graphQLOutputType.getName();
            if (typeName == null || !typeName.equals("Object") || !StringUtil.endsWith((String)graphQLFieldDefinition.getName(), (String)"Id")) continue;
            Class<?> fieldClass = graphQLFieldDefinition.getClass();
            Method method = fieldClass.getDeclaredMethod("replaceType", GraphQLOutputType.class);
            method.setAccessible(true);
            method.invoke((Object)graphQLFieldDefinition, graphQLInterfaceType);
            graphQLFieldDefinitions.put(graphQLFieldDefinition.getName(), graphQLFieldDefinition);
        }
        field.set(graphQLObjectType, graphQLFieldDefinitions);
    }

    private void _replaceFieldNodes(GraphQLCodeRegistry.Builder builder, GraphQLInterfaceType graphQLInterfaceType, GraphQLObjectType graphQLObjectType, GraphQLSchema.Builder graphQLSchemaBuilder) throws Exception {
        GraphQLFieldDefinition graphQLFieldDefinition = graphQLObjectType.getFieldDefinition("contentType");
        if (graphQLFieldDefinition == null) {
            return;
        }
        Field field = this._getFieldDefinitionsByNameField(graphQLObjectType);
        Map graphQLFieldDefinitions = (Map)field.get(graphQLObjectType);
        GraphQLFieldDefinition.Builder graphQLFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition();
        graphQLFieldDefinitions.put("graphQLNode", graphQLFieldDefinitionBuilder.name("graphQLNode").type((GraphQLOutputType)graphQLInterfaceType).build());
        graphQLSchemaBuilder.codeRegistry(builder.dataFetcher(FieldCoordinates.coordinates((String)graphQLObjectType.getName(), (String)"graphQLNode"), (DataFetcher)new GraphQLNodePropertyDataFetcher()).typeResolver("GraphQLNode", (TypeResolver)new GraphQLNodeTypeResolver()).build());
        field.set(graphQLObjectType, graphQLFieldDefinitions);
    }

    private void _replaceInterface(GraphQLInterfaceType graphQLInterfaceType, GraphQLObjectType graphQLObjectType) throws Exception {
        Class<?> clazz = graphQLObjectType.getClass();
        Method method = clazz.getDeclaredMethod("replaceInterfaces", List.class);
        method.setAccessible(true);
        method.invoke((Object)graphQLObjectType, Collections.singletonList(graphQLInterfaceType));
    }

    static {
        _objectMapper = new ObjectMapper();
        GraphQLScalarType.Builder dateBuilder = new GraphQLScalarType.Builder();
        _dateGraphQLScalarType = dateBuilder.name("Date").description("An RFC-3339 compliant date time scalar").coercing((Coercing)new Coercing<Date, String>(){

            public Date parseLiteral(Object value) throws CoercingParseLiteralException {
                return this._toDate(value);
            }

            public Date parseValue(Object value) throws CoercingParseValueException {
                return this._toDate(value);
            }

            public String serialize(Object value) throws CoercingSerializeException {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                return simpleDateFormat.format((Date)value);
            }

            private Date _toDate(Object value) {
                if (value instanceof Date) {
                    return (Date)value;
                }
                if (value instanceof StringValue) {
                    StringValue stringValue = (StringValue)value;
                    Calendar calendar = DatatypeConverter.parseDateTime((String)stringValue.getValue());
                    return calendar.getTime();
                }
                Calendar calendar = DatatypeConverter.parseDateTime((String)value.toString());
                return calendar.getTime();
            }
        }).build();
        GraphQLScalarType.Builder objectBuilder = new GraphQLScalarType.Builder();
        _mapGraphQLType = objectBuilder.name("Map").description("Any kind of object supported by a Map").coercing((Coercing)new Coercing<Object, Object>(){

            public Object parseLiteral(Object value) throws CoercingParseLiteralException {
                return value;
            }

            public Object parseValue(Object value) throws CoercingParseValueException {
                return value;
            }

            public Object serialize(Object value) throws CoercingSerializeException {
                return value;
            }
        }).build();
        _objectGraphQLScalarType = objectBuilder.name("Object").description("Any kind of object supported by basic scalar types").coercing((Coercing)new Coercing<Object, Object>(){

            public Object parseLiteral(Object value) throws CoercingParseLiteralException {
                if (value instanceof ArrayValue) {
                    ArrayValue arrayValue = (ArrayValue)value;
                    List values = arrayValue.getValues();
                    Stream stream = values.stream();
                    return stream.map(this::parseLiteral).collect(Collectors.toList());
                }
                if (value instanceof BooleanValue) {
                    BooleanValue booleanValue = (BooleanValue)value;
                    return booleanValue.isValue();
                }
                if (value instanceof EnumValue) {
                    EnumValue enumValue = (EnumValue)value;
                    return enumValue.getName();
                }
                if (value instanceof FloatValue) {
                    FloatValue floatValue = (FloatValue)value;
                    return floatValue.getValue();
                }
                if (value instanceof IntValue) {
                    IntValue intValue = (IntValue)value;
                    return intValue.getValue();
                }
                if (value instanceof NullValue) {
                    return null;
                }
                if (value instanceof ObjectValue) {
                    ObjectValue objectValue = (ObjectValue)value;
                    List objectFields = objectValue.getObjectFields();
                    Stream stream = objectFields.stream();
                    return stream.collect(Collectors.toMap(ObjectField::getName, objectField -> this.parseLiteral(objectField.getValue())));
                }
                if (value instanceof StringValue) {
                    StringValue stringValue = (StringValue)value;
                    return stringValue.getValue();
                }
                throw new CoercingSerializeException("Unable to parse " + value);
            }

            public Object parseValue(Object value) throws CoercingParseValueException {
                return value;
            }

            public Object serialize(Object value) throws CoercingSerializeException {
                return value;
            }
        }).build();
    }

    private class ServletDataServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ServletData, ServletData> {
        private ServletDataServiceTrackerCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServletData addingService(ServiceReference<ServletData> serviceReference) {
            ServletData servletData = (ServletData)GraphQLServletExtender.this._bundleContext.getService(serviceReference);
            List list = GraphQLServletExtender.this._servletDataList;
            synchronized (list) {
                GraphQLServletExtender.this._servletDataList.add(servletData);
                GraphQLServletExtender.this._servlet = null;
            }
            return servletData;
        }

        public void modifiedService(ServiceReference<ServletData> serviceReference, ServletData servletData) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<ServletData> serviceReference, ServletData servletData) {
            List list = GraphQLServletExtender.this._servletDataList;
            synchronized (list) {
                GraphQLServletExtender.this._servletDataList.remove(servletData);
                GraphQLServletExtender.this._servlet = null;
            }
            GraphQLServletExtender.this._bundleContext.ungetService(serviceReference);
        }
    }

    private class LiferayMethodDataFetcher
    implements DataFetcher<Object> {
        private final Method _method;

        public Object get(DataFetchingEnvironment dataFetchingEnvironment) {
            try {
                return GraphQLServletExtender.this._createObject(dataFetchingEnvironment, this._method);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        private LiferayMethodDataFetcher(Method method) {
            this._method = method;
        }
    }

    private class LiferayGraphQLFieldRetriever
    extends GraphQLFieldRetriever {
        private LiferayGraphQLFieldRetriever() {
        }

        public GraphQLFieldDefinition getField(String parentName, Field field, ProcessingElementsContainer processingElementsContainer) throws GraphQLAnnotationsException {
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            builder.deprecate(new DeprecateBuilder((AccessibleObject)field).build());
            GraphQLField graphQLField = field.getAnnotation(GraphQLField.class);
            if (graphQLField != null) {
                builder.description(graphQLField.description());
            }
            builder.name(new FieldNameBuilder(field).build());
            builder.type((GraphQLOutputType)GraphQLServletExtender.this._defaultTypeFunction.buildType(field.getType(), field.getAnnotatedType(), processingElementsContainer));
            return builder.build();
        }

        public GraphQLFieldDefinition getField(String parentName, Method method, ProcessingElementsContainer processingElementsContainer) {
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            MethodTypeBuilder methodTypeBuilder = new MethodTypeBuilder(method, processingElementsContainer.getDefaultTypeFunction(), processingElementsContainer, false);
            GraphQLOutputType graphQLOutputType = (GraphQLOutputType)methodTypeBuilder.build();
            LiferayArgumentBuilder argumentBuilder = new LiferayArgumentBuilder(method, processingElementsContainer.getDefaultTypeFunction(), builder, processingElementsContainer, graphQLOutputType);
            builder.arguments(argumentBuilder.build());
            builder.dataFetcher((DataFetcher)new LiferayMethodDataFetcher(method));
            LiferayDeprecateBuilder deprecateBuilder = new LiferayDeprecateBuilder(method);
            builder.deprecate(deprecateBuilder.build());
            GraphQLField graphQLField = method.getAnnotation(GraphQLField.class);
            if (graphQLField != null) {
                builder.description(graphQLField.description());
            }
            MethodNameBuilder methodNameBuilder = new MethodNameBuilder(method);
            builder.name(methodNameBuilder.build());
            builder.type(graphQLOutputType);
            return builder.build();
        }
    }

    private class GraphQLContributorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<GraphQLContributor, GraphQLContributor> {
        private final Map<GraphQLContributor, ServiceRegistration<ServletData>> _servletDataServiceRegistrations = new ConcurrentHashMap<GraphQLContributor, ServiceRegistration<ServletData>>();

        private GraphQLContributorServiceTrackerCustomizer() {
        }

        public GraphQLContributor addingService(ServiceReference<GraphQLContributor> serviceReference) {
            GraphQLContributor graphQLContributor = (GraphQLContributor)GraphQLServletExtender.this._bundleContext.getService(serviceReference);
            ServiceRegistration servletDataServiceRegistration = GraphQLServletExtender.this._bundleContext.registerService(ServletData.class, (Object)ServletDataAdapter.of(graphQLContributor), null);
            this._servletDataServiceRegistrations.put(graphQLContributor, (ServiceRegistration<ServletData>)servletDataServiceRegistration);
            return graphQLContributor;
        }

        public void modifiedService(ServiceReference<GraphQLContributor> serviceReference, GraphQLContributor graphQLContributor) {
        }

        public void removedService(ServiceReference<GraphQLContributor> serviceReference, GraphQLContributor graphQLContributor) {
            Optional.ofNullable(this._servletDataServiceRegistrations.remove(graphQLContributor)).ifPresent(ServiceRegistration::unregister);
            GraphQLServletExtender.this._bundleContext.ungetService(serviceReference);
        }
    }

    private static class SanitizedDataFetcherExceptionHandler
    implements DataFetcherExceptionHandler {
        private SanitizedDataFetcherExceptionHandler() {
        }

        public DataFetcherExceptionHandlerResult onException(DataFetcherExceptionHandlerParameters dataFetcherExceptionHandlerParameters) {
            DataFetcherExceptionHandlerResult.Builder builder = DataFetcherExceptionHandlerResult.newResult();
            return builder.error((GraphQLError)new ExceptionWhileDataFetching(dataFetcherExceptionHandlerParameters.getPath(), dataFetcherExceptionHandlerParameters.getException(), dataFetcherExceptionHandlerParameters.getSourceLocation())).build();
        }
    }

    private static class ObjectTypeFunction
    implements TypeFunction {
        private ObjectTypeFunction() {
        }

        public GraphQLType buildType(boolean input, Class<?> clazz, AnnotatedType annotatedType, ProcessingElementsContainer processingElementsContainer) {
            return _objectGraphQLScalarType;
        }

        public boolean canBuildType(Class<?> clazz, AnnotatedType annotatedType) {
            return clazz == MultipartBody.class || clazz == Object.class || clazz == Response.class;
        }
    }

    private static class NodeDataFetcher
    implements DataFetcher<Object> {
        private NodeDataFetcher() {
        }

        public Object get(DataFetchingEnvironment dataFetchingEnvironment) throws Exception {
            GraphQLSchema graphQLSchema = dataFetchingEnvironment.getGraphQLSchema();
            GraphQLCodeRegistry graphQLCodeRegistry = graphQLSchema.getCodeRegistry();
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            GraphQLFieldDefinition graphQLFieldDefinition = dataFetchingEnvironment.getFieldDefinition();
            String fieldName = this._getFieldName(dataFetchingEnvironment, graphQLSchema);
            DataFetcher dataFetcher = graphQLCodeRegistry.getDataFetcher((GraphQLFieldsContainer)dataFetchingEnvironment.getParentType(), builder.argument(graphQLFieldDefinition.getArgument("id")).name(fieldName).type(graphQLFieldDefinition.getType()).build());
            DataFetchingEnvironmentImpl.Builder dataFetchingEnvironmentBuilder = DataFetchingEnvironmentImpl.newDataFetchingEnvironment((DataFetchingEnvironment)dataFetchingEnvironment);
            return dataFetcher.get(dataFetchingEnvironmentBuilder.arguments(Collections.singletonMap(fieldName + "Id", dataFetchingEnvironment.getArgument("id"))).build());
        }

        private String _getFieldName(DataFetchingEnvironment dataFetchingEnvironment, GraphQLSchema graphQLSchema) {
            Map graphQLTypes = graphQLSchema.getTypeMap();
            GraphQLType graphQLType = (GraphQLType)graphQLTypes.get(dataFetchingEnvironment.getArgument("dataType"));
            return StringUtil.lowerCaseFirstLetter((String)graphQLType.getName());
        }
    }

    private static class MapTypeFunction
    implements TypeFunction {
        private MapTypeFunction() {
        }

        public GraphQLType buildType(boolean input, Class<?> clazz, AnnotatedType annotatedType, ProcessingElementsContainer processingElementsContainer) {
            return _mapGraphQLType;
        }

        public boolean canBuildType(Class<?> clazz, AnnotatedType annotatedType) {
            return clazz == Map.class;
        }
    }

    private static class LiferayGraphQLErrorHandler
    implements GraphQLErrorHandler {
        private LiferayGraphQLErrorHandler() {
        }

        public List<GraphQLError> processErrors(List<GraphQLError> graphQLErrors) {
            Stream stream = graphQLErrors.stream();
            return stream.filter(graphQLError -> !this._isNoSuchModelException((GraphQLError)graphQLError) || this._isRequiredField((GraphQLError)graphQLError)).map(graphQLError -> {
                String message = graphQLError.getMessage();
                if (message.contains("SecurityException")) {
                    return this._getExtendedGraphQLError((GraphQLError)graphQLError, Response.Status.UNAUTHORIZED);
                }
                if (this._isNoSuchModelException((GraphQLError)graphQLError)) {
                    return this._getExtendedGraphQLError((GraphQLError)graphQLError, Response.Status.NOT_FOUND);
                }
                if (!this._isClientErrorException((GraphQLError)graphQLError)) {
                    return this._getExtendedGraphQLError((GraphQLError)graphQLError, Response.Status.INTERNAL_SERVER_ERROR);
                }
                return this._getExtendedGraphQLError((GraphQLError)graphQLError, Response.Status.BAD_REQUEST);
            }).collect(Collectors.toList());
        }

        private GraphQLError _getExtendedGraphQLError(GraphQLError graphQLError, Response.Status status) {
            GraphqlErrorBuilder graphqlErrorBuilder = GraphqlErrorBuilder.newError();
            String message = graphQLError.getMessage();
            return graphqlErrorBuilder.message(message.replace("%", ""), new Object[0]).extensions((Map)HashMapBuilder.put((Object)"code", (Object)status.getReasonPhrase()).put((Object)"exception", (Object)HashMapBuilder.put((Object)"errno", (Object)status.getStatusCode()).build()).build()).build();
        }

        private boolean _isClientErrorException(GraphQLError graphQLError) {
            if (graphQLError instanceof ExceptionWhileDataFetching) {
                ExceptionWhileDataFetching exceptionWhileDataFetching = (ExceptionWhileDataFetching)graphQLError;
                return exceptionWhileDataFetching.getException() instanceof GraphQLError;
            }
            String message = graphQLError.getMessage();
            return !(graphQLError instanceof Throwable) || message.contains("ClientErrorException");
        }

        private boolean _isNoSuchModelException(GraphQLError graphQLError) {
            if (!(graphQLError instanceof ExceptionWhileDataFetching)) {
                return false;
            }
            ExceptionWhileDataFetching exceptionWhileDataFetching = (ExceptionWhileDataFetching)graphQLError;
            Throwable throwable = exceptionWhileDataFetching.getException();
            return throwable != null && throwable.getCause() instanceof NoSuchModelException;
        }

        private boolean _isRequiredField(GraphQLError graphQLError) {
            List path = Optional.ofNullable(graphQLError.getPath()).orElse(Collections.emptyList());
            if (path.size() <= 1) {
                return true;
            }
            return StringUtil.containsIgnoreCase((String)((String)path.get(path.size() - 1)), (String)"parent");
        }
    }

    private static class LiferayDeprecateBuilder
    extends DeprecateBuilder {
        private final AccessibleObject _accessibleObject;

        public LiferayDeprecateBuilder(AccessibleObject accessibleObject) {
            super(accessibleObject);
            this._accessibleObject = accessibleObject;
        }

        public String build() {
            Deprecated deprecated = this._accessibleObject.getAnnotation(Deprecated.class);
            if (deprecated != null) {
                return "Deprecated";
            }
            return null;
        }
    }

    private static class LiferayArgumentBuilder
    extends ArgumentBuilder {
        private final Method _method;
        private final ProcessingElementsContainer _processingElementsContainer;
        private final TypeFunction _typeFunction;

        public LiferayArgumentBuilder(Method method, TypeFunction typeFunction, GraphQLFieldDefinition.Builder builder, ProcessingElementsContainer processingElementsContainer, GraphQLOutputType graphQLOutputType) {
            super(method, typeFunction, builder, processingElementsContainer, graphQLOutputType);
            this._method = method;
            this._typeFunction = typeFunction;
            this._processingElementsContainer = processingElementsContainer;
        }

        public List<GraphQLArgument> build() {
            Stream<Parameter> stream = Arrays.stream(this._method.getParameters());
            return stream.filter(parameter -> !DataFetchingEnvironment.class.isAssignableFrom(parameter.getType())).map(parameter -> {
                if (GraphQLServletExtender._isMultipartBody(parameter)) {
                    GraphQLArgument.Builder builder = new GraphQLArgument.Builder();
                    return builder.type((GraphQLInputType)new GraphQLList((GraphQLType)ApolloScalars.Upload)).name("multipartBody").build();
                }
                return this._createGraphQLArgument((Parameter)parameter, (GraphQLInputType)this._typeFunction.buildType(true, parameter.getType(), parameter.getAnnotatedType(), this._processingElementsContainer));
            }).collect(Collectors.toList());
        }

        private GraphQLArgument _createGraphQLArgument(Parameter parameter, GraphQLInputType graphQLInputType) throws GraphQLAnnotationsException {
            DirectiveWirer directiveWirer = new DirectiveWirer();
            GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
            String graphQLName = GraphQLServletExtender._getGraphQLNameValue(parameter);
            if (graphQLName != null) {
                builder.name(NamingKit.toGraphqlName((String)graphQLName));
            } else {
                builder.name(NamingKit.toGraphqlName((String)parameter.getName()));
            }
            builder.type(graphQLInputType);
            DirectivesBuilder directivesBuilder = new DirectivesBuilder((AnnotatedElement)parameter, this._processingElementsContainer);
            builder.withDirectives(directivesBuilder.build());
            DirectiveWiringMapRetriever directiveWiringMapRetriever = new DirectiveWiringMapRetriever();
            return (GraphQLArgument)directiveWirer.wire((GraphQLDirectiveContainer)builder.build(), directiveWiringMapRetriever.getDirectiveWiringMap((AnnotatedElement)parameter, this._processingElementsContainer), this._processingElementsContainer.getCodeRegistryBuilder(), graphQLInputType.getName());
        }
    }

    private static class GraphQLNodeTypeResolver
    implements TypeResolver {
        private GraphQLNodeTypeResolver() {
        }

        public GraphQLObjectType getType(TypeResolutionEnvironment typeResolutionEnvironment) {
            GraphQLSchema graphQLSchema = typeResolutionEnvironment.getSchema();
            Map graphQLTypes = graphQLSchema.getTypeMap();
            GraphQLType graphQLType = (GraphQLType)graphQLTypes.get(this._getClassName(typeResolutionEnvironment.getObject()));
            return (GraphQLObjectType)graphQLType;
        }

        private String _getClassName(Object object) {
            Class<?> clazz = object.getClass();
            String name = clazz.getName();
            if (!name.contains("$")) {
                return clazz.getSimpleName();
            }
            Class<?> parentClass = clazz.getSuperclass();
            return parentClass.getSimpleName();
        }
    }

    private static class GraphQLNodePropertyDataFetcher
    implements DataFetcher<Object> {
        private GraphQLNodePropertyDataFetcher() {
        }

        public Object get(DataFetchingEnvironment dataFetchingEnvironment) throws Exception {
            Method[] methods;
            GraphQLSchema graphQLSchema = dataFetchingEnvironment.getGraphQLSchema();
            GraphQLCodeRegistry graphQLCodeRegistry = graphQLSchema.getCodeRegistry();
            Map graphQLTypes = graphQLSchema.getTypeMap();
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            Object source = dataFetchingEnvironment.getSource();
            Class<?> clazz = source.getClass();
            Method getContentTypeMethod = clazz.getMethod("getContentType", new Class[0]);
            String fieldName = StringUtil.lowerCaseFirstLetter((String)((String)getContentTypeMethod.invoke(source, new Object[0])));
            GraphQLFieldDefinition graphQLFieldDefinition = dataFetchingEnvironment.getFieldDefinition();
            DataFetcher dataFetcher = graphQLCodeRegistry.getDataFetcher((GraphQLFieldsContainer)graphQLTypes.get("query"), builder.name(fieldName).type(graphQLFieldDefinition.getType()).build());
            DataFetchingEnvironmentImpl.Builder dataFetchingEnvironmentBuilder = DataFetchingEnvironmentImpl.newDataFetchingEnvironment((DataFetchingEnvironment)dataFetchingEnvironment);
            Method method = clazz.getMethod("getId", new Class[0]);
            for (Method existingMethod : methods = clazz.getMethods()) {
                if (!StringUtil.equals((String)existingMethod.getName(), (String)"getContentId")) continue;
                method = existingMethod;
            }
            return dataFetcher.get(dataFetchingEnvironmentBuilder.arguments(Collections.singletonMap(fieldName + "Id", method.invoke(source, new Object[0]))).build());
        }
    }

    private static class DateTypeFunction
    implements TypeFunction {
        private DateTypeFunction() {
        }

        public GraphQLType buildType(boolean input, Class<?> clazz, AnnotatedType annotatedType, ProcessingElementsContainer processingElementsContainer) {
            return _dateGraphQLScalarType;
        }

        public boolean canBuildType(Class<?> clazz, AnnotatedType annotatedType) {
            return clazz == Date.class;
        }
    }
}

