/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.param.converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ParamConverter;

public class DateParamConverter
implements ParamConverter<Date> {
    private static final String _PATTERN_DATE = "yyyy-MM-dd";
    private static final String _PATTERN_DATE_TIME = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String _PATTERN_DATE_TIME_WITHOUT_MILLIS = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public Date fromString(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this._getPattern(string));
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException pe) {
            throw new WebApplicationException((Throwable)pe);
        }
    }

    public String toString(Date date) {
        return new SimpleDateFormat(_PATTERN_DATE_TIME).format(date);
    }

    private String _getPattern(String string) {
        if (string.contains("T")) {
            if (string.contains(".")) {
                return _PATTERN_DATE_TIME;
            }
            return _PATTERN_DATE_TIME_WITHOUT_MILLIS;
        }
        return _PATTERN_DATE;
    }
}

