/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.param.converter.provider;

import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;

@Provider
public class SiteParamConverterProvider
implements ParamConverter<Long>,
ParamConverterProvider {
    @Context
    private Company _company;
    private final GroupLocalService _groupLocalService;
    @Context
    private UriInfo _uriInfo;

    public SiteParamConverterProvider(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    public Long fromString(String parameter) {
        MultivaluedMap multivaluedMap = this._uriInfo.getPathParameters();
        Long siteId = this.getGroupId(this._company.getCompanyId(), (String)multivaluedMap.getFirst((Object)"siteId"));
        if (siteId != null) {
            return siteId;
        }
        throw new NotFoundException("Unable to get a valid site with ID " + siteId);
    }

    public <T> ParamConverter<T> getConverter(Class<T> clazz, Type type, Annotation[] annotations) {
        if (Long.class.equals(clazz) && this._hasSiteIdAnnotation(annotations)) {
            return this;
        }
        return null;
    }

    public Long getGroupId(long companyId, String siteId) {
        if (siteId != null) {
            Group group = this._groupLocalService.fetchGroup(companyId, siteId);
            if (group == null) {
                group = this._groupLocalService.fetchGroup(GetterUtil.getLong((String)siteId));
            }
            if (group != null && group.isSite()) {
                return group.getGroupId();
            }
        }
        return null;
    }

    public String toString(Long parameter) {
        return String.valueOf(parameter);
    }

    private boolean _hasSiteIdAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            String annotationString = annotation.toString();
            if (!annotationString.equals("@javax.ws.rs.PathParam(value=siteId)")) continue;
            return true;
        }
        return false;
    }
}

