/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.container.request.filter;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.internal.accept.language.AcceptLanguageImpl;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.ContextProviderUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

@Provider
public class ContextContainerRequestFilter
implements ContainerRequestFilter {
    private final Language _language;
    private final Portal _portal;

    public ContextContainerRequestFilter(Language language, Portal portal) {
        this._language = language;
        this._portal = portal;
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        this.handleMessage(PhaseInterceptorChain.getCurrentMessage());
    }

    public void handleMessage(Message message) throws Fault {
        try {
            this._handleMessage(message);
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    private void _handleMessage(Message message) throws Exception {
        Object instance = ContextProviderUtil.getMatchedResource(message);
        if (instance == null) {
            return;
        }
        HttpServletRequest httpServletRequest = ContextProviderUtil.getHttpServletRequest(message);
        Class<?> clazz = instance.getClass();
        Class<?> superClass = clazz.getSuperclass();
        for (Field field : superClass.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            Class<Object> fieldClass = field.getType();
            if (fieldClass.isAssignableFrom(AcceptLanguage.class)) {
                field.setAccessible(true);
                field.set(instance, new AcceptLanguageImpl(httpServletRequest, this._language, this._portal));
                continue;
            }
            if (fieldClass.isAssignableFrom(Company.class)) {
                field.setAccessible(true);
                field.set(instance, this._portal.getCompany(httpServletRequest));
                continue;
            }
            if (fieldClass.isAssignableFrom(HttpServletRequest.class)) {
                field.setAccessible(true);
                field.set(instance, httpServletRequest);
                continue;
            }
            if (fieldClass.isAssignableFrom(HttpServletResponse.class)) {
                field.setAccessible(true);
                field.set(instance, message.getContextualProperty("HTTP.RESPONSE"));
                continue;
            }
            if (fieldClass.isAssignableFrom(UriInfo.class)) {
                field.setAccessible(true);
                field.set(instance, new UriInfoImpl(message));
                continue;
            }
            if (!fieldClass.isAssignableFrom(User.class)) continue;
            field.setAccessible(true);
            field.set(instance, this._portal.getUser(httpServletRequest));
        }
    }
}

