/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.graphql.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLTypeExtension;
import com.liferay.portal.vulcan.graphql.servlet.ServletData;
import com.liferay.portal.vulcan.internal.accept.language.AcceptLanguageImpl;
import com.liferay.portal.vulcan.internal.configuration.VulcanConfiguration;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.ContextProviderUtil;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.FilterContextProvider;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.SortContextProvider;
import com.liferay.portal.vulcan.internal.jaxrs.param.converter.provider.SiteParamConverterProvider;
import com.liferay.portal.vulcan.internal.jaxrs.validation.ValidationUtil;
import com.liferay.portal.vulcan.internal.multipart.MultipartUtil;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import graphql.GraphQLError;
import graphql.Scalars;
import graphql.TypeResolutionEnvironment;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.directives.DirectiveWirer;
import graphql.annotations.directives.DirectiveWiringMapRetriever;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.graphQLProcessors.GraphQLInputProcessor;
import graphql.annotations.processor.graphQLProcessors.GraphQLOutputProcessor;
import graphql.annotations.processor.retrievers.GraphQLExtensionsHandler;
import graphql.annotations.processor.retrievers.GraphQLFieldRetriever;
import graphql.annotations.processor.retrievers.GraphQLInterfaceRetriever;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.retrievers.GraphQLTypeRetriever;
import graphql.annotations.processor.retrievers.fieldBuilders.ArgumentBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.DeprecateBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.DescriptionBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.DirectivesBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.method.MethodNameBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.method.MethodTypeBuilder;
import graphql.annotations.processor.searchAlgorithms.BreadthFirstSearch;
import graphql.annotations.processor.searchAlgorithms.ParentalSearch;
import graphql.annotations.processor.searchAlgorithms.SearchAlgorithm;
import graphql.annotations.processor.typeFunctions.DefaultTypeFunction;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.annotations.processor.util.NamingKit;
import graphql.annotations.processor.util.ReflectionKit;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.TypeResolver;
import graphql.servlet.ApolloScalars;
import graphql.servlet.DefaultGraphQLErrorHandler;
import graphql.servlet.GenericGraphQLError;
import graphql.servlet.GraphQLConfiguration;
import graphql.servlet.GraphQLContext;
import graphql.servlet.GraphQLErrorHandler;
import graphql.servlet.GraphQLHttpServlet;
import graphql.servlet.GraphQLObjectMapper;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import javax.validation.ValidationException;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={})
public class GraphQLServletExtender {
    private static final GraphQLScalarType _dateGraphQLScalarType;
    private static final GraphQLScalarType _objectGraphQLScalarType;
    private static final ObjectMapper _objectMapper;
    private BundleContext _bundleContext;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    private DefaultTypeFunction _defaultTypeFunction;
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    @Reference
    private FilterParserProvider _filterParserProvider;
    private GraphQLFieldRetriever _graphQLFieldRetriever;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    private volatile Servlet _servlet;
    private ServiceRegistration<ServletContextHelper> _servletContextHelperServiceRegistration;
    private final List<ServletData> _servletDataList = new ArrayList<ServletData>();
    private ServiceTracker<ServletData, ServletData> _servletDataServiceTracker;
    private ServiceRegistration<Servlet> _servletServiceRegistration;
    @Reference
    private SortParserProvider _sortParserProvider;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._graphQLFieldRetriever = new LiferayGraphQLFieldRetriever();
        final GraphQLInterfaceRetriever graphQLInterfaceRetriever = new GraphQLInterfaceRetriever();
        final GraphQLObjectInfoRetriever graphQLObjectInfoRetriever = new GraphQLObjectInfoRetriever(){

            public String getTypeName(Class<?> objectClass) {
                String graphQLName = GraphQLServletExtender._getGraphQLNameValue(objectClass);
                if (graphQLName == null) {
                    return NamingKit.toGraphqlName((String)objectClass.getName());
                }
                return NamingKit.toGraphqlName((String)graphQLName);
            }

            public Boolean isGraphQLField(AnnotatedElement element) {
                GraphQLField graphQLField = element.getAnnotation(GraphQLField.class);
                if (graphQLField == null) {
                    return null;
                }
                return graphQLField.value();
            }
        };
        final BreadthFirstSearch breadthFirstSearch = new BreadthFirstSearch(graphQLObjectInfoRetriever);
        final ParentalSearch parentalSearch = new ParentalSearch(graphQLObjectInfoRetriever);
        final GraphQLTypeRetriever graphQLTypeRetriever = new GraphQLTypeRetriever(){
            {
                this.setExtensionsHandler(new GraphQLExtensionsHandler(){
                    {
                        this.setFieldRetriever(GraphQLServletExtender.this._graphQLFieldRetriever);
                        this.setFieldSearchAlgorithm((SearchAlgorithm)parentalSearch);
                        this.setGraphQLObjectInfoRetriever(graphQLObjectInfoRetriever);
                        this.setMethodSearchAlgorithm((SearchAlgorithm)breadthFirstSearch);
                    }
                });
                this.setFieldSearchAlgorithm((SearchAlgorithm)parentalSearch);
                this.setGraphQLFieldRetriever(GraphQLServletExtender.this._graphQLFieldRetriever);
                this.setGraphQLInterfaceRetriever(graphQLInterfaceRetriever);
                this.setGraphQLObjectInfoRetriever(graphQLObjectInfoRetriever);
                this.setMethodSearchAlgorithm((SearchAlgorithm)breadthFirstSearch);
            }
        };
        graphQLInterfaceRetriever.setGraphQLTypeRetriever(graphQLTypeRetriever);
        this._defaultTypeFunction = new DefaultTypeFunction(new GraphQLInputProcessor(){
            {
                this.setGraphQLTypeRetriever(graphQLTypeRetriever);
            }
        }, new GraphQLOutputProcessor(){
            {
                this.setGraphQLTypeRetriever(graphQLTypeRetriever);
            }
        });
        this._defaultTypeFunction.register((TypeFunction)new DateTypeFunction());
        this._defaultTypeFunction.register((TypeFunction)new ObjectTypeFunction());
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("osgi.http.whiteboard.context.name", "GraphQL");
        properties.put("osgi.http.whiteboard.context.path", "/graphql");
        properties.put("osgi.http.whiteboard.filter.servlet", "GraphQL");
        this._servletContextHelperServiceRegistration = bundleContext.registerService(ServletContextHelper.class, (Object)new ServletContextHelper(bundleContext.getBundle()){}, (Dictionary)properties);
        this._servletDataServiceTracker = new ServiceTracker(bundleContext, ServletData.class, (ServiceTrackerCustomizer)new ServletDataServiceTrackerCustomizer());
        this._servletDataServiceTracker.open();
        properties = new HashMapDictionary();
        properties.put("osgi.http.whiteboard.context.select", "GraphQL");
        properties.put("osgi.http.whiteboard.servlet.name", "GraphQL");
        properties.put("osgi.http.whiteboard.servlet.pattern", "/*");
        this._servletServiceRegistration = this._bundleContext.registerService(Servlet.class, (Object)((Servlet)ProxyUtil.newProxyInstance((ClassLoader)GraphQLServletExtender.class.getClassLoader(), (Class[])new Class[]{Servlet.class}, (InvocationHandler)new InvocationHandler(){
            private ServletConfig _servletConfig;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                if (methodName.equals("destroy")) {
                    return null;
                }
                if (methodName.equals("getServletInfo")) {
                    return "";
                }
                if (methodName.equals("hashCode")) {
                    return this.hashCode();
                }
                if (methodName.equals("init") && args.length > 0) {
                    this._servletConfig = (ServletConfig)args[0];
                    return null;
                }
                Servlet servlet = GraphQLServletExtender.this._createServlet();
                servlet.init(this._servletConfig);
                try {
                    return method.invoke((Object)servlet, args);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getCause();
                }
            }
        })), (Dictionary)properties);
    }

    @Deactivate
    protected void deactivate() {
        this._servletDataServiceTracker.close();
        this._servletServiceRegistration.unregister();
        this._servletContextHelperServiceRegistration.unregister();
    }

    private static Object _getAnnotationValue(AnnotatedElement annotatedElement, Class clazz) {
        for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
            Class<? extends Annotation> typeClass = annotation.annotationType();
            String name = typeClass.getName();
            if (!name.equals(clazz.getName())) continue;
            try {
                Method method = typeClass.getMethod("value", new Class[0]);
                return method.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static String _getGraphQLNameValue(AnnotatedElement annotatedElement) {
        com.liferay.portal.vulcan.graphql.annotation.GraphQLName graphQLName = annotatedElement.getAnnotation(com.liferay.portal.vulcan.graphql.annotation.GraphQLName.class);
        if (graphQLName != null) {
            return graphQLName.value();
        }
        Object value = GraphQLServletExtender._getAnnotationValue(annotatedElement, GraphQLName.class);
        if (value == null) {
            return null;
        }
        return (String)value;
    }

    private static boolean _isMultipartBody(Parameter parameter) {
        Class<?> clazz = parameter.getType();
        String typeName = clazz.getTypeName();
        return typeName.contains("MultipartBody");
    }

    private void _collectObjectFields(GraphQLObjectType.Builder builder, Function<ServletData, Object> function, ProcessingElementsContainer processingElementsContainer, List<ServletData> servletDatas) {
        Stream stream = servletDatas.stream();
        Map<String, Optional<Method>> methods = stream.map(function).map(Object::getClass).map(Class::getMethods).flatMap(Arrays::stream).filter(method -> Boolean.TRUE.equals(this._getGraphQLFieldValue((AnnotatedElement)method))).collect(Collectors.groupingBy(Method::getName, Collectors.maxBy(Comparator.comparingInt(this::_getVersion))));
        for (Optional<Method> methodOptional : methods.values()) {
            if (!methodOptional.isPresent()) continue;
            Method method2 = methodOptional.get();
            Class<?> clazz = method2.getDeclaringClass();
            builder.field(this._graphQLFieldRetriever.getField(clazz.getSimpleName(), method2, processingElementsContainer));
        }
    }

    private Message _createMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        MessageImpl message = new MessageImpl();
        String requestURL = String.valueOf(httpServletRequest.getRequestURL());
        message.put((Object)Message.ENDPOINT_ADDRESS, (Object)requestURL);
        String contextPath = GetterUtil.getString((String)httpServletRequest.getContextPath());
        String servletPath = GetterUtil.getString((String)httpServletRequest.getServletPath());
        message.put((Object)Message.PATH_INFO, (Object)(contextPath + servletPath + httpServletRequest.getPathInfo()));
        message.put((Object)Message.QUERY_STRING, (Object)httpServletRequest.getQueryString());
        message.put((Object)"Accept", (Object)httpServletRequest.getHeader("Accept"));
        message.put((Object)"Content-Type", (Object)httpServletRequest.getContentType());
        message.put((Object)"HTTP.REQUEST", (Object)httpServletRequest);
        message.put((Object)"HTTP.RESPONSE", (Object)httpServletResponse);
        message.put((Object)"org.apache.cxf.async.post.response.dispatch", (Object)true);
        message.put((Object)"org.apache.cxf.request.method", (Object)httpServletRequest.getMethod());
        message.put((Object)"org.apache.cxf.request.uri", (Object)httpServletRequest.getRequestURI());
        message.put((Object)"org.apache.cxf.request.url", (Object)requestURL);
        message.put((Object)"http.base.path", (Object)this._getBasePath(contextPath, httpServletRequest.getRequestURI(), requestURL, servletPath));
        message.setExchange((Exchange)new ExchangeImpl());
        return message;
    }

    private GraphQLFieldDefinition _createNodeGraphQLFieldDefinition(GraphQLOutputType graphQLOutputType) {
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        builder.argument(GraphQLArgument.newArgument().name("dataType").type((GraphQLInputType)Scalars.GraphQLString).build());
        builder.argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)Scalars.GraphQLLong).build());
        builder.name("graphQLNode");
        builder.type(graphQLOutputType);
        return builder.build();
    }

    private GraphQLInterfaceType _createNodeGraphQLInterfaceType() {
        GraphQLInterfaceType.Builder interfaceBuilder = GraphQLInterfaceType.newInterface();
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition();
        interfaceBuilder.field(fieldBuilder.name("id").type((GraphQLOutputType)Scalars.GraphQLLong).build());
        interfaceBuilder.name("GraphQLNode");
        return interfaceBuilder.build();
    }

    private Object _createObject(DataFetchingEnvironment dataFetchingEnvironment, Method method) throws Exception {
        Object instance = null;
        GraphQLFieldDefinition graphQLFieldDefinition = dataFetchingEnvironment.getFieldDefinition();
        if (dataFetchingEnvironment.getRoot() == dataFetchingEnvironment.getSource() || Objects.equals(graphQLFieldDefinition.getName(), "graphQLNode")) {
            instance = this._createQueryInstance(method.getDeclaringClass(), dataFetchingEnvironment);
        } else {
            Class<?> declaringClass = method.getDeclaringClass();
            Field field = declaringClass.getDeclaredField("this$0");
            Object queryInstance = this._createQueryInstance(field.getType(), dataFetchingEnvironment);
            Constructor<?>[] constructors = declaringClass.getConstructors();
            instance = ReflectionKit.constructNewInstance(constructors[0], (Object[])new Object[]{queryInstance, dataFetchingEnvironment.getSource()});
        }
        Parameter[] parameters = method.getParameters();
        Map arguments = dataFetchingEnvironment.getArguments();
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            String parameterName = null;
            String graphQLName = GraphQLServletExtender._getGraphQLNameValue(parameter);
            parameterName = graphQLName == null ? NamingKit.toGraphqlName((String)parameter.getName()) : NamingKit.toGraphqlName((String)graphQLName);
            Object argument = arguments.get(parameterName);
            if (argument == null) {
                if (parameter.isAnnotationPresent(NotNull.class)) {
                    throw new ValidationException(parameterName + " is null");
                }
                if (parameterName.equals("page")) {
                    argument = 1;
                } else if (parameterName.equals("pageSize")) {
                    argument = 20;
                }
            }
            if (parameterName.equals("siteKey") && argument != null) {
                SiteParamConverterProvider siteParamConverterProvider = new SiteParamConverterProvider(this._groupLocalService);
                args[i - 1] = (long)siteParamConverterProvider.getGroupId(CompanyThreadLocal.getCompanyId(), (String)argument);
            }
            if (GraphQLServletExtender._isMultipartBody(parameter)) {
                HashMap<String, BinaryFile> binaryFiles = new HashMap<String, BinaryFile>();
                List parts = (List)argument;
                if (parts != null && !parts.isEmpty()) {
                    Part metadataPart;
                    String metadata;
                    int index;
                    Part part = (Part)parts.get(0);
                    binaryFiles.put("file", new BinaryFile(part.getContentType(), MultipartUtil.getFileName(part), part.getInputStream(), part.getSize()));
                    HashMap<String, String> values = new HashMap<String, String>();
                    if (parts.size() > 1 && (index = (metadata = StringUtil.read((InputStream)(metadataPart = (Part)parts.get(1)).getInputStream())).indexOf("=")) != -1) {
                        values.put(metadata.substring(0, index), metadata.substring(index + 1));
                    }
                    argument = MultipartBody.of(binaryFiles, __ -> _objectMapper, values);
                }
            }
            Class<Map> parameterClass = parameter.getClass();
            if (argument instanceof Map && !parameterClass.isAssignableFrom(Map.class)) {
                argument = _objectMapper.convertValue(argument, parameter.getType());
                ValidationUtil.validate(argument);
            }
            args[i] = argument;
        }
        ValidationUtil.validateArguments(instance, method, args);
        return method.invoke(instance, args);
    }

    private Object _createQueryInstance(Class clazz, DataFetchingEnvironment dataFetchingEnvironment) throws Exception {
        GraphQLContext graphQLContext = (GraphQLContext)dataFetchingEnvironment.getContext();
        Optional httpServletRequestOptional = graphQLContext.getHttpServletRequest();
        HttpServletRequest httpServletRequest = httpServletRequestOptional.orElse(null);
        Optional httpServletResponseOptional = graphQLContext.getHttpServletResponse();
        HttpServletResponse httpServletResponse = httpServletResponseOptional.orElse(null);
        AcceptLanguageImpl acceptLanguage = new AcceptLanguageImpl(httpServletRequest, this._language, this._portal);
        Object instance = clazz.newInstance();
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            Class<Object> fieldClass = field.getType();
            if (fieldClass.isAssignableFrom(AcceptLanguage.class)) {
                field.setAccessible(true);
                field.set(instance, acceptLanguage);
                continue;
            }
            if (fieldClass.isAssignableFrom(Company.class)) {
                field.setAccessible(true);
                field.set(instance, this._companyLocalService.getCompany(CompanyThreadLocal.getCompanyId().longValue()));
                continue;
            }
            if (fieldClass.isAssignableFrom(HttpServletRequest.class)) {
                field.setAccessible(true);
                field.set(instance, httpServletRequest);
                continue;
            }
            if (fieldClass.isAssignableFrom(HttpServletResponse.class)) {
                field.setAccessible(true);
                field.set(instance, httpServletResponseOptional.orElse(null));
                continue;
            }
            if (fieldClass.isAssignableFrom(UriInfo.class)) {
                field.setAccessible(true);
                field.set(instance, new UriInfoImpl(this._createMessage(httpServletRequest, httpServletResponse)));
                continue;
            }
            if (fieldClass.isAssignableFrom(User.class)) {
                field.setAccessible(true);
                field.set(instance, this._portal.getUser((HttpServletRequest)httpServletRequestOptional.orElse(null)));
                continue;
            }
            if (Objects.equals(field.getName(), "_filterBiFunction")) {
                field.setAccessible(true);
                BiFunction<Object, String, Filter> filterBiFunction = (resource, filterString) -> {
                    try {
                        FilterContextProvider filterContextProvider = new FilterContextProvider(this._expressionConvert, this._filterParserProvider, this._language, this._portal);
                        return filterContextProvider.createContext(acceptLanguage, this._getEntityModel(resource, httpServletRequest.getParameterMap()), (String)filterString);
                    }
                    catch (Exception e) {
                        throw new BadRequestException((Throwable)e);
                    }
                };
                field.set(instance, filterBiFunction);
                continue;
            }
            if (!Objects.equals(field.getName(), "_sortsBiFunction")) continue;
            field.setAccessible(true);
            BiFunction<Object, String, Sort[]> sortsBiFunction = (resource, sortsString) -> {
                try {
                    SortContextProvider sortContextProvider = new SortContextProvider(this._language, this._portal, this._sortParserProvider);
                    return sortContextProvider.createContext(acceptLanguage, this._getEntityModel(resource, httpServletRequest.getParameterMap()), (String)sortsString);
                }
                catch (Exception e) {
                    throw new BadRequestException((Throwable)e);
                }
            };
            field.set(instance, sortsBiFunction);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Servlet _createServlet() throws Exception {
        Servlet servlet = this._servlet;
        if (servlet != null) {
            return servlet;
        }
        List<ServletData> list = this._servletDataList;
        synchronized (list) {
            if (this._servlet != null) {
                return this._servlet;
            }
            ProcessingElementsContainer processingElementsContainer = new ProcessingElementsContainer((TypeFunction)this._defaultTypeFunction);
            Map classesMap = processingElementsContainer.getExtensionsTypeRegistry();
            ArrayList<ServletData> servletDatas = new ArrayList<ServletData>();
            for (ServletData servletData : this._servletDataList) {
                if (this._isGraphQLEnabled(servletData.getPath())) {
                    servletDatas.add(servletData);
                }
                Object query = servletData.getQuery();
                Class<?> queryClass = query.getClass();
                for (Class<?> innerClasses : queryClass.getClasses()) {
                    if (!innerClasses.isAnnotationPresent(GraphQLTypeExtension.class)) continue;
                    GraphQLTypeExtension graphQLTypeExtension = innerClasses.getAnnotation(GraphQLTypeExtension.class);
                    Class clazz = graphQLTypeExtension.value();
                    if (!classesMap.containsKey(clazz)) {
                        classesMap.put(clazz, new HashSet());
                    }
                    Set classes = (Set)classesMap.get(clazz);
                    classes.add(innerClasses);
                }
            }
            GraphQLSchema.Builder graphQLSchemaBuilder = GraphQLSchema.newSchema();
            GraphQLObjectType.Builder mutationBuilder = GraphQLObjectType.newObject();
            mutationBuilder.name("mutation");
            GraphQLObjectType.Builder graphQLObjectTypeBuilder = GraphQLObjectType.newObject();
            graphQLObjectTypeBuilder.name("query");
            this._collectObjectFields(mutationBuilder, ServletData::getMutation, processingElementsContainer, servletDatas);
            this._collectObjectFields(graphQLObjectTypeBuilder, ServletData::getQuery, processingElementsContainer, servletDatas);
            this._registerInterfaces(processingElementsContainer, graphQLObjectTypeBuilder, graphQLSchemaBuilder);
            graphQLSchemaBuilder.mutation(mutationBuilder.build());
            graphQLSchemaBuilder.query(graphQLObjectTypeBuilder.build());
            GraphQLConfiguration.Builder graphQLConfigurationBuilder = GraphQLConfiguration.with((GraphQLSchema)graphQLSchemaBuilder.build());
            GraphQLObjectMapper.Builder objectMapperBuilder = GraphQLObjectMapper.newBuilder();
            objectMapperBuilder.withGraphQLErrorHandler((GraphQLErrorHandler)new LiferayGraphQLErrorHandler());
            graphQLConfigurationBuilder.with(objectMapperBuilder.build());
            this._servlet = GraphQLHttpServlet.with((GraphQLConfiguration)graphQLConfigurationBuilder.build());
            return this._servlet;
        }
    }

    private String _getBasePath(String contextPath, String requestURI, String requestURL, String servletPath) {
        int index;
        if (!StringUtils.isEmpty((String)requestURI)) {
            int index2 = requestURL.indexOf(requestURI);
            if (index2 > 0) {
                return requestURL.substring(0, index2) + contextPath;
            }
        } else if (!StringUtils.isEmpty((String)servletPath) && requestURL.endsWith(servletPath) && (index = requestURL.lastIndexOf(servletPath)) > 0) {
            return requestURL.substring(0, index);
        }
        return null;
    }

    private EntityModel _getEntityModel(Object resource, Map<String, String[]> parameterMap) throws Exception {
        EntityModelResource entityModelResource = (EntityModelResource)resource;
        return entityModelResource.getEntityModel(ContextProviderUtil.getMultivaluedHashMap(parameterMap));
    }

    private Field _getFieldDefinitionsByNameField(GraphQLObjectType graphQLObjectType) throws NoSuchFieldException {
        Class<?> clazz = graphQLObjectType.getClass();
        Field field = clazz.getDeclaredField("fieldDefinitionsByName");
        field.setAccessible(true);
        return field;
    }

    private Boolean _getGraphQLFieldValue(AnnotatedElement annotatedElement) {
        GraphQLField graphQLField = annotatedElement.getAnnotation(GraphQLField.class);
        if (graphQLField != null) {
            return graphQLField.value();
        }
        Object value = GraphQLServletExtender._getAnnotationValue(annotatedElement, graphql.annotations.annotationTypes.GraphQLField.class);
        if (value == null) {
            return null;
        }
        return (Boolean)value;
    }

    private Integer _getVersion(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        Package pkg = clazz.getPackage();
        String packageString = pkg.toString();
        String[] packageNames = packageString.split("\\.");
        String version = packageNames[packageNames.length - 1];
        return Integer.valueOf(version.replaceAll("\\D", ""));
    }

    private boolean _isGraphQLEnabled(String path) throws Exception {
        String filterString = String.format("(&(path=%s)(service.factoryPid=%s))", path.substring(0, path.indexOf("-graphql")), VulcanConfiguration.class.getName());
        Object[] configurations = this._configurationAdmin.listConfigurations(filterString);
        if (!ArrayUtil.isEmpty((Object[])configurations)) {
            Dictionary dictionary = configurations[0].getProperties();
            return (Boolean)dictionary.get("graphQLEnabled");
        }
        return true;
    }

    private void _registerInterfaces(ProcessingElementsContainer processingElementsContainer, GraphQLObjectType.Builder graphQLObjectTypeBuilder, GraphQLSchema.Builder graphQLSchemaBuilder) {
        try {
            Map graphQLTypes = processingElementsContainer.getTypeRegistry();
            GraphQLInterfaceType graphQLInterfaceType = this._createNodeGraphQLInterfaceType();
            graphQLTypes.put("GraphQLNode", graphQLInterfaceType);
            graphQLObjectTypeBuilder.field(this._createNodeGraphQLFieldDefinition((GraphQLOutputType)graphQLInterfaceType));
            GraphQLCodeRegistry.Builder builder = processingElementsContainer.getCodeRegistryBuilder();
            graphQLSchemaBuilder.codeRegistry(builder.dataFetcher(FieldCoordinates.coordinates((String)"query", (String)"graphQLNode"), (DataFetcher)new NodeDataFetcher()).typeResolver("GraphQLNode", (TypeResolver)new GraphQLNodeTypeResolver()).build());
            for (Map.Entry entry : graphQLTypes.entrySet()) {
                GraphQLObjectType graphQLObjectType;
                GraphQLFieldDefinition graphQLFieldDefinition;
                GraphQLType graphQLType = (GraphQLType)entry.getValue();
                if (!(graphQLType instanceof GraphQLObjectType) || (graphQLFieldDefinition = (graphQLObjectType = (GraphQLObjectType)graphQLType).getFieldDefinition("id")) == null || graphQLFieldDefinition.getType() != Scalars.GraphQLLong) continue;
                this._replaceFieldDefinition(graphQLInterfaceType, graphQLObjectType);
                this._replaceFieldNodes(builder, graphQLInterfaceType, graphQLObjectType, graphQLSchemaBuilder);
                this._replaceInterface(graphQLInterfaceType, graphQLObjectType);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void _replaceFieldDefinition(GraphQLInterfaceType graphQLInterfaceType, GraphQLObjectType graphQLObjectType) throws Exception {
        Field field = this._getFieldDefinitionsByNameField(graphQLObjectType);
        Map graphQLFieldDefinitions = (Map)field.get(graphQLObjectType);
        for (GraphQLFieldDefinition graphQLFieldDefinition : graphQLObjectType.getFieldDefinitions()) {
            GraphQLOutputType graphQLOutputType = graphQLFieldDefinition.getType();
            String typeName = graphQLOutputType.getName();
            if (typeName == null || !typeName.equals("Object")) continue;
            Class<?> fieldClass = graphQLFieldDefinition.getClass();
            Method method = fieldClass.getDeclaredMethod("replaceType", GraphQLOutputType.class);
            method.setAccessible(true);
            method.invoke((Object)graphQLFieldDefinition, graphQLInterfaceType);
            graphQLFieldDefinitions.put(graphQLFieldDefinition.getName(), graphQLFieldDefinition);
        }
        field.set(graphQLObjectType, graphQLFieldDefinitions);
    }

    private void _replaceFieldNodes(GraphQLCodeRegistry.Builder builder, GraphQLInterfaceType graphQLInterfaceType, GraphQLObjectType graphQLObjectType, GraphQLSchema.Builder graphQLSchemaBuilder) throws Exception {
        GraphQLFieldDefinition graphQLFieldDefinition = graphQLObjectType.getFieldDefinition("contentType");
        if (graphQLFieldDefinition != null) {
            Field field = this._getFieldDefinitionsByNameField(graphQLObjectType);
            Map graphQLFieldDefinitions = (Map)field.get(graphQLObjectType);
            GraphQLFieldDefinition.Builder graphQLFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition();
            graphQLFieldDefinitions.put("graphQLNode", graphQLFieldDefinitionBuilder.name("graphQLNode").type((GraphQLOutputType)graphQLInterfaceType).build());
            graphQLSchemaBuilder.codeRegistry(builder.dataFetcher(FieldCoordinates.coordinates((String)graphQLObjectType.getName(), (String)"graphQLNode"), (DataFetcher)new GraphQLNodePropertyDataFetcher()).typeResolver("GraphQLNode", (TypeResolver)new GraphQLNodeTypeResolver()).build());
            field.set(graphQLObjectType, graphQLFieldDefinitions);
        }
    }

    private void _replaceInterface(GraphQLInterfaceType graphQLInterfaceType, GraphQLObjectType graphQLObjectType) throws Exception {
        Class<?> clazz = graphQLObjectType.getClass();
        Method method = clazz.getDeclaredMethod("replaceInterfaces", List.class);
        method.setAccessible(true);
        method.invoke((Object)graphQLObjectType, Collections.singletonList(graphQLInterfaceType));
    }

    static {
        _objectMapper = new ObjectMapper();
        GraphQLScalarType.Builder dateBuilder = new GraphQLScalarType.Builder();
        _dateGraphQLScalarType = dateBuilder.name("Date").description("An RFC-3339 compliant date time scalar").coercing((Coercing)new Coercing<Date, String>(){

            public Date parseLiteral(Object value) throws CoercingParseLiteralException {
                return this._toDate(value);
            }

            public Date parseValue(Object value) throws CoercingParseValueException {
                return this._toDate(value);
            }

            public String serialize(Object value) throws CoercingSerializeException {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                return simpleDateFormat.format((Date)value);
            }

            private Date _toDate(Object value) {
                if (value instanceof Date) {
                    return (Date)value;
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                try {
                    if (value instanceof StringValue) {
                        StringValue stringValue = (StringValue)value;
                        return simpleDateFormat.parse(stringValue.getValue());
                    }
                    return simpleDateFormat.parse(value.toString());
                }
                catch (ParseException pe) {
                    throw new CoercingSerializeException("Unable to parse " + value, (Throwable)pe);
                }
            }
        }).build();
        GraphQLScalarType.Builder objectBuilder = new GraphQLScalarType.Builder();
        _objectGraphQLScalarType = objectBuilder.name("Object").description("Any kind of object supported by basic scalar types").coercing((Coercing)new Coercing<Object, Object>(){

            public Object parseLiteral(Object value) throws CoercingParseLiteralException {
                if (value instanceof ArrayValue) {
                    ArrayValue arrayValue = (ArrayValue)value;
                    List values = arrayValue.getValues();
                    Stream stream = values.stream();
                    return stream.map(this::parseLiteral).collect(Collectors.toList());
                }
                if (value instanceof BooleanValue) {
                    BooleanValue booleanValue = (BooleanValue)value;
                    return booleanValue.isValue();
                }
                if (value instanceof EnumValue) {
                    EnumValue enumValue = (EnumValue)value;
                    return enumValue.getName();
                }
                if (value instanceof FloatValue) {
                    FloatValue floatValue = (FloatValue)value;
                    return floatValue.getValue();
                }
                if (value instanceof IntValue) {
                    IntValue intValue = (IntValue)value;
                    return intValue.getValue();
                }
                if (value instanceof NullValue) {
                    return null;
                }
                if (value instanceof ObjectValue) {
                    ObjectValue objectValue = (ObjectValue)value;
                    List objectFields = objectValue.getObjectFields();
                    Stream stream = objectFields.stream();
                    return stream.collect(Collectors.toMap(ObjectField::getName, objectField -> this.parseLiteral(objectField.getValue())));
                }
                if (value instanceof StringValue) {
                    StringValue stringValue = (StringValue)value;
                    return stringValue.getValue();
                }
                throw new CoercingSerializeException("Unable to parse " + value);
            }

            public Object parseValue(Object value) throws CoercingParseValueException {
                return value;
            }

            public Object serialize(Object value) throws CoercingSerializeException {
                return value;
            }
        }).build();
    }

    private class ServletDataServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ServletData, ServletData> {
        private ServletDataServiceTrackerCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServletData addingService(ServiceReference<ServletData> serviceReference) {
            ServletData servletData = (ServletData)GraphQLServletExtender.this._bundleContext.getService(serviceReference);
            List list = GraphQLServletExtender.this._servletDataList;
            synchronized (list) {
                GraphQLServletExtender.this._servletDataList.add(servletData);
                GraphQLServletExtender.this._servlet = null;
            }
            return servletData;
        }

        public void modifiedService(ServiceReference<ServletData> serviceReference, ServletData servletData) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<ServletData> serviceReference, ServletData servletData) {
            List list = GraphQLServletExtender.this._servletDataList;
            synchronized (list) {
                GraphQLServletExtender.this._servletDataList.remove(servletData);
                GraphQLServletExtender.this._servlet = null;
            }
            GraphQLServletExtender.this._bundleContext.ungetService(serviceReference);
        }
    }

    private class LiferayMethodDataFetcher
    implements DataFetcher<Object> {
        private final Method _method;

        public Object get(DataFetchingEnvironment dataFetchingEnvironment) {
            try {
                return GraphQLServletExtender.this._createObject(dataFetchingEnvironment, this._method);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite.getTargetException());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private LiferayMethodDataFetcher(Method method) {
            this._method = method;
        }
    }

    private class LiferayGraphQLFieldRetriever
    extends GraphQLFieldRetriever {
        private LiferayGraphQLFieldRetriever() {
        }

        public GraphQLFieldDefinition getField(String parentName, Method method, ProcessingElementsContainer processingElementsContainer) {
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            MethodTypeBuilder methodTypeBuilder = new MethodTypeBuilder(method, processingElementsContainer.getDefaultTypeFunction(), processingElementsContainer, false);
            GraphQLOutputType graphQLOutputType = (GraphQLOutputType)methodTypeBuilder.build();
            LiferayArgumentBuilder argumentBuilder = new LiferayArgumentBuilder(method, processingElementsContainer.getDefaultTypeFunction(), builder, processingElementsContainer, graphQLOutputType);
            builder.arguments(argumentBuilder.build());
            builder.dataFetcher((DataFetcher)new LiferayMethodDataFetcher(method));
            LiferayDeprecateBuilder deprecateBuilder = new LiferayDeprecateBuilder(method);
            builder.deprecate(deprecateBuilder.build());
            DescriptionBuilder descriptionBuilder = new DescriptionBuilder((AccessibleObject)method);
            builder.description(descriptionBuilder.build());
            MethodNameBuilder methodNameBuilder = new MethodNameBuilder(method);
            builder.name(methodNameBuilder.build());
            builder.type(graphQLOutputType);
            return builder.build();
        }
    }

    private static class ObjectTypeFunction
    implements TypeFunction {
        private ObjectTypeFunction() {
        }

        public GraphQLType buildType(boolean input, Class<?> clazz, AnnotatedType annotatedType, ProcessingElementsContainer processingElementsContainer) {
            return _objectGraphQLScalarType;
        }

        public boolean canBuildType(Class<?> clazz, AnnotatedType annotatedType) {
            return clazz == Map.class || clazz == MultipartBody.class || clazz == Object.class || clazz == Response.class;
        }
    }

    private static class NodeDataFetcher
    implements DataFetcher<Object> {
        private NodeDataFetcher() {
        }

        public Object get(DataFetchingEnvironment dataFetchingEnvironment) throws Exception {
            GraphQLSchema graphQLSchema = dataFetchingEnvironment.getGraphQLSchema();
            GraphQLCodeRegistry graphQLCodeRegistry = graphQLSchema.getCodeRegistry();
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            GraphQLFieldDefinition graphQLFieldDefinition = dataFetchingEnvironment.getFieldDefinition();
            String fieldName = this._getFieldName(dataFetchingEnvironment, graphQLSchema);
            DataFetcher dataFetcher = graphQLCodeRegistry.getDataFetcher((GraphQLFieldsContainer)dataFetchingEnvironment.getParentType(), builder.argument(graphQLFieldDefinition.getArgument("id")).name(fieldName).type(graphQLFieldDefinition.getType()).build());
            DataFetchingEnvironmentImpl.Builder dataFetchingEnvironmentBuilder = DataFetchingEnvironmentImpl.newDataFetchingEnvironment((DataFetchingEnvironment)dataFetchingEnvironment);
            return dataFetcher.get(dataFetchingEnvironmentBuilder.arguments(Collections.singletonMap(fieldName + "Id", dataFetchingEnvironment.getArgument("id"))).build());
        }

        private String _getFieldName(DataFetchingEnvironment dataFetchingEnvironment, GraphQLSchema graphQLSchema) {
            Map graphQLTypes = graphQLSchema.getTypeMap();
            GraphQLType graphQLType = (GraphQLType)graphQLTypes.get(dataFetchingEnvironment.getArgument("dataType"));
            return StringUtil.lowerCaseFirstLetter((String)graphQLType.getName());
        }
    }

    private static class LiferayGraphQLErrorHandler
    extends DefaultGraphQLErrorHandler {
        private LiferayGraphQLErrorHandler() {
        }

        protected List<GraphQLError> filterGraphQLErrors(List<GraphQLError> graphQLErrors) {
            Stream stream = graphQLErrors.stream();
            return stream.map(graphQLError -> {
                if (!this.isClientError((GraphQLError)graphQLError)) {
                    return new GenericGraphQLError(graphQLError.getMessage());
                }
                return graphQLError;
            }).collect(Collectors.toList());
        }
    }

    private static class LiferayDeprecateBuilder
    extends DeprecateBuilder {
        private final AccessibleObject _accessibleObject;

        public LiferayDeprecateBuilder(AccessibleObject accessibleObject) {
            super(accessibleObject);
            this._accessibleObject = accessibleObject;
        }

        public String build() {
            Deprecated deprecated = this._accessibleObject.getAnnotation(Deprecated.class);
            if (deprecated != null) {
                return "Deprecated";
            }
            return null;
        }
    }

    private static class LiferayArgumentBuilder
    extends ArgumentBuilder {
        private Method _method;
        private final ProcessingElementsContainer _processingElementsContainer;
        private final TypeFunction _typeFunction;

        public LiferayArgumentBuilder(Method method, TypeFunction typeFunction, GraphQLFieldDefinition.Builder builder, ProcessingElementsContainer processingElementsContainer, GraphQLOutputType graphQLOutputType) {
            super(method, typeFunction, builder, processingElementsContainer, graphQLOutputType);
            this._method = method;
            this._typeFunction = typeFunction;
            this._processingElementsContainer = processingElementsContainer;
        }

        public List<GraphQLArgument> build() {
            Stream<Parameter> stream = Arrays.stream(this._method.getParameters());
            return stream.filter(parameter -> !DataFetchingEnvironment.class.isAssignableFrom(parameter.getType())).map(parameter -> {
                if (GraphQLServletExtender._isMultipartBody(parameter)) {
                    GraphQLArgument.Builder builder = new GraphQLArgument.Builder();
                    return builder.type((GraphQLInputType)new GraphQLList((GraphQLType)ApolloScalars.Upload)).name("multipartBody").build();
                }
                return this._createGraphQLArgument((Parameter)parameter, (GraphQLInputType)this._typeFunction.buildType(true, parameter.getType(), parameter.getAnnotatedType(), this._processingElementsContainer));
            }).collect(Collectors.toList());
        }

        private GraphQLArgument _createGraphQLArgument(Parameter parameter, GraphQLInputType graphQLInputType) throws GraphQLAnnotationsException {
            DirectiveWirer directiveWirer = new DirectiveWirer();
            GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
            String graphQLName = GraphQLServletExtender._getGraphQLNameValue(parameter);
            if (graphQLName != null) {
                builder.name(NamingKit.toGraphqlName((String)graphQLName));
            } else {
                builder.name(NamingKit.toGraphqlName((String)parameter.getName()));
            }
            builder.type(graphQLInputType);
            DirectivesBuilder directivesBuilder = new DirectivesBuilder((AnnotatedElement)parameter, this._processingElementsContainer);
            builder.withDirectives(directivesBuilder.build());
            DirectiveWiringMapRetriever directiveWiringMapRetriever = new DirectiveWiringMapRetriever();
            return (GraphQLArgument)directiveWirer.wire((GraphQLDirectiveContainer)builder.build(), directiveWiringMapRetriever.getDirectiveWiringMap((AnnotatedElement)parameter, this._processingElementsContainer), this._processingElementsContainer.getCodeRegistryBuilder(), graphQLInputType.getName());
        }
    }

    private static class GraphQLNodeTypeResolver
    implements TypeResolver {
        private GraphQLNodeTypeResolver() {
        }

        public GraphQLObjectType getType(TypeResolutionEnvironment typeResolutionEnvironment) {
            GraphQLSchema graphQLSchema = typeResolutionEnvironment.getSchema();
            Map graphQLTypes = graphQLSchema.getTypeMap();
            GraphQLType graphQLType = (GraphQLType)graphQLTypes.get(this._getClassName(typeResolutionEnvironment.getObject()));
            return (GraphQLObjectType)graphQLType;
        }

        private String _getClassName(Object object) {
            Class<?> clazz = object.getClass();
            String name = clazz.getName();
            if (!name.contains("$")) {
                return clazz.getSimpleName();
            }
            Class<?> parentClass = clazz.getSuperclass();
            return parentClass.getSimpleName();
        }
    }

    private static class GraphQLNodePropertyDataFetcher
    implements DataFetcher<Object> {
        private GraphQLNodePropertyDataFetcher() {
        }

        public Object get(DataFetchingEnvironment dataFetchingEnvironment) throws Exception {
            GraphQLSchema graphQLSchema = dataFetchingEnvironment.getGraphQLSchema();
            GraphQLCodeRegistry graphQLCodeRegistry = graphQLSchema.getCodeRegistry();
            Map graphQLTypes = graphQLSchema.getTypeMap();
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            Object source = dataFetchingEnvironment.getSource();
            Class<?> clazz = source.getClass();
            Method getContentTypeMethod = clazz.getMethod("getContentType", new Class[0]);
            String fieldName = StringUtil.lowerCaseFirstLetter((String)((String)getContentTypeMethod.invoke(source, new Object[0])));
            GraphQLFieldDefinition graphQLFieldDefinition = dataFetchingEnvironment.getFieldDefinition();
            DataFetcher dataFetcher = graphQLCodeRegistry.getDataFetcher((GraphQLFieldsContainer)graphQLTypes.get("query"), builder.name(fieldName).type(graphQLFieldDefinition.getType()).build());
            DataFetchingEnvironmentImpl.Builder dataFetchingEnvironmentBuilder = DataFetchingEnvironmentImpl.newDataFetchingEnvironment((DataFetchingEnvironment)dataFetchingEnvironment);
            Method getIdMethod = clazz.getMethod("getId", new Class[0]);
            return dataFetcher.get(dataFetchingEnvironmentBuilder.arguments(Collections.singletonMap(fieldName + "Id", getIdMethod.invoke(source, new Object[0]))).build());
        }
    }

    private static class DateTypeFunction
    implements TypeFunction {
        private DateTypeFunction() {
        }

        public GraphQLType buildType(boolean input, Class<?> clazz, AnnotatedType annotatedType, ProcessingElementsContainer processingElementsContainer) {
            return _dateGraphQLScalarType;
        }

        public boolean canBuildType(Class<?> clazz, AnnotatedType annotatedType) {
            return clazz == Date.class;
        }
    }
}

