/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.permission;

import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.vulcan.permission.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.BadRequestException;

public class PermissionUtil {
    private static final Log _log = LogFactoryUtil.getLog(PermissionUtil.class);

    public static void checkPermission(String actionId, GroupLocalService groupLocalService, String resourceName, long resourceId, Long siteId) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        Group group = groupLocalService.fetchGroup(siteId.longValue());
        if (group != null && group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (!permissionChecker.hasPermission(group, resourceName, resourceId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, resourceName, siteId.longValue(), new String[]{actionId});
        }
    }

    public static List<ResourcePermission> getResourcePermissions(long companyId, long resourceId, String resourceName, ResourcePermissionLocalService resourcePermissionLocalService) throws PortalException {
        PermissionUtil._checkResources(companyId, resourceId, resourceName, resourcePermissionLocalService);
        return resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 4, String.valueOf(resourceId));
    }

    public static List<Role> getRoles(Company company, RoleLocalService roleLocalService, String[] roleNames) throws PortalException {
        ArrayList<String> invalidRoleNames = new ArrayList<String>();
        ArrayList<Role> roles = new ArrayList<Role>();
        for (String roleName : roleNames) {
            try {
                roles.add(roleLocalService.getRole(company.getCompanyId(), roleName));
            }
            catch (NoSuchRoleException noSuchRoleException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)roleName, (Throwable)noSuchRoleException);
                }
                invalidRoleNames.add(roleName);
            }
        }
        if (!invalidRoleNames.isEmpty()) {
            throw new BadRequestException("Invalid roles: " + ArrayUtil.toStringArray(invalidRoleNames));
        }
        return roles;
    }

    public static Permission toPermission(List<ResourceAction> resourceActions, ResourcePermission resourcePermission, final Role role) {
        final HashSet<String> actionsIdsSet = new HashSet<String>();
        long actionIds = resourcePermission.getActionIds();
        for (ResourceAction resourceAction : resourceActions) {
            long bitwiseValue = resourceAction.getBitwiseValue();
            if ((actionIds & bitwiseValue) != bitwiseValue) continue;
            actionsIdsSet.add(resourceAction.getActionId());
        }
        return new Permission(){
            {
                this.actionIds = actionsIdsSet.toArray(new String[0]);
                this.roleName = role.getName();
            }
        };
    }

    public static Permission toPermission(Long companyId, Long id, List<ResourceAction> resourceActions, String resourceName, ResourcePermissionLocalService resourcePermissionLocalService, Role role) throws PortalException {
        PermissionUtil._checkResources(companyId, id, resourceName, resourcePermissionLocalService);
        ResourcePermission resourcePermission = resourcePermissionLocalService.fetchResourcePermission(companyId.longValue(), resourceName, 4, String.valueOf(id), role.getRoleId());
        if (resourcePermission == null) {
            return null;
        }
        return PermissionUtil.toPermission(resourceActions, resourcePermission, role);
    }

    private static void _checkResources(long companyId, long resourceId, String resourceName, ResourcePermissionLocalService resourcePermissionLocalService) throws PortalException {
        int count = resourcePermissionLocalService.getResourcePermissionsCount(companyId, resourceName, 4, String.valueOf(resourceId));
        if (count == 0) {
            ResourceLocalServiceUtil.addResources((long)companyId, (long)resourceId, (long)0L, (String)resourceName, (String)String.valueOf(resourceId), (boolean)false, (boolean)true, (boolean)true);
        }
    }
}

