/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.util;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchAllQuery;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;

public class SearchUtil {
    public static <T> Page<T> search(UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, Filter filter, Class<?> indexerClass, String keywords, Pagination pagination, UnsafeConsumer<QueryConfig, Exception> queryConfigUnsafeConsumer, UnsafeConsumer<SearchContext, Exception> searchContextUnsafeConsumer, UnsafeFunction<Document, T, Exception> transformUnsafeFunction, Sort[] sorts) throws Exception {
        if (sorts == null) {
            sorts = new Sort[]{new Sort("entryClassPK", 6, false)};
        }
        ArrayList<Object> items = new ArrayList<Object>();
        Indexer indexer = IndexerRegistryUtil.getIndexer(indexerClass);
        SearchContext searchContext = SearchUtil._createSearchContext(SearchUtil._getBooleanClause(booleanQueryUnsafeConsumer, filter), keywords, pagination, queryConfigUnsafeConsumer, sorts);
        searchContextUnsafeConsumer.accept((Object)searchContext);
        Hits hits = indexer.search(searchContext);
        for (Document document : hits.getDocs()) {
            Object item = transformUnsafeFunction.apply((Object)document);
            if (item == null) continue;
            items.add(item);
        }
        return Page.of(items, pagination, indexer.searchCount(searchContext));
    }

    private static SearchContext _createSearchContext(BooleanClause<?> booleanClause, String keywords, Pagination pagination, UnsafeConsumer<QueryConfig, Exception> queryConfigUnsafeConsumer, Sort[] sorts) throws Exception {
        SearchContext searchContext = new SearchContext();
        searchContext.setBooleanClauses(new BooleanClause[]{booleanClause});
        if (pagination != null) {
            searchContext.setEnd(pagination.getEndPosition());
        }
        searchContext.setKeywords(keywords);
        searchContext.setSorts(sorts);
        if (pagination != null) {
            searchContext.setStart(pagination.getStartPosition());
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        searchContext.setUserId(permissionChecker.getUserId());
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        queryConfigUnsafeConsumer.accept((Object)queryConfig);
        return searchContext;
    }

    private static BooleanClause<?> _getBooleanClause(UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, final Filter filter) throws Exception {
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl(){
            {
                this.add((Query)new MatchAllQuery(), BooleanClauseOccur.MUST);
                BooleanFilter booleanFilter = new BooleanFilter();
                if (filter != null) {
                    booleanFilter.add(filter, BooleanClauseOccur.MUST);
                }
                this.setPreBooleanFilter(booleanFilter);
            }
        };
        booleanQueryUnsafeConsumer.accept((Object)booleanQuery);
        return BooleanClauseFactoryUtil.create((Query)booleanQuery, (String)BooleanClauseOccur.MUST.getName());
    }
}

