/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.util;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.batch.engine.Field;
import com.liferay.portal.vulcan.yaml.openapi.Components;
import com.liferay.portal.vulcan.yaml.openapi.Get;
import com.liferay.portal.vulcan.yaml.openapi.OpenAPIYAML;
import com.liferay.portal.vulcan.yaml.openapi.Operation;
import com.liferay.portal.vulcan.yaml.openapi.Parameter;
import com.liferay.portal.vulcan.yaml.openapi.PathItem;
import com.liferay.portal.vulcan.yaml.openapi.Post;
import com.liferay.portal.vulcan.yaml.openapi.Response;
import com.liferay.portal.vulcan.yaml.openapi.ResponseCode;
import com.liferay.portal.vulcan.yaml.openapi.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OpenAPIUtil {
    public static List<String> getCreateEntityScopes(String entityName, OpenAPIYAML openAPIYAML) {
        ArrayList<String> scopes = new ArrayList<String>();
        Map<String, PathItem> pathItemsMap = openAPIYAML.getPathItems();
        for (PathItem pathItem : pathItemsMap.values()) {
            Post post = pathItem.getPost();
            if (post == null || !OpenAPIUtil._hasOKResponseContentSchemaReferenceLike(entityName, post)) continue;
            scopes.add(OpenAPIUtil._getOperationScope(post));
        }
        return scopes;
    }

    public static Map<String, Field> getDTOEntityFields(String entityName, OpenAPIYAML openAPIYAML) {
        Components components = openAPIYAML.getComponents();
        Map<String, Schema> schemas = components.getSchemas();
        Schema schema = schemas.get(entityName);
        if (schema == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        List<String> requiredPropertySchemaNames = OpenAPIUtil._getRequiredPropertySchemaNames(schema);
        Map<String, Schema> propertySchemas = schema.getPropertySchemas();
        for (Map.Entry<String, Schema> schemaEntry : propertySchemas.entrySet()) {
            String propertyName = schemaEntry.getKey();
            Schema propertySchema = schemaEntry.getValue();
            fields.put(propertyName, Field.of(propertySchema.getDescription(), propertyName, propertySchema.isReadOnly(), requiredPropertySchemaNames.contains(propertyName), propertySchema.getType(), propertySchema.isWriteOnly()));
        }
        return fields;
    }

    public static List<String> getReadEntityScopes(String entityName, OpenAPIYAML openAPIYAML) {
        ArrayList<String> scopes = new ArrayList<String>();
        Map<String, PathItem> pathItemsMap = openAPIYAML.getPathItems();
        for (PathItem pathItem : pathItemsMap.values()) {
            Get get = pathItem.getGet();
            if (get == null || !OpenAPIUtil._hasOKResponseContentSchemaReferenceLike("Page" + entityName, get)) continue;
            scopes.add(OpenAPIUtil._getOperationScope(get));
        }
        return scopes;
    }

    private static String _getOperationScope(Operation operation) {
        List<Parameter> parameters = operation.getParameters();
        Stream parametersStream = parameters.stream();
        return parametersStream.filter(parameter -> StringUtil.equals((String)parameter.getIn(), (String)"path")).map(parameter -> {
            String name = parameter.getName();
            if (name.endsWith("Id")) {
                name = StringUtil.removeLast((String)name, (String)"Id");
            }
            return name;
        }).collect(Collectors.joining(","));
    }

    private static List<String> _getRequiredPropertySchemaNames(Schema schema) {
        List<String> requiredPropertySchemaNames = schema.getRequiredPropertySchemaNames();
        if (requiredPropertySchemaNames == null) {
            requiredPropertySchemaNames = Collections.emptyList();
        }
        return requiredPropertySchemaNames;
    }

    private static boolean _hasOKResponseContentSchemaReferenceLike(String name, Operation operation) {
        Map<ResponseCode, Response> responses = operation.getResponses();
        if (responses == null) {
            return false;
        }
        Set<Map.Entry<ResponseCode, Response>> entries = responses.entrySet();
        Stream stream = entries.stream();
        return stream.filter(entry -> OpenAPIUtil._isOKResponseCode((ResponseCode)entry.getKey())).map(Map.Entry::getValue).map(Response::getContent).map(Map::entrySet).flatMap(Collection::stream).map(Map.Entry::getValue).anyMatch(content -> Optional.ofNullable(content.getSchema()).map(Schema::getReference).map(reference -> StringUtil.equals((String)name, (String)reference.substring(reference.lastIndexOf(47) + 1))).orElse(false));
    }

    private static boolean _isOKResponseCode(ResponseCode responseCode) {
        return responseCode.isDefaultResponse() || responseCode.getHttpCode() / 100 == 2;
    }
}

