/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.validation;

import aQute.bnd.annotation.ProviderType;
import com.liferay.petra.string.StringBundler;
import java.util.HashMap;
import java.util.Map;

@ProviderType
public class ModelValidationResults {
    private static final int _FAILURE = 0;
    private static final int _SUCCESS = 1;
    private static final int _WARNING = 2;
    private Map<String, Throwable> _exceptions = new HashMap<String, Throwable>();
    private Map<String, Object> _fields = new HashMap<String, Object>();
    private final int _outcome;

    public static FailureBuilder failure() {
        return new FailureBuilder();
    }

    public static ModelValidationResults success() {
        return new ModelValidationResults(1);
    }

    public static WarningBuilder warning() {
        return new WarningBuilder();
    }

    public Map<String, Throwable> getExceptions() {
        return this._exceptions;
    }

    public String getExceptionsString() {
        StringBundler sb = new StringBundler(3);
        sb.append("Exceptions: ");
        sb.append("{");
        for (Map.Entry<String, Throwable> exception : this._exceptions.entrySet()) {
            sb.append("Message: ");
            sb.append(exception.getKey());
            sb.append("Exception: ");
            sb.append((Object)exception.getValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> getFields() {
        return this._fields;
    }

    public String getFieldsString() {
        StringBundler sb = new StringBundler(3);
        sb.append("Fields: ");
        sb.append("{");
        for (Map.Entry<String, Object> field : this._fields.entrySet()) {
            sb.append("Field: ");
            sb.append(field.getKey());
            sb.append("Value: ");
            sb.append(field.getValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean isFailure() {
        return this._outcome == 0;
    }

    public boolean isSuccess() {
        return this._outcome == 1;
    }

    public boolean isWarning() {
        return this._outcome == 2;
    }

    private ModelValidationResults(int outcome) {
        this._outcome = outcome;
    }

    private static class Builder {
        protected ModelValidationResults modelValidationResults;

        public Builder(int outcome) {
            this.modelValidationResults = new ModelValidationResults(outcome);
        }

        public ModelValidationResults getResults() {
            return this.modelValidationResults;
        }
    }

    public static class WarningBuilder
    extends Builder {
        public WarningBuilder() {
            super(2);
        }

        public WarningBuilder exceptionWarning(String message, Throwable cause) {
            this.modelValidationResults._exceptions.put(message, cause);
            return this;
        }

        public WarningBuilder fieldWarning(String name, Object value) {
            this.modelValidationResults._fields.put(name, value);
            return this;
        }
    }

    public static class FailureBuilder
    extends Builder {
        public FailureBuilder() {
            super(0);
        }

        public FailureBuilder exceptionFailure(String message, Throwable cause) {
            this.modelValidationResults._exceptions.put(message, cause);
            return this;
        }

        public FailureBuilder fieldFailure(String name, Object value) {
            this.modelValidationResults._fields.put(name, value);
            return this;
        }
    }
}

