/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.url.builder.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.url.builder.ESModuleAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.internal.util.URLUtil;
import javax.servlet.http.HttpServletRequest;

public class ESModuleAbsolutePortalURLBuilderImpl
implements ESModuleAbsolutePortalURLBuilder {
    private final String _cdnHost;
    private final String _esModulePath;
    private final HttpServletRequest _httpServletRequest;
    private boolean _ignoreCDNHost;
    private boolean _ignorePathProxy;
    private final String _pathModule;
    private final String _pathProxy;
    private final String _webContextPath;

    public ESModuleAbsolutePortalURLBuilderImpl(String esModulePath, String cdnHost, HttpServletRequest httpServletRequest, String pathModule, String pathProxy, String webContextPath) {
        if (!esModulePath.startsWith("/")) {
            esModulePath = "/" + esModulePath;
        }
        if (!webContextPath.startsWith("/")) {
            webContextPath = "/" + webContextPath;
        }
        this._esModulePath = esModulePath;
        this._cdnHost = cdnHost;
        this._httpServletRequest = httpServletRequest;
        this._pathModule = pathModule;
        this._pathProxy = pathProxy;
        this._webContextPath = webContextPath;
    }

    public String build() {
        StringBundler sb = new StringBundler();
        URLUtil.appendURL(sb, this._cdnHost, this._ignoreCDNHost, this._ignorePathProxy, this._pathModule + this._webContextPath + "/__liferay__", this._pathProxy, this._esModulePath);
        return sb.toString();
    }

    public ESModuleAbsolutePortalURLBuilder ignoreCDNHost() {
        this._ignoreCDNHost = true;
        return this;
    }

    public ESModuleAbsolutePortalURLBuilder ignorePathProxy() {
        this._ignorePathProxy = true;
        return this;
    }
}

