/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.url.builder.internal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.url.builder.facet.CacheAwareAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.internal.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(service={CacheHelper.class})
public class CacheHelper {
    private static final Log _log = LogFactoryUtil.getLog(CacheHelper.class);
    private final BundleTrackerCustomizer<Bundle> _bundleBundleTrackerCustomizer = new BundleTrackerCustomizer<Bundle>(){

        public Bundle addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            CacheHelper.this._digests.put(bundle.getBundleId(), new ConcurrentHashMap());
            return bundle;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Bundle bundle2) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Bundle bundle2) {
            CacheHelper.this._digests.remove(bundle.getBundleId());
        }
    };
    private BundleTracker<Bundle> _bundleTracker;
    private final Map<Long, ConcurrentMap<String, String>> _digests = new ConcurrentHashMap<Long, ConcurrentMap<String, String>>();
    private long _lastRestartTime = -1L;

    public void appendCacheParam(StringBundler sb, Bundle bundle, CacheAwareAbsolutePortalURLBuilder.CachePolicy cachePolicy, String resourcePath) {
        String mac;
        if (cachePolicy == CacheAwareAbsolutePortalURLBuilder.CachePolicy.NEVER) {
            this.appendNeverCacheParam(sb);
        } else if (cachePolicy == CacheAwareAbsolutePortalURLBuilder.CachePolicy.UNTIL_CHANGED && (mac = this._digest(bundle, "META-INF/resources" + resourcePath)) != null) {
            URLUtil.appendParam(sb, "mac", mac);
        }
    }

    public void appendLastRestartCacheParam(StringBundler sb) {
        URLUtil.appendParam(sb, "t", String.valueOf(this._lastRestartTime));
    }

    public void appendNeverCacheParam(StringBundler sb) {
        URLUtil.appendParam(sb, "t", String.valueOf(System.currentTimeMillis()));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker(bundleContext, 48, this._bundleBundleTrackerCustomizer);
        this._bundleTracker.open();
        if (this._lastRestartTime == -1L) {
            this._lastRestartTime = System.currentTimeMillis();
        }
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
        this._bundleTracker = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _digest(Bundle bundle, String path) {
        ConcurrentMap<String, String> digests = this._digests.get(bundle.getBundleId());
        String cacheKey = StringBundler.concat((Object[])new Object[]{bundle.getBundleId(), ":", path});
        if (digests.containsKey(cacheKey)) {
            return (String)digests.get(cacheKey);
        }
        URL url = bundle.getResource(path);
        if (url == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to find resource ", path, " inside bundle ", bundle.getSymbolicName()}));
            }
            digests.put(cacheKey, null);
            return null;
        }
        try (InputStream inputStream = url.openStream();){
            String digest = DigesterUtil.digestBase64((String)"SHA-1", (InputStream)inputStream);
            digests.put(cacheKey, digest);
            String string = digest;
            return string;
        }
        catch (IOException ioException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to digest resource ", path, " inside bundle ", bundle.getSymbolicName()}), (Throwable)ioException);
            }
            digests.put(cacheKey, null);
            return null;
        }
    }
}

