/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.url.builder.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.url.builder.ESModuleAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.facet.CacheAwareAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.internal.util.CacheHelper;
import com.liferay.portal.url.builder.internal.util.URLUtil;
import javax.servlet.http.HttpServletRequest;

public class ESModuleAbsolutePortalURLBuilderImpl
implements ESModuleAbsolutePortalURLBuilder {
    private final CacheHelper _cacheHelper;
    private CacheAwareAbsolutePortalURLBuilder.CachePolicy _cachePolicy = CacheAwareAbsolutePortalURLBuilder.CachePolicy.UNTIL_CHANGED;
    private final String _cdnHost;
    private final String _esModulePath;
    private final HttpServletRequest _httpServletRequest;
    private boolean _ignoreCDNHost;
    private boolean _ignorePathProxy;
    private final String _pathModule;
    private final String _pathProxy;
    private final String _webContextPath;

    public ESModuleAbsolutePortalURLBuilderImpl(CacheHelper cacheHelper, String esModulePath, String cdnHost, HttpServletRequest httpServletRequest, String pathModule, String pathProxy, String webContextPath) {
        if (!esModulePath.startsWith("/")) {
            esModulePath = "/" + esModulePath;
        }
        if (!webContextPath.startsWith("/")) {
            webContextPath = "/" + webContextPath;
        }
        this._cacheHelper = cacheHelper;
        this._esModulePath = esModulePath;
        this._cdnHost = cdnHost;
        this._httpServletRequest = httpServletRequest;
        this._pathModule = pathModule;
        this._pathProxy = pathProxy;
        this._webContextPath = webContextPath;
    }

    public String build() {
        StringBundler sb = new StringBundler();
        URLUtil.appendURL(sb, this._cdnHost, this._ignoreCDNHost, this._ignorePathProxy, this._pathModule + this._webContextPath + "/__liferay__", this._pathProxy, this._esModulePath);
        if (this._cachePolicy == CacheAwareAbsolutePortalURLBuilder.CachePolicy.NEVER) {
            this._cacheHelper.appendNeverCacheParam(sb);
        } else if (this._cachePolicy == CacheAwareAbsolutePortalURLBuilder.CachePolicy.UNTIL_CHANGED) {
            this._cacheHelper.appendLastRestartCacheParam(sb);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        URLUtil.appendParam(sb, "languageId", themeDisplay.getLanguageId());
        return sb.toString();
    }

    public ESModuleAbsolutePortalURLBuilder cache(CacheAwareAbsolutePortalURLBuilder.CachePolicy cachePolicy) {
        this._cachePolicy = cachePolicy;
        return this;
    }

    public ESModuleAbsolutePortalURLBuilder ignoreCDNHost() {
        this._ignoreCDNHost = true;
        return this;
    }

    public ESModuleAbsolutePortalURLBuilder ignorePathProxy() {
        this._ignorePathProxy = true;
        return this;
    }
}

