/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.url.builder.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.portlet.PortletDependency;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.url.builder.AbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.ImageAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.MainAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.ModuleAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.PortletDependencyAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.ResourceAbsolutePortalURLBuilder;
import javax.servlet.http.HttpServletRequest;

public class AbsolutePortalURLBuilderImpl
implements AbsolutePortalURLBuilder {
    private static final Log _log = LogFactoryUtil.getLog(AbsolutePortalURLBuilderImpl.class);
    private boolean _ignoreCDNHost;
    private boolean _ignorePathProxy;
    private final Portal _portal;
    private final HttpServletRequest _request;

    public AbsolutePortalURLBuilderImpl(Portal portal, HttpServletRequest request) {
        this._portal = portal;
        this._request = request;
    }

    public ImageAbsolutePortalURLBuilder forImage(final String relativeURL) {
        return new ImageAbsolutePortalURLBuilder(){

            public String build() {
                return AbsolutePortalURLBuilderImpl.this._build(AbsolutePortalURLBuilderImpl.this._portal.getPathImage(), relativeURL);
            }
        };
    }

    public MainAbsolutePortalURLBuilder forMain(final String relativeURL) {
        return new MainAbsolutePortalURLBuilder(){

            public String build() {
                return AbsolutePortalURLBuilderImpl.this._build(AbsolutePortalURLBuilderImpl.this._portal.getPathMain(), relativeURL);
            }
        };
    }

    public ModuleAbsolutePortalURLBuilder forModule(final String relativeURL) {
        return new ModuleAbsolutePortalURLBuilder(){

            public String build() {
                return AbsolutePortalURLBuilderImpl.this._build(AbsolutePortalURLBuilderImpl.this._portal.getPathModule(), relativeURL);
            }
        };
    }

    public PortletDependencyAbsolutePortalURLBuilder forPortletDependency(final PortletDependency portletDependency, final String cssURN, final String javaScriptURN) {
        return new PortletDependencyAbsolutePortalURLBuilder(){

            public String build() {
                StringBundler sb = new StringBundler(7);
                boolean ignoreCDNHost = AbsolutePortalURLBuilderImpl.this._ignoreCDNHost;
                boolean ignorePathProxy = AbsolutePortalURLBuilderImpl.this._ignorePathProxy;
                if (PortletDependency.Type.CSS == portletDependency.getType()) {
                    String resourcePath = cssURN;
                    if (Validator.isNull((String)resourcePath)) {
                        resourcePath = "css";
                    } else {
                        ignoreCDNHost = true;
                        ignorePathProxy = true;
                    }
                    sb.append(resourcePath);
                } else if (PortletDependency.Type.JAVASCRIPT == portletDependency.getType()) {
                    String resourcePath = javaScriptURN;
                    if (Validator.isNull((String)resourcePath)) {
                        resourcePath = "js";
                    } else {
                        ignoreCDNHost = true;
                        ignorePathProxy = true;
                    }
                    sb.append(resourcePath);
                }
                if (Validator.isNotNull((String)portletDependency.getScope())) {
                    sb.append("/");
                    sb.append(portletDependency.getScope());
                }
                if (Validator.isNotNull((String)portletDependency.getVersion())) {
                    sb.append("/");
                    sb.append(portletDependency.getVersion());
                }
                sb.append("/");
                sb.append(portletDependency.getName());
                return AbsolutePortalURLBuilderImpl.this._build(ignoreCDNHost, ignorePathProxy, "", sb.toString());
            }
        };
    }

    public ResourceAbsolutePortalURLBuilder forResource(final String relativeURL) {
        return new ResourceAbsolutePortalURLBuilder(){

            public String build() {
                return AbsolutePortalURLBuilderImpl.this._build("", relativeURL);
            }
        };
    }

    public AbsolutePortalURLBuilder ignoreCDNHost() {
        this._ignoreCDNHost = true;
        return this;
    }

    public AbsolutePortalURLBuilder ignorePathProxy() {
        this._ignorePathProxy = true;
        return this;
    }

    private String _build(boolean ignoreCDNHost, boolean ignorePathProxy, String pathPrefix, String relativeURL) {
        StringBundler sb = new StringBundler(6);
        if (!ignoreCDNHost) {
            sb.append(this._getCDNHost(this._request));
        }
        if (!ignorePathProxy) {
            sb.append(this._getPathProxy());
        }
        if (!Validator.isBlank((String)pathPrefix)) {
            if (!pathPrefix.startsWith("/")) {
                sb.append("/");
            }
            if (pathPrefix.endsWith("/")) {
                sb.append(pathPrefix.substring(0, pathPrefix.length() - 1));
            } else {
                sb.append(pathPrefix);
            }
        }
        if (!relativeURL.startsWith("/")) {
            sb.append("/");
        }
        sb.append(relativeURL);
        return sb.toString();
    }

    private String _build(String pathPrefix, String relativeURL) {
        return this._build(this._ignoreCDNHost, this._ignorePathProxy, pathPrefix, relativeURL);
    }

    private String _getCDNHost(HttpServletRequest request) {
        String cdnHost;
        block3: {
            try {
                cdnHost = this._portal.getCDNHost(request);
            }
            catch (PortalException pe) {
                cdnHost = "";
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to retrieve CDN host from request", (Throwable)pe);
            }
        }
        if (cdnHost.endsWith("/")) {
            cdnHost = cdnHost.substring(0, cdnHost.length() - 1);
        }
        return cdnHost;
    }

    private String _getPathProxy() {
        String pathProxy = this._portal.getPathProxy();
        if (!Validator.isBlank((String)pathProxy) && !pathProxy.startsWith("/")) {
            pathProxy = "/" + pathProxy;
        }
        if (pathProxy.endsWith("/")) {
            pathProxy = pathProxy.substring(0, pathProxy.length() - 1);
        }
        return pathProxy;
    }
}

