/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.report;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.upgrade.PortalUpgradeProcess;
import com.liferay.portal.upgrade.internal.release.osgi.commands.ReleaseManagerOSGiCommands;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.felix.cm.PersistenceManager;

public class UpgradeReport {
    private static final String _CONFIGURATION_PID_ADVANCED_FILE_SYSTEM_STORE = "com.liferay.portal.store.file.system.configuration.AdvancedFileSystemStoreConfiguration";
    private static final String _CONFIGURATION_PID_FILE_SYSTEM_STORE = "com.liferay.portal.store.file.system.configuration.FileSystemStoreConfiguration";
    private static final String _UNDERLINE = "--------------";
    private static final int _UPGRADE_PROCESSES_COUNT = 20;
    private static final Log _log = LogFactoryUtil.getLog(UpgradeReport.class);
    private final Map<String, Map<String, Integer>> _errorMessages = new ConcurrentHashMap<String, Map<String, Integer>>();
    private final Map<String, ArrayList<String>> _eventMessages = new ConcurrentHashMap<String, ArrayList<String>>();
    private final int _initialBuildNumber;
    private final String _initialSchemaVersion;
    private final Map<String, Integer> _initialTableCounts;
    private PersistenceManager _persistenceManager;
    private String _rootDir;
    private final StopWatch _stopWatch = new StopWatch();
    private final Map<String, Map<String, Integer>> _warningMessages = new ConcurrentHashMap<String, Map<String, Integer>>();

    public UpgradeReport() {
        this._stopWatch.start();
        this._initialBuildNumber = this._getBuildNumber();
        this._initialSchemaVersion = this._getSchemaVersion();
        this._initialTableCounts = this._getTableCounts();
    }

    public void addErrorMessage(String loggerName, String message) {
        Map errorMessages = this._errorMessages.computeIfAbsent(loggerName, key -> new ConcurrentHashMap());
        int occurrences = errorMessages.computeIfAbsent(message, key -> 0);
        errorMessages.put(message, ++occurrences);
    }

    public void addEventMessage(String loggerName, String message) {
        List eventMessages = this._eventMessages.computeIfAbsent(loggerName, key -> new ArrayList());
        eventMessages.add(message);
    }

    public void addWarningMessage(String loggerName, String message) {
        Map warningMessages = this._warningMessages.computeIfAbsent(loggerName, key -> new ConcurrentHashMap());
        int count = warningMessages.computeIfAbsent(message, key -> 0);
        warningMessages.put(message, ++count);
    }

    public void generateReport(PersistenceManager persistenceManager, ReleaseManagerOSGiCommands releaseManagerOSGiCommands) {
        this._stopWatch.stop();
        this._persistenceManager = persistenceManager;
        try {
            FileUtil.write((File)this._getReportFile(), (String)StringUtil.merge((Object[])new String[]{this._getDateInfo(), this._getUpgradeTimeInfo(), this._getPortalVersionsInfo(), this._getDialectInfo(), this._getPropertiesInfo(), this._getDLStorageInfo(), this._getDatabaseTablesInfo(), this._getUpgradeProcessesInfo(), this._getLogEventsInfo("errors"), this._getLogEventsInfo("warnings"), releaseManagerOSGiCommands.check()}, (String)"\n\n"));
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to generate the upgrade report", (Throwable)ioException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int _getBuildNumber() {
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select buildNumber from Release_ where releaseId = 1");){
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) return 0;
            int n = resultSet.getInt("buildNumber");
            return n;
        }
        catch (Exception exception) {
            if (!_log.isWarnEnabled()) return 0;
            _log.warn((Object)"Unable to get build number", (Throwable)exception);
        }
        return 0;
    }

    private String _getDatabaseTablesInfo() {
        Map<String, Integer> finalTableCounts = this._getTableCounts();
        if (this._initialTableCounts == null || finalTableCounts == null) {
            return "Unable to get database tables size";
        }
        HashSet<String> tableNames = new HashSet<String>();
        tableNames.addAll(this._initialTableCounts.keySet());
        tableNames.addAll(finalTableCounts.keySet());
        StringBundler sb = new StringBundler(finalTableCounts.size() + 3);
        String format = "%-30s %20s %20s\n";
        sb.append("Tables in database sorted by initial number of rows:\n");
        sb.append(String.format(format, "Table name", "Rows (initial)", "Rows (final)"));
        sb.append(String.format(format, _UNDERLINE, _UNDERLINE, _UNDERLINE));
        Stream stream = tableNames.stream();
        stream.filter(tableName -> {
            int initialCount = this._initialTableCounts.getOrDefault(tableName, 0);
            int finalCount = finalTableCounts.getOrDefault(tableName, 0);
            return initialCount > 0 || finalCount > 0;
        }).sorted((a, b) -> {
            int countB;
            int countA = this._initialTableCounts.getOrDefault(a, 0);
            if (countA == (countB = this._initialTableCounts.getOrDefault(b, 0).intValue())) {
                return a.compareTo((String)b);
            }
            return countB - countA;
        }).forEach(tableName -> {
            int initialCount = this._initialTableCounts.getOrDefault(tableName, -1);
            String initialRows = initialCount >= 0 ? String.valueOf(initialCount) : "-";
            int finalCount = finalTableCounts.getOrDefault(tableName, -1);
            String finalRows = finalCount >= 0 ? String.valueOf(finalCount) : "-";
            sb.append(String.format(format, tableName, initialRows, finalRows));
        });
        return sb.toString();
    }

    private String _getDateInfo() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, MMM dd, yyyy hh:mm:ss z");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return String.format("Date: %s\n", simpleDateFormat.format(calendar.getTime()));
    }

    private String _getDialectInfo() {
        DB db = DBManagerUtil.getDB();
        return StringBundler.concat((Object[])new Object[]{"Using ", db.getDBType(), " version ", db.getMajorVersion(), ".", db.getMinorVersion(), "\n"});
    }

    private String _getDLStorageInfo() {
        if (!StringUtil.endsWith((String)PropsValues.DL_STORE_IMPL, (String)"FileSystemStore")) {
            return "Check your external repository to know the document library storage size";
        }
        if (this._rootDir == null) {
            return "Unable to determine the document library storage size because the property \"rootDir\" was not set\n";
        }
        double bytes = 0.0;
        try {
            bytes = FileUtils.sizeOfDirectory((File)new File(this._rootDir));
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
        String[] dictionary = new String[]{"bytes", "KB", "MB", "GB", "TB", "PB"};
        int index = 0;
        for (index = 0; index < dictionary.length && !(bytes < 1024.0); bytes /= 1024.0, ++index) {
        }
        String size = StringBundler.concat((String[])new String[]{String.format("%.2f", bytes), " ", dictionary[index]});
        return "The document library storage size is " + size;
    }

    private String _getLogEventsInfo(String type) {
        Set<Map.Entry<String, Map<String, Integer>>> entrySet = type.equals("errors") ? this._errorMessages.entrySet() : this._warningMessages.entrySet();
        if (entrySet.isEmpty()) {
            return StringBundler.concat((String[])new String[]{"No ", type, " thrown during upgrade"});
        }
        StringBundler sb = new StringBundler();
        sb.append(StringUtil.upperCaseFirstLetter((String)type));
        sb.append(" thrown during upgrade process\n");
        Stream stream = entrySet.stream();
        Map sortedErrors = stream.sorted(Collections.reverseOrder(Map.Entry.comparingByValue(new Comparator<Map<String, Integer>>(){

            @Override
            public int compare(Map<String, Integer> object1, Map<String, Integer> object2) {
                return Integer.compare(object1.size(), object2.size());
            }
        }))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (object1, object2) -> object2, LinkedHashMap::new));
        for (Map.Entry entry : sortedErrors.entrySet()) {
            sb.append("Class name: ");
            sb.append((String)entry.getKey());
            sb.append("\n");
            Map<String, Integer> value = this._sort((Map)entry.getValue());
            for (Map.Entry<String, Integer> valueEntry : value.entrySet()) {
                sb.append("\t");
                sb.append((Object)valueEntry.getValue());
                sb.append(" occurrences of the following ");
                sb.append(type);
                sb.append(": ");
                sb.append(valueEntry.getKey());
                sb.append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String _getPortalVersionsInfo() {
        return StringBundler.concat((String[])new String[]{this._getReleaseInfo(this._initialBuildNumber, this._initialSchemaVersion, "initial"), "\n", this._getReleaseInfo(this._getBuildNumber(), this._getSchemaVersion(), "final"), "\n", this._getReleaseInfo(ReleaseInfo.getBuildNumber(), String.valueOf(PortalUpgradeProcess.getLatestSchemaVersion()), "expected")});
    }

    private String _getPropertiesInfo() {
        StringBuffer sb = new StringBuffer(12);
        sb.append("liferay.home=" + PropsValues.LIFERAY_HOME);
        sb.append("\nlocales=" + Arrays.toString(PropsValues.LOCALES));
        sb.append("\nlocales.enabled=" + Arrays.toString(PropsValues.LOCALES_ENABLED));
        sb.append("\n");
        sb.append("dl.store.impl=" + PropsValues.DL_STORE_IMPL);
        sb.append("\n");
        if (StringUtil.equals((String)PropsValues.DL_STORE_IMPL, (String)"com.liferay.portal.store.file.system.AdvancedFileSystemStore")) {
            this._rootDir = this._getRootDir(_CONFIGURATION_PID_ADVANCED_FILE_SYSTEM_STORE);
            if (this._rootDir == null) {
                sb.append("The configuration \"rootDir\" is required. ");
                sb.append("Configure it in ");
                sb.append(_CONFIGURATION_PID_ADVANCED_FILE_SYSTEM_STORE);
                sb.append(".config");
            }
        } else if (StringUtil.equals((String)PropsValues.DL_STORE_IMPL, (String)"com.liferay.portal.store.file.system.FileSystemStore")) {
            this._rootDir = this._getRootDir(_CONFIGURATION_PID_FILE_SYSTEM_STORE);
            if (this._rootDir == null) {
                this._rootDir = PropsValues.LIFERAY_HOME + "/data/document_library";
            }
        }
        if (this._rootDir != null) {
            sb.append("rootDir=" + this._rootDir);
        }
        return sb.toString();
    }

    private String _getReleaseInfo(int buildNumber, String schemaVersion, String type) {
        StringBuffer sb = new StringBuffer();
        if (buildNumber != 0) {
            sb.append(StringUtil.upperCaseFirstLetter((String)type));
            sb.append(" portal build number: ");
            sb.append(buildNumber);
        } else {
            sb.append("Unable to determine ");
            sb.append(type);
            sb.append(" portal build number");
        }
        sb.append("\n");
        if (schemaVersion != null) {
            sb.append(StringUtil.upperCaseFirstLetter((String)type));
            sb.append(" portal schema version: ");
            sb.append(schemaVersion);
        } else {
            sb.append("Unable to determine ");
            sb.append(type);
            sb.append(" portal schema version");
        }
        return sb.toString();
    }

    private File _getReportFile() {
        File reportFile;
        File reportsDir = new File(".", "reports");
        if (reportsDir != null && !reportsDir.exists()) {
            reportsDir.mkdirs();
        }
        if ((reportFile = new File(reportsDir, "upgrade_report.info")).exists()) {
            String reportFileName = reportFile.getName();
            reportFile.renameTo(new File(reportsDir, reportFileName + "." + reportFile.lastModified()));
            reportFile = new File(reportsDir, reportFileName);
        }
        return reportFile;
    }

    private String _getRootDir(String dlStoreConfigurationPid) {
        block3: {
            try {
                Dictionary configurations = this._persistenceManager.load(dlStoreConfigurationPid);
                if (configurations != null) {
                    return (String)configurations.get("rootDir");
                }
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to get document library store root dir", (Throwable)ioException);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _getSchemaVersion() {
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select schemaVersion from Release_ where releaseId = 1");){
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) return null;
            String string = resultSet.getString("schemaVersion");
            return string;
        }
        catch (SQLException sqlException) {
            if (!_log.isWarnEnabled()) return null;
            _log.warn((Object)"Unable to get schema version", (Throwable)sqlException);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private Map<String, Integer> _getTableCounts() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String _getUpgradeProcessesInfo() {
        List messages = this._eventMessages.get(UpgradeProcess.class.getName());
        if (ListUtil.isEmpty((List)messages)) {
            return "No upgrade processes registered";
        }
        StringBundler sb = new StringBundler();
        sb.append("Top ");
        sb.append(20);
        sb.append(" longest running upgrade processes:\n");
        Map<String, Integer> map = new HashMap<String, Integer>();
        for (String message : messages) {
            int endIndex;
            int startIndex;
            String className = message.substring(startIndex = message.indexOf("com."), endIndex = message.indexOf(" ", startIndex));
            if (className.equals(PortalUpgradeProcess.class.getName())) continue;
            startIndex = message.indexOf(" ", endIndex + 1);
            endIndex = message.indexOf(" ", startIndex + 1);
            map.put(className, GetterUtil.getInteger((String)message.substring(startIndex, endIndex)));
        }
        map = this._sort(map);
        int count = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            sb.append("\t");
            sb.append(entry.getKey());
            sb.append(" took ");
            sb.append((Object)entry.getValue());
            sb.append(" ms to complete\n");
            if (++count < 20) continue;
            break;
        }
        return sb.toString();
    }

    private String _getUpgradeTimeInfo() {
        return String.format("Upgrade completed in %s seconds", this._stopWatch.getTime() / 1000L);
    }

    private Map<String, Integer> _sort(Map<String, Integer> map) {
        Set<Map.Entry<String, Integer>> set = map.entrySet();
        Stream stream = set.stream();
        return stream.sorted(Collections.reverseOrder(Map.Entry.comparingByValue(new Comparator<Integer>(){

            @Override
            public int compare(Integer object1, Integer object2) {
                return Integer.compare(object1, object2);
            }
        }))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (object1, object2) -> object2, LinkedHashMap::new));
    }
}

