/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.release.osgi.commands;

import com.liferay.gogo.shell.logging.TeeLoggingUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.upgrade.PortalUpgradeProcess;
import com.liferay.portal.upgrade.internal.executor.UpgradeExecutor;
import com.liferay.portal.upgrade.internal.graph.ReleaseGraphManager;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import com.liferay.portal.upgrade.internal.release.ReleaseManagerImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.felix.service.command.Descriptor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.command.function=check", "osgi.command.function=checkAll", "osgi.command.function=execute", "osgi.command.function=executeAll", "osgi.command.function=list", "osgi.command.scope=upgrade"}, service={ReleaseManagerOSGiCommands.class})
public class ReleaseManagerOSGiCommands {
    private static final Log _log = LogFactoryUtil.getLog(ReleaseManagerOSGiCommands.class);
    @Reference
    private ReleaseManagerImpl _releaseManagerImpl;
    @Reference
    private UpgradeExecutor _upgradeExecutor;

    @Descriptor(value="List pending upgrades")
    public String check() {
        return this._check(false);
    }

    @Descriptor(value="List pending upgrade processes and their upgrade steps")
    public String checkAll() {
        return this._check(true);
    }

    @Descriptor(value="Execute upgrade for a specific module")
    public String execute(String bundleSymbolicName) {
        List<UpgradeInfo> upgradeInfos = this._releaseManagerImpl.getUpgradeInfos(bundleSymbolicName);
        if (upgradeInfos == null) {
            return "No upgrade processes registered for " + bundleSymbolicName;
        }
        TeeLoggingUtil.runWithTeeLogging(() -> {
            try {
                this._upgradeExecutor.execute(bundleSymbolicName, upgradeInfos);
            }
            catch (Throwable throwable) {
                _log.error((Object)"Failed upgrade process for module ".concat(bundleSymbolicName), throwable);
            }
        });
        return null;
    }

    @Descriptor(value="Execute upgrade for a specific module and final version")
    public String execute(String bundleSymbolicName, String toVersionString) {
        List<UpgradeInfo> upgradeInfos = this._releaseManagerImpl.getUpgradeInfos(bundleSymbolicName);
        if (upgradeInfos == null) {
            return "No upgrade processes registered for " + bundleSymbolicName;
        }
        ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager(upgradeInfos);
        TeeLoggingUtil.runWithTeeLogging(() -> this._upgradeExecutor.executeUpgradeInfos(bundleSymbolicName, releaseGraphManager.getUpgradeInfos(this._releaseManagerImpl.getSchemaVersionString(bundleSymbolicName), toVersionString)));
        return null;
    }

    @Descriptor(value="Execute all pending upgrades")
    public String executeAll() {
        HashSet upgradeThrewExceptionBundleSymbolicNames = new HashSet();
        TeeLoggingUtil.runWithTeeLogging(() -> this.executeAll(upgradeThrewExceptionBundleSymbolicNames));
        if (upgradeThrewExceptionBundleSymbolicNames.isEmpty()) {
            return "All modules were successfully upgraded";
        }
        StringBundler sb = new StringBundler(upgradeThrewExceptionBundleSymbolicNames.size() * 3 + 3);
        sb.append("The following modules had errors while upgrading:\n");
        for (String upgradeThrewExceptionBundleSymbolicName : upgradeThrewExceptionBundleSymbolicNames) {
            sb.append("\t");
            sb.append(upgradeThrewExceptionBundleSymbolicName);
            sb.append("\n");
        }
        sb.append("Use the command upgrade:list <module name> to get more ");
        sb.append("details about the status of a specific upgrade.");
        return sb.toString();
    }

    @Descriptor(value="List registered upgrade processes for all modules")
    public String list() {
        Set<String> bundleSymbolicNames = this._releaseManagerImpl.getBundleSymbolicNames();
        StringBundler sb = new StringBundler(2 * bundleSymbolicNames.size());
        for (String bundleSymbolicName : bundleSymbolicNames) {
            sb.append(this.list(bundleSymbolicName));
            sb.append("\n");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    @Descriptor(value="List registered upgrade processes for a specific module")
    public String list(String bundleSymbolicName) {
        List<UpgradeInfo> upgradeInfos = this._releaseManagerImpl.getUpgradeInfos(bundleSymbolicName);
        StringBundler sb = new StringBundler(5 + 3 * upgradeInfos.size());
        sb.append("Registered upgrade processes for ");
        sb.append(bundleSymbolicName);
        sb.append(" ");
        sb.append(this._releaseManagerImpl.getSchemaVersionString(bundleSymbolicName));
        sb.append("\n");
        for (UpgradeInfo upgradeProcess : upgradeInfos) {
            sb.append("\t");
            sb.append((Object)upgradeProcess);
            sb.append("\n");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    protected void executeAll(Set<String> upgradeThrewExceptionBundleSymbolicNames) {
        block2: while (true) {
            Set<String> upgradableBundleSymbolicNames = this._releaseManagerImpl.getUpgradableBundleSymbolicNames();
            upgradableBundleSymbolicNames.removeAll(upgradeThrewExceptionBundleSymbolicNames);
            if (upgradableBundleSymbolicNames.isEmpty()) {
                return;
            }
            Iterator<String> iterator = upgradableBundleSymbolicNames.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block2;
                String upgradableBundleSymbolicName = iterator.next();
                try {
                    List<UpgradeInfo> upgradeInfos = this._releaseManagerImpl.getUpgradeInfos(upgradableBundleSymbolicName);
                    this._upgradeExecutor.execute(upgradableBundleSymbolicName, upgradeInfos);
                    continue;
                }
                catch (Throwable throwable) {
                    _log.error((Object)"Failed upgrade process for module ".concat(upgradableBundleSymbolicName), throwable);
                    upgradeThrewExceptionBundleSymbolicNames.add(upgradableBundleSymbolicName);
                    continue;
                }
                break;
            }
            break;
        }
    }

    private String _check(boolean showUpgradeSteps) {
        StringBundler sb = new StringBundler(3);
        sb.append(this._checkPortal(showUpgradeSteps));
        if (sb.length() > 0) {
            sb.append("\n");
        }
        sb.append(this._checkModules(showUpgradeSteps));
        return sb.toString();
    }

    private String _checkModules(boolean showUpgradeSteps) {
        StringBundler sb = new StringBundler();
        Set<String> bundleSymbolicNames = this._releaseManagerImpl.getBundleSymbolicNames();
        for (String bundleSymbolicName : bundleSymbolicNames) {
            String schemaVersionString = this._releaseManagerImpl.getSchemaVersionString(bundleSymbolicName);
            ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager(this._releaseManagerImpl.getUpgradeInfos(bundleSymbolicName));
            List<List<UpgradeInfo>> upgradeInfosList = releaseGraphManager.getUpgradeInfosList(schemaVersionString);
            int size = upgradeInfosList.size();
            if (size > 1) {
                sb.append("There are ");
                sb.append(size);
                sb.append(" possible end nodes for ");
                sb.append(schemaVersionString);
                sb.append("\n");
            }
            if (size == 0) continue;
            List<UpgradeInfo> upgradeInfos = upgradeInfosList.get(0);
            UpgradeInfo lastUpgradeInfo = upgradeInfos.get(upgradeInfos.size() - 1);
            sb.append(this._getModulePendingUpgradeMessage(bundleSymbolicName, schemaVersionString, lastUpgradeInfo.getToSchemaVersionString()));
            if (showUpgradeSteps) {
                sb.append(":");
                for (UpgradeInfo upgradeInfo : upgradeInfos) {
                    UpgradeStep upgradeStep = upgradeInfo.getUpgradeStep();
                    sb.append("\n");
                    sb.append("\t");
                    sb.append(this._getPendingUpgradeProcessMessage(upgradeStep.getClass(), upgradeInfo.getFromSchemaVersionString(), upgradeInfo.getToSchemaVersionString()));
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _checkPortal(boolean showUpgradeSteps) {
        try (Connection connection = DataAccess.getConnection();){
            Version currentSchemaVersion = PortalUpgradeProcess.getCurrentSchemaVersion((Connection)connection);
            SortedMap pendingUpgradeProcesses = PortalUpgradeProcess.getPendingUpgradeProcesses((Version)currentSchemaVersion);
            if (pendingUpgradeProcesses.isEmpty()) return "";
            Version latestSchemaVersion = PortalUpgradeProcess.getLatestSchemaVersion();
            StringBundler sb = new StringBundler();
            sb.append(this._getModulePendingUpgradeMessage("Portal", currentSchemaVersion.toString(), latestSchemaVersion.toString()));
            sb.append(" (requires upgrade tool or auto upgrade)");
            if (showUpgradeSteps) {
                sb.append(":");
                for (Map.Entry entry : pendingUpgradeProcesses.entrySet()) {
                    sb.append("\n");
                    sb.append("\t");
                    UpgradeProcess upgradeProcess = (UpgradeProcess)entry.getValue();
                    Version version = (Version)entry.getKey();
                    sb.append(this._getPendingUpgradeProcessMessage(upgradeProcess.getClass(), currentSchemaVersion.toString(), version.toString()));
                    sb.append("\n");
                    currentSchemaVersion = version;
                }
            }
            String string = sb.toString();
            return string;
        }
        catch (SQLException sqlException) {
            if (!_log.isWarnEnabled()) return "";
            _log.warn((Object)"Unable to get pending upgrade information for the portal", (Throwable)sqlException);
        }
        return "";
    }

    private String _getModulePendingUpgradeMessage(String moduleName, String currentSchemaVersion, String finalSchemaVersion) {
        return StringBundler.concat((String[])new String[]{"There are upgrade processes available for ", moduleName, " from ", currentSchemaVersion, " to ", finalSchemaVersion});
    }

    private String _getPendingUpgradeProcessMessage(Class<?> upgradeClass, String fromSchemaVersion, String toSchemaVersion) {
        StringBundler sb = new StringBundler(6);
        String toMessage = toSchemaVersion;
        if (UpgradeProcessUtil.isRequiredSchemaVersion((Version)Version.parseVersion((String)fromSchemaVersion), (Version)Version.parseVersion((String)toSchemaVersion))) {
            toMessage = toMessage + " (REQUIRED)";
        }
        sb.append(fromSchemaVersion);
        sb.append(" to ");
        sb.append(toMessage);
        sb.append(":");
        sb.append(" ");
        sb.append(upgradeClass.getName());
        return sb.toString();
    }
}

