/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.registry;

import com.liferay.portal.kernel.upgrade.DummyUpgradeStep;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.Version;

public class UpgradeStepRegistry
implements UpgradeStepRegistrator.Registry {
    private final int _buildNumber;
    private boolean _initialization;
    private final List<UpgradeStep> _releaseCreationUpgradeSteps = new ArrayList<UpgradeStep>();
    private final List<UpgradeInfo> _upgradeInfos = new ArrayList<UpgradeInfo>();

    public UpgradeStepRegistry(int buildNumber) {
        this._buildNumber = buildNumber;
    }

    public List<UpgradeStep> getReleaseCreationUpgradeSteps() {
        return this._releaseCreationUpgradeSteps;
    }

    public List<UpgradeInfo> getUpgradeInfos() {
        if (this._initialization) {
            if (this._upgradeInfos.isEmpty()) {
                return Arrays.asList(new UpgradeInfo("0.0.0", "1.0.0", this._buildNumber, (UpgradeStep)new DummyUpgradeStep()));
            }
            return ListUtil.concat((List[])new List[]{Arrays.asList(new UpgradeInfo("0.0.0", this._getFinalSchemaVersion(this._upgradeInfos), this._buildNumber, (UpgradeStep)new DummyUpgradeStep())), this._upgradeInfos});
        }
        return this._upgradeInfos;
    }

    public void register(String fromSchemaVersionString, String toSchemaVersionString, UpgradeStep ... upgradeSteps) {
        this._createUpgradeInfos(fromSchemaVersionString, toSchemaVersionString, this._buildNumber, upgradeSteps);
    }

    public void registerInitialization() {
        this._initialization = true;
    }

    public void registerReleaseCreationUpgradeSteps(UpgradeStep ... upgradeSteps) {
        Collections.addAll(this._releaseCreationUpgradeSteps, upgradeSteps);
    }

    private void _createUpgradeInfos(String fromSchemaVersionString, String toSchemaVersionString, int buildNumber, UpgradeStep ... upgradeSteps) {
        if (ArrayUtil.isEmpty((Object[])upgradeSteps)) {
            return;
        }
        String upgradeInfoFromSchemaVersionString = fromSchemaVersionString;
        ArrayList<UpgradeStep> upgradeStepsList = new ArrayList<UpgradeStep>();
        for (UpgradeStep upgradeStep : upgradeSteps) {
            if (upgradeStep instanceof UpgradeProcess) {
                UpgradeProcess upgradeProcess = (UpgradeProcess)upgradeStep;
                for (UpgradeStep innerUpgradeStep : upgradeProcess.getUpgradeSteps()) {
                    upgradeStepsList.add(innerUpgradeStep);
                }
                continue;
            }
            upgradeStepsList.add(upgradeStep);
        }
        for (int i = 0; i < upgradeStepsList.size() - 1; ++i) {
            UpgradeStep upgradeStep = (UpgradeStep)upgradeStepsList.get(i);
            String upgradeInfoToSchemaVersionString = toSchemaVersionString + ".step" + (i - upgradeStepsList.size() + 1);
            UpgradeInfo upgradeInfo = new UpgradeInfo(upgradeInfoFromSchemaVersionString, upgradeInfoToSchemaVersionString, buildNumber, upgradeStep);
            this._upgradeInfos.add(upgradeInfo);
            upgradeInfoFromSchemaVersionString = upgradeInfoToSchemaVersionString;
        }
        UpgradeInfo upgradeInfo = new UpgradeInfo(upgradeInfoFromSchemaVersionString, toSchemaVersionString, buildNumber, (UpgradeStep)upgradeStepsList.get(upgradeStepsList.size() - 1));
        this._upgradeInfos.add(upgradeInfo);
    }

    private String _getFinalSchemaVersion(List<UpgradeInfo> upgradeInfos) {
        Version finalSchemaVersion = null;
        for (UpgradeInfo upgradeInfo : upgradeInfos) {
            String toSchemaVersion = upgradeInfo.getToSchemaVersionString();
            Version schemaVersion = Version.parseVersion((String)toSchemaVersion.substring(0, 5));
            if (finalSchemaVersion == null) {
                finalSchemaVersion = schemaVersion;
                continue;
            }
            finalSchemaVersion = finalSchemaVersion.compareTo(schemaVersion) >= 0 ? finalSchemaVersion : schemaVersion;
        }
        return finalSchemaVersion.toString();
    }
}

