/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.registry;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.dao.db.DBContext;
import com.liferay.portal.kernel.dao.db.DBProcessContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.upgrade.internal.executor.UpgradeExecutor;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import com.liferay.portal.upgrade.internal.registry.UpgradeStepRegistratorThreadLocal;
import com.liferay.portal.upgrade.internal.registry.UpgradeStepRegistry;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import com.liferay.portal.util.PropsValues;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class UpgradeStepRegistratorTracker {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeStepRegistratorTracker.class);
    private final BundleContext _bundleContext;
    private final ReleaseLocalService _releaseLocalService;
    private final Map<String, List<UpgradeStep>> _releaseUpgradeStepsMap = new HashMap<String, List<UpgradeStep>>();
    private ServiceTracker<UpgradeStepRegistrator, SafeCloseable> _serviceTracker;
    private final UpgradeExecutor _upgradeExecutor;

    public UpgradeStepRegistratorTracker(BundleContext bundleContext, ReleaseLocalService releaseLocalService, UpgradeExecutor upgradeExecutor) {
        this._bundleContext = bundleContext;
        this._releaseLocalService = releaseLocalService;
        this._upgradeExecutor = upgradeExecutor;
    }

    public void close() {
        this._serviceTracker.close();
    }

    public Release fetchUpgradedRelease(String bundleSymbolicName) {
        List<UpgradeStep> releaseUpgradeSteps;
        Release release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
        if (release == null && (releaseUpgradeSteps = this._releaseUpgradeStepsMap.get(bundleSymbolicName)) != null) {
            DBProcessContext dbProcessContext = new DBProcessContext(){

                public DBContext getDBContext() {
                    return new DBContext();
                }

                public OutputStream getOutputStream() {
                    return null;
                }
            };
            for (UpgradeStep releaseUpgradeStep : releaseUpgradeSteps) {
                try {
                    releaseUpgradeStep.upgrade(dbProcessContext);
                }
                catch (UpgradeException upgradeException) {
                    _log.error((Throwable)upgradeException);
                }
            }
            release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
        }
        return release;
    }

    public void open() {
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)this._bundleContext, UpgradeStepRegistrator.class, (ServiceTrackerCustomizer)new UpgradeStepRegistratorServiceTrackerCustomizer());
    }

    private class UpgradeStepRegistratorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<UpgradeStepRegistrator, SafeCloseable> {
        private UpgradeStepRegistratorServiceTrackerCustomizer() {
        }

        public SafeCloseable addingService(ServiceReference<UpgradeStepRegistrator> serviceReference) {
            UpgradeStepRegistrator upgradeStepRegistrator = (UpgradeStepRegistrator)UpgradeStepRegistratorTracker.this._bundleContext.getService(serviceReference);
            if (upgradeStepRegistrator == null) {
                return null;
            }
            Class<?> clazz = upgradeStepRegistrator.getClass();
            Bundle bundle = FrameworkUtil.getBundle(clazz);
            String bundleSymbolicName = bundle.getSymbolicName();
            int buildNumber = 0;
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader.getResource("service.properties") != null) {
                Configuration configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"service");
                Properties properties = configuration.getProperties();
                buildNumber = GetterUtil.getInteger((String)properties.getProperty("build.number"));
            }
            UpgradeStepRegistry upgradeStepRegistry = new UpgradeStepRegistry(buildNumber);
            upgradeStepRegistrator.register((UpgradeStepRegistrator.Registry)upgradeStepRegistry);
            List<UpgradeStep> releaseUpgradeSteps = upgradeStepRegistry.getReleaseCreationUpgradeSteps();
            if (!releaseUpgradeSteps.isEmpty()) {
                UpgradeStepRegistratorTracker.this._releaseUpgradeStepsMap.put(bundleSymbolicName, releaseUpgradeSteps);
            }
            List<UpgradeInfo> upgradeInfos = upgradeStepRegistry.getUpgradeInfos();
            if (PropsValues.UPGRADE_DATABASE_AUTO_RUN || UpgradeStepRegistratorTracker.this._releaseLocalService.fetchRelease(bundleSymbolicName) == null) {
                try {
                    UpgradeStepRegistratorTracker.this._upgradeExecutor.execute(bundleSymbolicName, upgradeInfos);
                }
                catch (Throwable throwable) {
                    _log.error((Object)"Failed upgrade process for module ".concat(bundleSymbolicName), throwable);
                }
            }
            ArrayList<ServiceRegistration> serviceRegistrations = new ArrayList<ServiceRegistration>(upgradeInfos.size());
            try (SafeCloseable safeCloseable = UpgradeStepRegistratorThreadLocal.setEnabled(false);){
                for (UpgradeInfo upgradeInfo : upgradeInfos) {
                    ServiceRegistration serviceRegistration = UpgradeStepRegistratorTracker.this._bundleContext.registerService(UpgradeStep.class, (Object)upgradeInfo.getUpgradeStep(), (Dictionary)HashMapDictionaryBuilder.put((Object)"build.number", (Object)upgradeInfo.getBuildNumber()).put((Object)"upgrade.bundle.symbolic.name", (Object)bundleSymbolicName).put((Object)"upgrade.from.schema.version", (Object)upgradeInfo.getFromSchemaVersionString()).put((Object)"upgrade.to.schema.version", (Object)upgradeInfo.getToSchemaVersionString()).build());
                    serviceRegistrations.add(serviceRegistration);
                }
            }
            return () -> {
                for (ServiceRegistration serviceRegistration : serviceRegistrations) {
                    serviceRegistration.unregister();
                }
                UpgradeStepRegistratorTracker.this._releaseUpgradeStepsMap.remove(bundleSymbolicName);
            };
        }

        public void modifiedService(ServiceReference<UpgradeStepRegistrator> serviceReference, SafeCloseable safeCloseable) {
        }

        public void removedService(ServiceReference<UpgradeStepRegistrator> serviceReference, SafeCloseable safeCloseable) {
            safeCloseable.close();
        }
    }
}

