/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.executor;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.db.DBContext;
import com.liferay.portal.kernel.dao.db.DBProcessContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.DummyUpgradeStep;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.output.stream.container.OutputStreamContainer;
import com.liferay.portal.output.stream.container.OutputStreamContainerFactory;
import com.liferay.portal.output.stream.container.OutputStreamContainerFactoryTracker;
import com.liferay.portal.upgrade.internal.graph.ReleaseGraphManager;
import com.liferay.portal.upgrade.internal.index.updater.IndexUpdaterUtil;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import com.liferay.portal.upgrade.internal.release.ReleasePublisher;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UpgradeExecutor.class})
public class UpgradeExecutor {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeExecutor.class);
    private BundleContext _bundleContext;
    @Reference
    private OutputStreamContainerFactoryTracker _outputStreamContainerFactoryTracker;
    @Reference
    private ReleaseLocalService _releaseLocalService;
    @Reference
    private ReleasePublisher _releasePublisher;

    public void execute(String bundleSymbolicName, List<UpgradeInfo> upgradeInfos) {
        List<List<UpgradeInfo>> upgradeInfosList;
        int size;
        ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager(upgradeInfos);
        String schemaVersionString = "0.0.0";
        Release release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
        if (release != null && Validator.isNotNull((String)release.getSchemaVersion())) {
            schemaVersionString = release.getSchemaVersion();
        }
        if ((size = (upgradeInfosList = releaseGraphManager.getUpgradeInfosList(schemaVersionString)).size()) > 1) {
            throw new IllegalStateException(StringBundler.concat((Object[])new Object[]{"There are ", size, " possible end nodes for ", schemaVersionString}));
        }
        if (size == 0) {
            return;
        }
        this.executeUpgradeInfos(bundleSymbolicName, upgradeInfosList.get(0));
    }

    public void executeUpgradeInfos(String bundleSymbolicName, List<UpgradeInfo> upgradeInfos) {
        OutputStreamContainerFactory outputStreamContainerFactory = this._outputStreamContainerFactoryTracker.getOutputStreamContainerFactory();
        OutputStreamContainer outputStreamContainer = outputStreamContainerFactory.create("upgrade-" + bundleSymbolicName);
        Release release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
        if (release != null) {
            this._releasePublisher.publishInProgress(release);
        }
        try (OutputStream outputStream = outputStreamContainer.getOutputStream();){
            this._outputStreamContainerFactoryTracker.runWithSwappedLog((Runnable)new UpgradeInfosRunnable(bundleSymbolicName, upgradeInfos, outputStream), outputStreamContainer.getDescription(), outputStream);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
        if (release != null) {
            this._releasePublisher.publish(release);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    private class UpgradeInfosRunnable
    implements Runnable {
        private static final int _STATE_IN_PROGRESS = -1;
        private final String _bundleSymbolicName;
        private final OutputStream _outputStream;
        private final List<UpgradeInfo> _upgradeInfos;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int buildNumber = 0;
            int state = 0;
            try {
                this._updateReleaseState(-1);
                for (UpgradeInfo upgradeInfo : this._upgradeInfos) {
                    UpgradeStep upgradeStep = upgradeInfo.getUpgradeStep();
                    upgradeStep.upgrade(new DBProcessContext(){

                        public DBContext getDBContext() {
                            return new DBContext();
                        }

                        public OutputStream getOutputStream() {
                            return UpgradeInfosRunnable.this._outputStream;
                        }
                    });
                    UpgradeExecutor.this._releaseLocalService.updateRelease(this._bundleSymbolicName, upgradeInfo.getToSchemaVersionString(), upgradeInfo.getFromSchemaVersionString());
                    buildNumber = upgradeInfo.getBuildNumber();
                }
            }
            catch (Exception e) {
                state = 1;
                ReflectionUtil.throwException((Throwable)e);
            }
            finally {
                Release release = UpgradeExecutor.this._releaseLocalService.fetchRelease(this._bundleSymbolicName);
                if (release != null) {
                    if (buildNumber > 0) {
                        release.setBuildNumber(buildNumber);
                    }
                    release.setState(state);
                    UpgradeExecutor.this._releaseLocalService.updateRelease(release);
                }
            }
            Bundle bundle = IndexUpdaterUtil.getBundle(UpgradeExecutor.this._bundleContext, this._bundleSymbolicName);
            if (this._requiresUpdateIndexes(bundle)) {
                try {
                    IndexUpdaterUtil.updateIndexes(bundle);
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
            CacheRegistryUtil.clear();
        }

        private UpgradeInfosRunnable(String bundleSymbolicName, List<UpgradeInfo> upgradeInfos, OutputStream outputStream) {
            this._bundleSymbolicName = bundleSymbolicName;
            this._upgradeInfos = upgradeInfos;
            this._outputStream = outputStream;
        }

        private boolean _requiresUpdateIndexes(Bundle bundle) {
            if (!IndexUpdaterUtil.isLiferayServiceBundle(bundle)) {
                return false;
            }
            if (this._upgradeInfos.size() != 1) {
                return true;
            }
            UpgradeInfo upgradeInfo = this._upgradeInfos.get(0);
            UpgradeStep upgradeStep = upgradeInfo.getUpgradeStep();
            if (upgradeStep instanceof DummyUpgradeStep) {
                return false;
            }
            String fromSchemaVersion = upgradeInfo.getFromSchemaVersionString();
            String upgradeStepName = upgradeStep.toString();
            return !fromSchemaVersion.equals("0.0.0") || !upgradeStepName.equals("Initial Database Creation");
        }

        private void _updateReleaseState(int state) {
            Release release = UpgradeExecutor.this._releaseLocalService.fetchRelease(this._bundleSymbolicName);
            if (release != null) {
                release.setState(state);
                UpgradeExecutor.this._releaseLocalService.updateRelease(release);
            }
        }
    }
}

