/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.registry;

import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import java.util.ArrayList;
import java.util.List;

public class UpgradeStepRegistry
implements UpgradeStepRegistrator.Registry {
    private final int _buildNumber;
    private final List<UpgradeInfo> _upgradeInfos = new ArrayList<UpgradeInfo>();

    public UpgradeStepRegistry(int buildNumber) {
        this._buildNumber = buildNumber;
    }

    public List<UpgradeInfo> getUpgradeInfos() {
        return this._upgradeInfos;
    }

    public void register(String bundleSymbolicName, String fromSchemaVersionString, String toSchemaVersionString, UpgradeStep ... upgradeSteps) {
        this.register(fromSchemaVersionString, toSchemaVersionString, upgradeSteps);
    }

    public void register(String fromSchemaVersionString, String toSchemaVersionString, UpgradeStep ... upgradeSteps) {
        this._createUpgradeInfos(fromSchemaVersionString, toSchemaVersionString, this._buildNumber, upgradeSteps);
    }

    private void _createUpgradeInfos(String fromSchemaVersionString, String toSchemaVersionString, int buildNumber, UpgradeStep ... upgradeSteps) {
        if (ArrayUtil.isEmpty((Object[])upgradeSteps)) {
            return;
        }
        String upgradeInfoFromSchemaVersionString = fromSchemaVersionString;
        for (int i = 0; i < upgradeSteps.length - 1; ++i) {
            UpgradeStep upgradeStep = upgradeSteps[i];
            String upgradeInfoToSchemaVersionString = toSchemaVersionString + ".step" + (i - upgradeSteps.length + 1);
            UpgradeInfo upgradeInfo = new UpgradeInfo(upgradeInfoFromSchemaVersionString, upgradeInfoToSchemaVersionString, buildNumber, upgradeStep);
            this._upgradeInfos.add(upgradeInfo);
            upgradeInfoFromSchemaVersionString = upgradeInfoToSchemaVersionString;
        }
        UpgradeInfo upgradeInfo = new UpgradeInfo(upgradeInfoFromSchemaVersionString, toSchemaVersionString, buildNumber, upgradeSteps[upgradeSteps.length - 1]);
        this._upgradeInfos.add(upgradeInfo);
    }
}

