/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.wsdd.builder;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.portal.tools.wsdd.builder.WSDDMerger;
import com.liferay.portal.tools.wsdd.builder.util.Java2WsddTask;
import com.liferay.portal.xml.SAXReaderFactory;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class WSDDBuilder {
    private String _classPath;
    private String _fileName;
    private String _outputPath;
    private String _packagePath;
    private String _portletShortName;
    private String _serverConfigFileName;
    private String _serviceNamespace;

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        try {
            WSDDBuilder wsddBuilder = new WSDDBuilder();
            wsddBuilder._classPath = arguments.get("wsdd.class.path");
            wsddBuilder._fileName = GetterUtil.getString(arguments.get("wsdd.input.file"), "service.xml");
            wsddBuilder._outputPath = GetterUtil.getString(arguments.get("wsdd.output.path"), "src");
            wsddBuilder._serverConfigFileName = GetterUtil.getString(arguments.get("wsdd.server.config.file"), "server-config.wsdd");
            wsddBuilder._serviceNamespace = GetterUtil.getString(arguments.get("wsdd.service.namespace"), "Plugin");
            wsddBuilder.build();
        }
        catch (Exception exception) {
            ArgumentsUtil.processMainException(arguments, exception);
        }
    }

    public void build() throws Exception {
        System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        File serverConfigFile = new File(this._serverConfigFileName);
        if (!serverConfigFile.exists()) {
            Class<?> clazz = this.getClass();
            String serverConfigContent = StringUtil.read(clazz.getClassLoader(), "com/liferay/portal/tools/wsdd/builder/dependencies/server-config.wsdd");
            this._writeFile(serverConfigFile, serverConfigContent);
        }
        SAXReader saxReader = this._getSAXReader();
        Document document = saxReader.read((Reader)new UnsyncStringReader(ToolsUtil.getContent(this._fileName)));
        Element rootElement = document.getRootElement();
        String packagePath = rootElement.attributeValue("package-path");
        Element portletElement = rootElement.element("portlet");
        if (portletElement != null) {
            this._portletShortName = portletElement.attributeValue("short-name");
        } else {
            Element namespaceElement = rootElement.element("namespace");
            this._portletShortName = namespaceElement.getText();
        }
        this._outputPath = this._outputPath + StringUtil.replace(packagePath, '.', '/') + "/service/http";
        this._packagePath = packagePath;
        List entityElements = rootElement.elements("entity");
        for (Element entityElement : entityElements) {
            String entityName = entityElement.attributeValue("name");
            boolean remoteService = GetterUtil.getBoolean(entityElement.attributeValue("remote-service"), true);
            if (!remoteService) continue;
            this._createServiceWSDD(entityName);
            WSDDMerger.merge(StringBundler.concat(this._outputPath, "/", entityName, "Service_deploy.wsdd"), this._serverConfigFileName);
        }
    }

    public void setClassPath(String classPath) {
        this._classPath = classPath;
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }

    public void setOutputPath(String outputPath) {
        this._outputPath = outputPath;
    }

    public void setServerConfigFileName(String serverConfigFileName) {
        this._serverConfigFileName = serverConfigFileName;
    }

    public void setServiceNamespace(String serviceNamespace) {
        this._serviceNamespace = serviceNamespace;
    }

    private void _createServiceWSDD(String entityName) throws Exception {
        String className = StringBundler.concat(this._packagePath, ".service.http.", entityName, "ServiceSoap");
        String serviceName = StringUtil.replace(this._portletShortName, ' ', '_');
        if (!this._portletShortName.equals("Portal")) {
            serviceName = this._serviceNamespace + "_" + serviceName;
        }
        serviceName = serviceName + "_" + entityName + "Service";
        String[] wsdds = Java2WsddTask.generateWsdd(className, this._classPath, serviceName);
        this._writeFile(new File(StringBundler.concat(this._outputPath, "/", entityName, "Service_deploy.wsdd")), wsdds[0]);
        this._writeFile(new File(StringBundler.concat(this._outputPath, "/", entityName, "Service_undeploy.wsdd")), wsdds[1]);
    }

    private SAXReader _getSAXReader() {
        return SAXReaderFactory.getSAXReader(null, false, false);
    }

    private void _writeFile(File file, String content) throws Exception {
        Path path = file.toPath();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        String oldContent = null;
        if (file.exists()) {
            oldContent = new String(Files.readAllBytes(path));
        }
        if (!content.equals(oldContent)) {
            Files.write(path, content.getBytes("UTF-8"), new OpenOption[0]);
        }
    }
}

