/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.BaseImportsFormatter;
import com.liferay.portal.tools.ImportPackage;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaImportsFormatter
extends BaseImportsFormatter {
    private static final Pattern _importsPattern = Pattern.compile("(^[ \t]*import\\s+.*;\n+)+", 8);

    public static String getImports(String content) {
        Matcher matcher = _importsPattern.matcher(content);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    protected ImportPackage createImportPackage(String line) {
        return this.createJavaImportPackage(line);
    }

    protected String doFormat(String content, Pattern importPattern, String packageDir, String className) throws IOException {
        String imports = JavaImportsFormatter.getImports(content);
        if (Validator.isNull(imports)) {
            return content;
        }
        String newImports = this.stripUnusedImports(imports, content, packageDir, className, "\\*");
        if (!imports.equals(newImports = this.sortAndGroupImports(newImports))) {
            content = StringUtil.replaceFirst(content, imports, newImports);
        }
        content = content.replaceFirst("(?m)^[ \t]*(package .*;)\\s*^[ \t]*import", "$1\n\nimport");
        content = content.replaceFirst("(?m)^[ \t]*((?:package|import) .*;)\\s*^[ \t]*/\\*\\*", "$1\n\n/**");
        return content;
    }
}

