/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CentralizedThreadLocal;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public class InitialThreadLocal<T>
extends CentralizedThreadLocal<T> {
    private static final String _METHOD_CLONE = "clone";
    private static final Log _log = LogFactoryUtil.getLog(InitialThreadLocal.class);
    private final String _name;
    private final Supplier<T> _supplier;

    public InitialThreadLocal(String name, Supplier<T> supplier) {
        this(name, supplier, false);
    }

    public InitialThreadLocal(String name, Supplier<T> supplier, boolean shortLived) {
        super(shortLived);
        this._name = name;
        this._supplier = supplier == null ? () -> null : supplier;
    }

    @Deprecated
    public InitialThreadLocal(String name, T initialValue) {
        this(name, (T)new CloneableSupplier(initialValue), false);
    }

    @Deprecated
    public InitialThreadLocal(String name, T initialValue, boolean shortLived) {
        this(name, (T)new CloneableSupplier(initialValue), shortLived);
    }

    public String toString() {
        if (this._name == null) {
            return super.toString();
        }
        return this._name;
    }

    @Override
    protected T initialValue() {
        return this._supplier.get();
    }

    private static class CloneableSupplier<T>
    implements Supplier<T> {
        private final Method _cloneMethod;
        private final T _initialValue;

        @Override
        public T get() {
            if (this._cloneMethod != null) {
                try {
                    return (T)this._cloneMethod.invoke(this._initialValue, new Object[0]);
                }
                catch (Exception e) {
                    _log.error(e, e);
                }
            }
            return this._initialValue;
        }

        private CloneableSupplier(T initialValue) {
            Method cloneMethod = null;
            if (initialValue instanceof Cloneable) {
                try {
                    Class<?> clazz = initialValue.getClass();
                    cloneMethod = clazz.getMethod(InitialThreadLocal._METHOD_CLONE, new Class[0]);
                }
                catch (Exception e) {
                    _log.error(e, e);
                }
            }
            this._cloneMethod = cloneMethod;
            this._initialValue = initialValue;
        }
    }
}

