/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.soy.builder.commands;

import com.beust.jcommander.Parameter;
import com.liferay.portal.tools.soy.builder.commands.Command;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public abstract class BaseSoyJsCommand
implements Command {
    @Parameter(description="The directory containing the .soy.js files to process.", names={"-d", "--directory"}, required=true)
    private File _dir;

    @Override
    public void execute() throws Exception {
        File dir = this.getDir();
        Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                String fileName = String.valueOf(path.getFileName());
                if (fileName.endsWith(".soy.js")) {
                    BaseSoyJsCommand.this.execute(path);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public abstract void execute(Path var1) throws IOException;

    public File getDir() {
        return this._dir;
    }

    public void setDir(File dir) {
        this._dir = dir;
    }
}

