/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.lang;

import java.util.HashMap;
import java.util.Map;

public class ClassResolverUtil {
    private static final Map<String, Class<?>> _primitiveClasses = new HashMap<String, Class<?>>(9, 1.0f){
        {
            this.put("boolean", Boolean.TYPE);
            this.put("byte", Byte.TYPE);
            this.put("char", Character.TYPE);
            this.put("double", Double.TYPE);
            this.put("float", Float.TYPE);
            this.put("int", Integer.TYPE);
            this.put("long", Long.TYPE);
            this.put("short", Short.TYPE);
            this.put("void", Void.TYPE);
        }
    };

    public static Class<?> resolve(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> clazz = _primitiveClasses.get(className);
            if (clazz != null) {
                return clazz;
            }
            throw classNotFoundException;
        }
    }
}

