/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.soy.builder.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.liferay.portal.tools.soy.builder.commands.Command;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

@Parameters(commandDescription="Compiles Closure Templates into JavaScript functions.", commandNames={"build"})
public class BuildSoyCommand
implements Command {
    @Parameter(description="The directory containing the .soy files to compile.", names={"-d", "--directory"}, required=true)
    private File _dir;

    @Override
    public void execute() throws Exception {
        final ArrayList<Path> paths = new ArrayList<Path>();
        File dir = this.getDir();
        Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                String fileName = String.valueOf(path.getFileName());
                if (fileName.endsWith(".soy")) {
                    paths.add(path);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (!paths.isEmpty()) {
            this.execute(paths);
        }
    }

    public void execute(List<Path> paths) throws IOException {
        SoyFileSet.Builder builder = SoyFileSet.builder();
        for (Path path : paths) {
            builder.add(path.toFile());
        }
        SoyFileSet soyFileSet = builder.build();
        SoyJsSrcOptions soyJsSrcOptions = new SoyJsSrcOptions();
        List jsContents = soyFileSet.compileToJsSrc(soyJsSrcOptions, null);
        for (int i = 0; i < paths.size(); ++i) {
            Path path = paths.get(i);
            String jsContent = (String)jsContents.get(i);
            Path dirPath = path.getParent();
            Path jsPath = dirPath.resolve(String.valueOf(path.getFileName()) + ".js");
            Files.write(jsPath, jsContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public File getDir() {
        return this._dir;
    }

    public void setDir(File dir) {
        this._dir = dir;
    }
}

