/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface Http {
    public static final String HTTP = "http";
    public static final int HTTP_PORT = 80;
    public static final String HTTP_WITH_SLASH = "http://";
    public static final String HTTPS = "https";
    public static final int HTTPS_PORT = 443;
    public static final String HTTPS_WITH_SLASH = "https://";
    public static final String PROTOCOL_DELIMITER = "://";
    public static final int URL_MAXIMUM_LENGTH = 2083;

    public String addParameter(String var1, String var2, boolean var3);

    public String addParameter(String var1, String var2, double var3);

    public String addParameter(String var1, String var2, int var3);

    public String addParameter(String var1, String var2, long var3);

    public String addParameter(String var1, String var2, short var3);

    public String addParameter(String var1, String var2, String var3);

    public String decodePath(String var1);

    public String decodeURL(String var1);

    public String encodeParameters(String var1);

    public String encodePath(String var1);

    public String fixPath(String var1);

    public String fixPath(String var1, boolean var2, boolean var3);

    public String getCompleteURL(HttpServletRequest var1);

    public Cookie[] getCookies();

    public String getDomain(String var1);

    public String getIpAddress(String var1);

    public String getParameter(String var1, String var2);

    public String getParameter(String var1, String var2, boolean var3);

    public Map<String, String[]> getParameterMap(String var1);

    public String getPath(String var1);

    public String getProtocol(ActionRequest var1);

    public String getProtocol(boolean var1);

    public String getProtocol(HttpServletRequest var1);

    public String getProtocol(RenderRequest var1);

    public String getProtocol(String var1);

    public String getQueryString(HttpServletRequest var1);

    public String getQueryString(String var1);

    public String getRequestURL(HttpServletRequest var1);

    public URI getURI(String var1);

    public boolean hasDomain(String var1);

    public boolean hasProtocol(String var1);

    public boolean hasProxyConfig();

    public boolean isForwarded(HttpServletRequest var1);

    public boolean isNonProxyHost(String var1);

    public boolean isProxyHost(String var1);

    public boolean isSecure(String var1);

    public String normalizePath(String var1);

    public Map<String, String[]> parameterMapFromString(String var1);

    public String parameterMapToString(Map<String, String[]> var1);

    public String parameterMapToString(Map<String, String[]> var1, boolean var2);

    public String protocolize(String var1, ActionRequest var2);

    public String protocolize(String var1, boolean var2);

    public String protocolize(String var1, HttpServletRequest var2);

    public String protocolize(String var1, int var2, boolean var3);

    public String protocolize(String var1, RenderRequest var2);

    public String removeDomain(String var1);

    public String removeParameter(String var1, String var2);

    public String removePathParameters(String var1);

    public String removeProtocol(String var1);

    public String sanitizeHeader(String var1);

    public String setParameter(String var1, String var2, boolean var3);

    public String setParameter(String var1, String var2, double var3);

    public String setParameter(String var1, String var2, int var3);

    public String setParameter(String var1, String var2, long var3);

    public String setParameter(String var1, String var2, short var3);

    public String setParameter(String var1, String var2, String var3);

    public String shortenURL(String var1);

    public byte[] URLtoByteArray(Options var1) throws IOException;

    public byte[] URLtoByteArray(String var1) throws IOException;

    public byte[] URLtoByteArray(String var1, boolean var2) throws IOException;

    public InputStream URLtoInputStream(Options var1) throws IOException;

    public InputStream URLtoInputStream(String var1) throws IOException;

    public InputStream URLtoInputStream(String var1, boolean var2) throws IOException;

    public String URLtoString(Options var1) throws IOException;

    public String URLtoString(String var1) throws IOException;

    public String URLtoString(String var1, boolean var2) throws IOException;

    public String URLtoString(URL var1) throws IOException;

    public static class Response {
        private int _contentLength = -1;
        private long _contentLengthLong = -1L;
        private String _contentType;
        private Map<String, String> _headers;
        private String _redirect;
        private int _responseCode = -1;

        public void addHeader(String name, String value) {
            if (this._headers == null) {
                this._headers = new HashMap<String, String>();
            }
            this._headers.put(StringUtil.toLowerCase(name), value);
        }

        public int getContentLength() {
            return this._contentLength;
        }

        public long getContentLengthLong() {
            return this._contentLengthLong;
        }

        public String getContentType() {
            return this._contentType;
        }

        public String getHeader(String name) {
            if (this._headers == null) {
                return null;
            }
            return this._headers.get(StringUtil.toLowerCase(name));
        }

        public Map<String, String> getHeaders() {
            return this._headers;
        }

        public String getRedirect() {
            return this._redirect;
        }

        public int getResponseCode() {
            return this._responseCode;
        }

        public void setContentLength(int contentLength) {
            this._contentLength = contentLength;
        }

        public void setContentLengthLong(long contentLengthLong) {
            this._contentLengthLong = contentLengthLong;
        }

        public void setContentType(String contentType) {
            this._contentType = contentType;
        }

        public void setHeaders(Map<String, String> headers) {
            this._headers = headers;
        }

        public void setRedirect(String redirect) {
            this._redirect = redirect;
        }

        public void setResponseCode(int responseCode) {
            this._responseCode = responseCode;
        }
    }

    public static class Options {
        private Auth _auth;
        private Body _body;
        private Cookie[] _cookies;
        private List<FilePart> _fileParts;
        private boolean _followRedirects = true;
        private Map<String, String> _headers;
        private String _location;
        private Method _method = Method.GET;
        private Map<String, String> _parts;
        private Response _response = new Response();
        private int _timeout;

        public void addFilePart(String name, String fileName, byte[] value, String contentType, String charSet) {
            if (this._body != null) {
                throw new IllegalArgumentException("File part cannot be added because a body has already been set");
            }
            if (this._fileParts == null) {
                this._fileParts = new ArrayList<FilePart>();
            }
            FilePart filePart = new FilePart(name, fileName, value, contentType, charSet);
            this._fileParts.add(filePart);
        }

        public void addHeader(String name, String value) {
            if (this._headers == null) {
                this._headers = new HashMap<String, String>();
            }
            this._headers.put(name, value);
        }

        public void addPart(String name, String value) {
            if (this._body != null) {
                throw new IllegalArgumentException("Part cannot be added because a body has already been set");
            }
            if (this._parts == null) {
                this._parts = new HashMap<String, String>();
            }
            this._parts.put(name, value);
        }

        public Auth getAuth() {
            return this._auth;
        }

        public Body getBody() {
            return this._body;
        }

        public Cookie[] getCookies() {
            return this._cookies;
        }

        public List<FilePart> getFileParts() {
            return this._fileParts;
        }

        public Map<String, String> getHeaders() {
            return this._headers;
        }

        public String getLocation() {
            return this._location;
        }

        public Method getMethod() {
            return this._method;
        }

        public Map<String, String> getParts() {
            return this._parts;
        }

        public Response getResponse() {
            return this._response;
        }

        public int getTimeout() {
            return this._timeout;
        }

        public boolean isDelete() {
            return this._method == Method.DELETE;
        }

        public boolean isFollowRedirects() {
            return this._followRedirects;
        }

        public boolean isGet() {
            return this._method == Method.GET;
        }

        public boolean isHead() {
            return this._method == Method.HEAD;
        }

        public boolean isPatch() {
            return this._method == Method.PATCH;
        }

        public boolean isPost() {
            return this._method == Method.POST;
        }

        public boolean isPut() {
            return this._method == Method.PUT;
        }

        public void setAuth(Auth auth) {
            this.setAuth(auth.getHost(), auth.getPort(), auth.getRealm(), auth.getUsername(), auth.getPassword());
        }

        public void setAuth(String host, int port, String realm, String username, String password) {
            this._auth = new Auth(host, port, realm, username, password);
        }

        public void setBody(Body body) {
            this.setBody(body.getContent(), body.getContentType(), body.getCharset());
        }

        public void setBody(String content, String contentType, String charset) {
            if (this._parts != null) {
                throw new IllegalArgumentException("Body cannot be set because a part has already been added");
            }
            this._body = new Body(content, contentType, charset);
        }

        public void setCookies(Cookie[] cookies) {
            this._cookies = cookies;
        }

        public void setDelete(boolean delete) {
            this._method = delete ? Method.DELETE : Method.GET;
        }

        public void setFileParts(List<FilePart> fileParts) {
            this._fileParts = fileParts;
        }

        public void setFollowRedirects(boolean followRedirects) {
            this._followRedirects = followRedirects;
        }

        public void setHead(boolean head) {
            this._method = head ? Method.HEAD : Method.GET;
        }

        public void setHeaders(Map<String, String> headers) {
            this._headers = headers;
        }

        public void setLocation(String location) {
            this._location = location;
        }

        public void setMethod(Method method) {
            if (method != null) {
                this._method = method;
            }
        }

        public void setParts(Map<String, String> parts) {
            this._parts = parts;
        }

        public void setPatch(boolean patch) {
            this._method = patch ? Method.PATCH : Method.GET;
        }

        public void setPost(boolean post) {
            this._method = post ? Method.POST : Method.GET;
        }

        public void setPut(boolean put) {
            this._method = put ? Method.PUT : Method.GET;
        }

        public void setResponse(Response response) {
            this._response = response;
        }

        public void setTimeout(int timeout) {
            this._timeout = timeout;
        }
    }

    public static enum Method {
        DELETE,
        GET,
        HEAD,
        PATCH,
        POST,
        PUT;

    }

    public static class FilePart {
        private final String _charSet;
        private String _contentType;
        private final String _fileName;
        private final String _name;
        private final byte[] _value;

        public FilePart(String name, String fileName, byte[] value, String contentType, String charSet) {
            this._name = name;
            this._fileName = fileName;
            this._value = value;
            this._contentType = contentType;
            this._charSet = charSet;
        }

        public String getCharSet() {
            return this._charSet;
        }

        public String getContentType() {
            return this._contentType;
        }

        public String getFileName() {
            return this._fileName;
        }

        public String getName() {
            return this._name;
        }

        public byte[] getValue() {
            return this._value;
        }
    }

    public static class Body {
        private final String _charset;
        private final String _content;
        private String _contentType;

        public Body(String content, String contentType, String charset) {
            this._content = content;
            this._contentType = contentType;
            this._charset = charset;
        }

        public String getCharset() {
            return this._charset;
        }

        public String getContent() {
            return this._content;
        }

        public String getContentType() {
            return this._contentType;
        }
    }

    public static class Auth {
        private final String _host;
        private final String _password;
        private final int _port;
        private final String _realm;
        private final String _username;

        public Auth(String host, int port, String realm, String username, String password) {
            this._host = host;
            this._port = port;
            this._realm = realm;
            this._username = username;
            this._password = password;
        }

        public String getHost() {
            return this._host;
        }

        public String getPassword() {
            return this._password;
        }

        public int getPort() {
            return this._port;
        }

        public String getRealm() {
            return this._realm;
        }

        public String getUsername() {
            return this._username;
        }
    }
}

