/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.service.builder;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.service.builder.ServiceBuilder;
import java.util.Collections;
import java.util.Map;

public class EntityColumn
implements Cloneable,
Comparable<EntityColumn> {
    private static final Map<String, String> _accessorNames = Collections.singletonMap("com.liferay.portal.kernel.model.LayoutFriendlyURL.layoutFriendlyURLId", "LAYOUT_FRIENDLY_U_R_L_ID_ACCESSOR");
    private final boolean _accessor;
    private String _arrayableOperator;
    private boolean _arrayablePagination;
    private boolean _caseSensitive;
    private String _comparator;
    private boolean _containerModel;
    private boolean _convertNull;
    private final CTColumnResolutionType _ctColumnResolutionType;
    private String _dbName;
    private final String _entityName;
    private final boolean _filterPrimary;
    private boolean _finderPath;
    private final String _humanName;
    private String _idParam;
    private String _idType;
    private boolean _interfaceColumn = true;
    private final boolean _jsonEnabled;
    private boolean _lazy;
    private boolean _localized;
    private final String _mappingTableName;
    private final String _methodName;
    private final String _name;
    private boolean _orderByAscending;
    private boolean _orderColumn;
    private boolean _parentContainerModel;
    private final String _pluralName;
    private final boolean _primary;
    private ServiceBuilder _serviceBuilder;
    private final String _type;
    private final String _uadAnonymizeFieldName;
    private final boolean _uadNonanonymizable;

    public EntityColumn(ServiceBuilder serviceBuilder, String name) {
        this(serviceBuilder, name, null, null, null, null, false, false, false, null, null, true, true, false, null, null, false, null, null, true, true, false, false, CTColumnResolutionType.STRICT, false, false, null, false);
    }

    public EntityColumn(ServiceBuilder serviceBuilder, String name, String dbName) {
        this(serviceBuilder, name, null, dbName, null, "String", false, false, false, null, null, null, null, true, false, false, false, CTColumnResolutionType.STRICT, false, false, null, false);
    }

    public EntityColumn(ServiceBuilder serviceBuilder, String name, String pluralName, String dbName, String methodName, String type, boolean primary, boolean accessor, boolean filterPrimary, String entityName, String mappingTableName, boolean caseSensitive, boolean orderByAscending, boolean orderColumn, String comparator, String arrayableOperator, boolean arrayablePagination, String idType, String idParam, boolean convertNull, boolean lazy, boolean localized, boolean jsonEnabled, CTColumnResolutionType ctColumnResolutionType, boolean containerModel, boolean parentContainerModel, String uadAnonymizeFieldName, boolean uadNonanonymizable) {
        this._serviceBuilder = serviceBuilder;
        this._name = name;
        this._pluralName = GetterUtil.getString(pluralName, serviceBuilder.formatPlural(name));
        this._dbName = dbName;
        this._methodName = GetterUtil.getString(methodName, TextFormatter.format(name, 6));
        this._type = type;
        this._primary = primary;
        this._accessor = accessor;
        this._filterPrimary = filterPrimary;
        this._entityName = entityName;
        this._mappingTableName = mappingTableName;
        this._caseSensitive = caseSensitive;
        this._orderByAscending = orderByAscending;
        this._orderColumn = orderColumn;
        this._comparator = comparator;
        this._arrayableOperator = arrayableOperator;
        this._arrayablePagination = arrayablePagination;
        this._idType = idType;
        this._idParam = idParam;
        this._convertNull = convertNull;
        this._lazy = lazy;
        this._localized = localized;
        this._jsonEnabled = jsonEnabled;
        this._ctColumnResolutionType = ctColumnResolutionType;
        this._containerModel = containerModel;
        this._parentContainerModel = parentContainerModel;
        this._uadAnonymizeFieldName = uadAnonymizeFieldName;
        this._uadNonanonymizable = uadNonanonymizable;
        this._humanName = ServiceBuilder.toHumanName(name);
    }

    public EntityColumn(ServiceBuilder serviceBuilder, String name, String pluralName, String dbName, String methodName, String type, boolean primary, boolean accessor, boolean filterPrimary, String ejbName, String mappingTable, String idType, String idParam, boolean convertNull, boolean lazy, boolean localized, boolean jsonEnabled, CTColumnResolutionType ctColumnResolutionType, boolean containerModel, boolean parentContainerModel, String uadAnonymizeFieldName, boolean uadNonanonymizable) {
        this(serviceBuilder, name, pluralName, dbName, methodName, type, primary, accessor, filterPrimary, ejbName, mappingTable, true, true, false, null, null, false, idType, idParam, convertNull, lazy, localized, jsonEnabled, ctColumnResolutionType, containerModel, parentContainerModel, uadAnonymizeFieldName, uadNonanonymizable);
    }

    public Object clone() {
        return new EntityColumn(this._serviceBuilder, this.getName(), this.getPluralName(), this.getDBName(), this.getMethodName(), this.getType(), this.isPrimary(), this.isAccessor(), this.isFilterPrimary(), this.getEntityName(), this.getMappingTableName(), this.isCaseSensitive(), this.isOrderByAscending(), this.isOrderColumn(), this.getComparator(), this.getArrayableOperator(), this.hasArrayablePagination(), this.getIdType(), this.getIdParam(), this.isConvertNull(), this.isLazy(), this.isLocalized(), this.isJsonEnabled(), this.getCTColumnResolutionType(), this.isContainerModel(), this.isParentContainerModel(), this.getUADAnonymizeFieldName(), this.isUADNonanonymizable());
    }

    @Override
    public int compareTo(EntityColumn entityColumn) {
        return this._name.compareTo(entityColumn._name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EntityColumn)) {
            return false;
        }
        EntityColumn entityColumn = (EntityColumn)object;
        return this._name.equals(entityColumn.getName());
    }

    public String getAccessorName(String className) {
        String accessorName = _accessorNames.get(className + "." + this._name);
        if (Validator.isNull(accessorName)) {
            accessorName = TextFormatter.format(TextFormatter.format(this._name, 7), 0);
            accessorName = accessorName + "_ACCESSOR";
        }
        return accessorName;
    }

    public String getArrayableOperator() {
        return this._arrayableOperator;
    }

    public String getComparator() {
        return this._comparator;
    }

    public CTColumnResolutionType getCTColumnResolutionType() {
        return this._ctColumnResolutionType;
    }

    public String getCTColumnResolutionTypeName() {
        String name = StringUtil.toLowerCase(this._ctColumnResolutionType.toString());
        return StringUtil.upperCaseFirstLetter(name);
    }

    public String getDBName() {
        return this._dbName;
    }

    public String getEntityName() {
        return this._entityName;
    }

    public String getGenericizedType() {
        if (this._type.equals("Map")) {
            return "Map<String, Serializable>";
        }
        return this._type;
    }

    public String getHumanCondition(boolean arrayable) {
        StringBundler sb = new StringBundler(6);
        sb.append(this._name);
        sb.append(" ");
        sb.append(this.convertComparatorToHtml(this._comparator));
        sb.append(" ");
        if (arrayable && this.hasArrayableOperator()) {
            if (this.isArrayableAndOperator()) {
                sb.append("all ");
            } else {
                sb.append("any ");
            }
        }
        sb.append("&#63;");
        return sb.toString();
    }

    public String getHumanName() {
        return this._humanName;
    }

    public String getIdParam() {
        return this._idParam;
    }

    public String getIdType() {
        return this._idType;
    }

    public String getMappingTableName() {
        return this._mappingTableName;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public String getMethodNames() {
        return this._serviceBuilder.formatPlural(this._methodName);
    }

    public String getMethodUserUuidName() {
        return this._methodName.substring(0, this._methodName.length() - 2) + "Uuid";
    }

    public String getName() {
        return this._name;
    }

    public String getPluralHumanName() {
        return this._serviceBuilder.formatPlural(this.getHumanName());
    }

    public String getPluralName() {
        return this._pluralName;
    }

    public String getType() {
        return this._type;
    }

    public String getUADAnonymizeFieldName() {
        if (Validator.isNull(this._uadAnonymizeFieldName) && this.isUADUserId()) {
            return "userId";
        }
        if (Validator.isNull(this._uadAnonymizeFieldName) && this.isUADUserName()) {
            return "fullName";
        }
        return this._uadAnonymizeFieldName;
    }

    public String getUADUserIdColumnName() {
        if (this.isUADUserName()) {
            return StringUtil.replace(this._name, "Name", "Id");
        }
        return "";
    }

    public String getUserUuidHumanName() {
        return ServiceBuilder.toHumanName(this.getUserUuidName());
    }

    public String getUserUuidName() {
        return this._name.substring(0, this._name.length() - 2) + "Uuid";
    }

    public boolean hasArrayableOperator() {
        return Validator.isNotNull(this._arrayableOperator);
    }

    public boolean hasArrayablePagination() {
        return this._arrayablePagination;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean isAccessor() {
        return this._accessor;
    }

    public boolean isArrayableAndOperator() {
        return this._arrayableOperator.equals("AND");
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public boolean isCollection() {
        return this._type.equals("Collection");
    }

    public boolean isContainerModel() {
        return this._containerModel;
    }

    public boolean isConvertNull() {
        return this._convertNull;
    }

    public boolean isFilterPrimary() {
        return this._filterPrimary;
    }

    public boolean isFinderPath() {
        return this._finderPath;
    }

    public boolean isInterfaceColumn() {
        return this._interfaceColumn;
    }

    public boolean isJsonEnabled() {
        return this._jsonEnabled;
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public boolean isLocalized() {
        return this._localized;
    }

    public boolean isMappingManyToMany() {
        return Validator.isNotNull(this._mappingTableName);
    }

    public boolean isOrderByAscending() {
        return this._orderByAscending;
    }

    public boolean isOrderColumn() {
        return this._orderColumn;
    }

    public boolean isParentContainerModel() {
        return this._parentContainerModel;
    }

    public boolean isPrimary() {
        return this._primary;
    }

    public boolean isPrimitiveType() {
        return this.isPrimitiveType(true);
    }

    public boolean isPrimitiveType(boolean includeWrappers) {
        if (Character.isLowerCase(this._type.charAt(0))) {
            return true;
        }
        return includeWrappers && this.isPrimitiveTypeWrapper();
    }

    public boolean isPrimitiveTypeWrapper() {
        if (this._type.equals("Boolean")) {
            return true;
        }
        if (this._type.equals("Byte")) {
            return true;
        }
        if (this._type.equals("Char")) {
            return true;
        }
        if (this._type.equals("Double")) {
            return true;
        }
        if (this._type.equals("Float")) {
            return true;
        }
        if (this._type.equals("Integer")) {
            return true;
        }
        if (this._type.equals("Long")) {
            return true;
        }
        return this._type.equals("Short");
    }

    public boolean isUADEnabled() {
        return Validator.isNotNull(this._uadAnonymizeFieldName) || this._uadNonanonymizable;
    }

    public boolean isUADNonanonymizable() {
        return this._uadNonanonymizable;
    }

    public boolean isUADUserId() {
        return this._isUADUserId(this._name);
    }

    public boolean isUADUserName() {
        return this._name.equals("userName") || this._name.endsWith("UserName");
    }

    public boolean isUserUuid() {
        return this._type.equals("long") && this._methodName.endsWith("UserId");
    }

    public void setArrayableOperator(String arrayableOperator) {
        this._arrayableOperator = StringUtil.toUpperCase(arrayableOperator);
    }

    public void setArrayablePagination(boolean arrayablePagination) {
        this._arrayablePagination = arrayablePagination;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }

    public void setComparator(String comparator) {
        this._comparator = comparator;
    }

    public void setContainerModel(boolean containerModel) {
        this._containerModel = containerModel;
    }

    public void setConvertNull(boolean convertNull) {
        this._convertNull = convertNull;
    }

    public void setDBName(String dbName) {
        this._dbName = dbName;
    }

    public void setFinderPath(boolean finderPath) {
        this._finderPath = finderPath;
    }

    public void setIdParam(String idParam) {
        this._idParam = idParam;
    }

    public void setIdType(String idType) {
        this._idType = idType;
    }

    public void setInterfaceColumn(boolean interfaceColumn) {
        this._interfaceColumn = interfaceColumn;
    }

    public void setLazy(boolean lazy) {
        this._lazy = lazy;
    }

    public void setLocalized(boolean localized) {
        this._localized = localized;
    }

    public void setOrderByAscending(boolean orderByAscending) {
        this._orderByAscending = orderByAscending;
    }

    public void setOrderColumn(boolean orderColumn) {
        this._orderColumn = orderColumn;
    }

    public void setParentContainerModel(boolean parentContainerModel) {
        this._parentContainerModel = parentContainerModel;
    }

    public void validate() {
        if (!(!Validator.isNotNull(this._arrayableOperator) || this._type.equals("char") || this._type.equals("int") || this._type.equals("long") || this._type.equals("short") || this._type.equals("String"))) {
            throw new IllegalArgumentException("Type " + this._type + " cannot be arrayable");
        }
        String comparator = this._comparator;
        if (comparator == null) {
            comparator = "=";
        }
        if (this._arrayableOperator.equals("AND") && !comparator.equals("!=")) {
            throw new IllegalArgumentException("Illegal combination of arrayable \"AND\" and comparator \"" + comparator + "\"");
        }
        if (this._arrayableOperator.equals("OR") && !comparator.equals("=") && !comparator.equals("LIKE")) {
            throw new IllegalArgumentException("Illegal combination of arrayable \"OR\" and comparator \"" + comparator + "\"");
        }
        if (!this._arrayableOperator.equals("OR") && this._arrayablePagination) {
            throw new IllegalArgumentException("Illegal combination of arrayable \"OR\" and arrayable pagination");
        }
    }

    protected String convertComparatorToHtml(String comparator) {
        if (comparator.equals(">")) {
            return "&gt;";
        }
        if (comparator.equals("<")) {
            return "&lt;";
        }
        if (comparator.equals(">=")) {
            return "&ge;";
        }
        if (comparator.equals("<=")) {
            return "&le;";
        }
        if (comparator.equals("!=")) {
            return "&ne;";
        }
        return comparator;
    }

    private boolean _isUADUserId(String name) {
        return name.equals("userId") || name.endsWith("UserId");
    }
}

