/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringEncoder;
import com.liferay.portal.kernel.util.StringParserFragment;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringParser {
    private static final Pattern _escapeRegexPattern = Pattern.compile("[\\{\\}\\(\\)\\[\\]\\*\\+\\?\\$\\^\\.\\#\\\\]");
    private static final Pattern _fragmentPattern = Pattern.compile("\\{.+?\\}");
    private static final Map<String, StringParser> _stringParserCache = new ConcurrentReferenceValueHashMap(FinalizeManager.SOFT_REFERENCE_FACTORY);
    private final BuilderFactory _builderFactory;
    private final Pattern _pattern;
    private StringEncoder _stringEncoder;
    private final List<StringParserFragment> _stringParserFragments;

    public static StringParser create(String chunk) {
        StringParser stringParser = _stringParserCache.get(chunk);
        if (stringParser == null) {
            stringParser = new StringParser(chunk);
            _stringParserCache.put(chunk, stringParser);
        }
        return stringParser;
    }

    public static String escapeRegex(String s) {
        Matcher matcher = _escapeRegexPattern.matcher(s);
        return matcher.replaceAll("\\\\$0");
    }

    public String build(Map<String, String> parameters) {
        Builder builder = null;
        for (StringParserFragment stringParserFragment : this._stringParserFragments) {
            String value = parameters.get(stringParserFragment.getName());
            if (value == null) {
                return null;
            }
            if (this._stringEncoder != null && !stringParserFragment.isRaw()) {
                value = this._stringEncoder.encode(value);
            }
            if (!stringParserFragment.matches(value)) {
                return null;
            }
            if (builder == null) {
                builder = this._builderFactory.create();
            }
            builder.setTokenValue(value);
        }
        for (StringParserFragment stringParserFragment : this._stringParserFragments) {
            parameters.remove(stringParserFragment.getName());
        }
        if (builder == null) {
            return this._builderFactory._pattern;
        }
        return builder.toString();
    }

    public boolean parse(String s, Map<String, String> parameters) {
        Matcher matcher = this._pattern.matcher(s);
        if (!matcher.matches()) {
            return false;
        }
        for (int i = 1; i <= this._stringParserFragments.size(); ++i) {
            StringParserFragment stringParserFragment = this._stringParserFragments.get(i - 1);
            String value = matcher.group(i);
            if (this._stringEncoder != null && !stringParserFragment.isRaw()) {
                value = this._stringEncoder.decode(value);
            }
            parameters.put(stringParserFragment.getName(), value);
        }
        return true;
    }

    public void setStringEncoder(StringEncoder stringEncoder) {
        this._stringEncoder = stringEncoder;
    }

    protected StringParser(String pattern) {
        String regex = StringParser.escapeRegex(pattern);
        Matcher matcher = _fragmentPattern.matcher(pattern);
        this._stringParserFragments = new ArrayList<StringParserFragment>(matcher.groupCount());
        int pos = 0;
        ArrayList<String> builderParts = new ArrayList<String>();
        String originalPattern = pattern;
        while (matcher.find()) {
            int start = matcher.start();
            if (pos < start) {
                builderParts.add(originalPattern.substring(pos, start));
            }
            pos = matcher.end();
            builderParts.add(null);
            String chunk = matcher.group();
            StringParserFragment stringParserFragment = StringParserFragment.create(chunk);
            this._stringParserFragments.add(stringParserFragment);
            pattern = StringUtil.replace(pattern, chunk, stringParserFragment.getToken());
            String stringParserFragmentPattern = stringParserFragment.getPattern();
            regex = StringUtil.replace(regex, StringParser.escapeRegex(chunk), "(".concat(stringParserFragmentPattern.concat(")")));
        }
        if (pos < originalPattern.length()) {
            builderParts.add(originalPattern.substring(pos));
        }
        this._builderFactory = new BuilderFactory(pattern, builderParts);
        this._pattern = Pattern.compile(regex);
    }

    private static class BuilderFactory {
        private final String[] _parts;
        private final String _pattern;

        public Builder create() {
            return new Builder((String[])this._parts.clone());
        }

        private BuilderFactory(String pattern, List<String> parts) {
            this._pattern = pattern;
            this._parts = parts.isEmpty() ? null : parts.toArray(new String[0]);
        }
    }

    private static class Builder {
        private int _index;
        private final String[] _parts;

        public void setTokenValue(String value) {
            if (this._parts[this._index] == null) {
                this._parts[this._index++] = value;
            } else {
                ++this._index;
                this._parts[this._index++] = value;
            }
        }

        public String toString() {
            StringBundler sb = new StringBundler(this._parts);
            return sb.toString();
        }

        private Builder(String[] parts) {
            this._parts = parts;
        }
    }
}

