/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.db;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Arrays;
import java.util.Objects;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class IndexMetadata
extends Index
implements Comparable<IndexMetadata> {
    private final String[] _columnNames;
    private final String _dropSQL;

    public IndexMetadata(String indexName, String tableName, boolean unique, String ... columnNames) {
        super(indexName, tableName, unique);
        if (columnNames == null) {
            throw new NullPointerException("Column names are missing");
        }
        this._columnNames = columnNames;
        StringBundler sb = new StringBundler(5);
        sb.append("drop index ");
        sb.append(indexName);
        sb.append(" on ");
        sb.append(tableName);
        sb.append(";");
        this._dropSQL = sb.toString();
    }

    @Override
    public int compareTo(IndexMetadata indexMetadata) {
        String columnNames = StringUtil.merge(this.getColumnNames());
        String indexMetadataColumnNames = StringUtil.merge(indexMetadata.getColumnNames());
        return columnNames.compareTo(indexMetadataColumnNames);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IndexMetadata)) {
            return false;
        }
        IndexMetadata indexMetadata = (IndexMetadata)obj;
        return Objects.equals(this.getTableName(), indexMetadata.getTableName()) && Arrays.equals(this._columnNames, indexMetadata._columnNames);
    }

    public String[] getColumnNames() {
        String[] columnNames = (String[])this._columnNames.clone();
        for (int i = 0; i < columnNames.length; ++i) {
            int index = columnNames[i].indexOf("[$COLUMN_LENGTH:");
            if (index <= 0) continue;
            columnNames[i] = columnNames[i].substring(0, index);
        }
        return columnNames;
    }

    public String getCreateSQL(int[] lengths) {
        int sbSize = 8 + this._columnNames.length * 2;
        if (lengths != null) {
            sbSize += this._columnNames.length * 3;
        }
        StringBundler sb = new StringBundler(sbSize);
        if (this.isUnique()) {
            sb.append("create unique ");
        } else {
            sb.append("create ");
        }
        sb.append("index ");
        sb.append(this.getIndexName());
        sb.append(" on ");
        sb.append(this.getTableName());
        sb.append(" ");
        sb.append("(");
        for (int i = 0; i < this._columnNames.length; ++i) {
            sb.append(this._columnNames[i]);
            if (lengths != null && lengths[i] > 0) {
                sb.append("[$COLUMN_LENGTH:");
                sb.append(lengths[i]);
                sb.append("$]");
            }
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        sb.append(";");
        return sb.toString();
    }

    public String getDropSQL() {
        return this._dropSQL;
    }

    @Override
    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (Object)this.getTableName());
        for (String columnName : this._columnNames) {
            hashCode = HashUtil.hash((int)hashCode, (Object)columnName);
        }
        return hashCode;
    }

    public Boolean redundantTo(IndexMetadata indexMetadata) {
        String[] indexMetadataColumnNames = indexMetadata._columnNames;
        if (this._columnNames.length <= indexMetadataColumnNames.length) {
            for (int i = 0; i < this._columnNames.length; ++i) {
                if (this._columnNames[i].equals(indexMetadataColumnNames[i])) continue;
                return null;
            }
            if (this.isUnique()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        Boolean redundant = indexMetadata.redundantTo(this);
        if (redundant == null) {
            return null;
        }
        return redundant == false;
    }

    @Override
    public String toString() {
        return this.getCreateSQL(null);
    }
}

