/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.util;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.service.DepotEntryServiceUtil;
import com.liferay.oauth2.provider.scope.ScopeChecker;
import com.liferay.oauth2.provider.scope.liferay.OAuth2ProviderScopeLiferayAccessControlContext;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.graphql.util.GraphQLNamingUtil;
import com.liferay.portal.vulcan.util.UriInfoUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

public class ActionUtil {
    private static final Pattern _pattern = Pattern.compile("\\{(.*?)\\}");

    public static Map<String, String> addAction(String actionName, Class<?> clazz, GroupedModel groupedModel, String methodName, Object object, UriInfo uriInfo) {
        return ActionUtil.addAction(actionName, clazz, (Long)groupedModel.getPrimaryKeyObj(), methodName, object, groupedModel.getUserId(), groupedModel.getModelClassName(), groupedModel.getGroupId(), uriInfo);
    }

    @Deprecated
    public static Map<String, String> addAction(String actionName, Class<?> clazz, GroupedModel groupedModel, String methodName, UriInfo uriInfo) {
        return ActionUtil.addAction(actionName, clazz, (Long)groupedModel.getPrimaryKeyObj(), methodName, null, groupedModel.getUserId(), groupedModel.getModelClassName(), groupedModel.getGroupId(), uriInfo);
    }

    public static Map<String, String> addAction(String actionName, Class<?> clazz, Long id, String methodName, ModelResourcePermission<?> modelResourcePermission, Long parameterId, UriInfo uriInfo) {
        try {
            return ActionUtil._addAction(actionName, clazz, id, methodName, modelResourcePermission, null, null, parameterId, null, null, () -> UriInfoUtil.getBaseUriBuilder(uriInfo), uriInfo);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Map<String, String> addAction(String actionName, Class<?> clazz, Long id, String methodName, Object object, Long ownerId, String permissionName, Long siteId, Supplier<UriBuilder> uriBuilderSupplier, UriInfo uriInfo) {
        try {
            return ActionUtil._addAction(actionName, clazz, id, methodName, null, object, ownerId, id, permissionName, siteId, uriBuilderSupplier, uriInfo);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Deprecated
    public static Map<String, String> addAction(String actionName, Class<?> clazz, Long id, String methodName, Object object, Long ownerId, String permissionName, Long siteId, UriInfo uriInfo) {
        try {
            return ActionUtil.addAction(actionName, clazz, id, methodName, object, ownerId, permissionName, siteId, () -> UriInfoUtil.getBaseUriBuilder(uriInfo), uriInfo);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Map<String, String> addAction(String actionName, Class<?> clazz, Long id, String methodName, Object object, ModelResourcePermission<?> modelResourcePermission, UriInfo uriInfo) {
        try {
            return ActionUtil._addAction(actionName, clazz, id, methodName, modelResourcePermission, object, null, id, null, null, () -> UriInfoUtil.getBaseUriBuilder(uriInfo), uriInfo);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Deprecated
    public static Map<String, String> addAction(String actionName, Class<?> clazz, Long id, String methodName, String permissionName, Long siteId, UriInfo uriInfo) {
        return ActionUtil.addAction(actionName, clazz, id, methodName, null, null, permissionName, siteId, uriInfo);
    }

    @Deprecated
    public static Map<String, String> addAction(String actionName, Class<?> clazz, Long id, String methodName, String permissionName, Object object, Long siteId, UriInfo uriInfo) {
        return ActionUtil.addAction(actionName, clazz, id, methodName, object, null, permissionName, siteId, uriInfo);
    }

    private static Map<String, String> _addAction(String actionName, Class<?> clazz, Long id, String methodName, ModelResourcePermission<?> modelResourcePermission, Object object, Long ownerId, Long parameterId, String permissionName, Long siteId, Supplier<UriBuilder> uriBuilderSupplier, UriInfo uriInfo) throws Exception {
        ScopeChecker scopeChecker;
        List modelResourceActions;
        List<String> strings;
        if (uriInfo == null) {
            return new HashMap<String, String>();
        }
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        String restrictFields = (String)queryParameters.getFirst((Object)"restrictFields");
        if (restrictFields != null && (strings = Arrays.asList(restrictFields.split(","))).contains("actions")) {
            return null;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (modelResourcePermission == null && id != null ? !(modelResourceActions = ResourceActionsUtil.getModelResourceActions((String)permissionName)).contains(actionName) || !ActionUtil._hasPermission(actionName, id, ownerId, permissionChecker, permissionName, siteId) : id != null && !modelResourcePermission.contains(permissionChecker, id.longValue(), actionName)) {
            return null;
        }
        Method method = ActionUtil._getMethod(clazz, methodName);
        String httpMethodName = ActionUtil._getHttpMethodName(clazz, method);
        if (object != null && OAuth2ProviderScopeLiferayAccessControlContext.isOAuth2AuthVerified() && !(scopeChecker = (ScopeChecker)object).checkScope(httpMethodName)) {
            return null;
        }
        String basePath = UriInfoUtil.getBasePath(uriInfo);
        if (basePath.contains("/graphql")) {
            String operation = null;
            String type = null;
            if (httpMethodName.equals("GET")) {
                Class<?> returnType = method.getReturnType();
                operation = GraphQLNamingUtil.getGraphQLPropertyName(methodName, returnType.getName(), TransformUtil.transformToList((Object[])clazz.getMethods(), Method::getName));
                type = "query";
            } else {
                operation = GraphQLNamingUtil.getGraphQLMutationName(methodName);
                type = "mutation";
            }
            return HashMapBuilder.put("operation", operation).put("type", type).build();
        }
        return HashMapBuilder.put("href", () -> {
            UriBuilder uriBuilder = (UriBuilder)uriBuilderSupplier.get();
            if (clazz.getSuperclass().isAnnotationPresent(Path.class)) {
                uriBuilder = uriBuilder.path(clazz.getSuperclass());
            }
            uriBuilder = uriBuilder.path(clazz.getSuperclass(), methodName);
            if (parameterId != null) {
                uriBuilder = uriBuilder.resolveTemplates(ActionUtil._getParameterMap(clazz, parameterId, methodName, siteId, uriInfo), false);
            }
            return uriBuilder.toTemplate();
        }).put("method", httpMethodName).build();
    }

    private static String _getFirstParameterNameFromPath(Class<?> clazz, String methodName) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!Objects.equals(method.getName(), methodName)) continue;
            Path path = method.getAnnotation(Path.class);
            if (path == null) {
                return null;
            }
            Matcher matcher = _pattern.matcher(path.value());
            if (matcher.find()) {
                return matcher.group(1);
            }
            return null;
        }
        return null;
    }

    private static String _getHttpMethodName(Class<?> clazz, Method method) throws Exception {
        Class<?> superClass = clazz.getSuperclass();
        Method superMethod = superClass.getMethod(method.getName(), method.getParameterTypes());
        for (Annotation annotation : superMethod.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            Annotation[] annotations = annotationType.getAnnotationsByType(HttpMethod.class);
            if (annotations.length <= 0) continue;
            HttpMethod httpMethod = (HttpMethod)annotations[0];
            return httpMethod.value();
        }
        return null;
    }

    private static Method _getMethod(Class<?> clazz, String methodName) {
        for (Method method : clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    private static Map<String, Object> _getParameterMap(Class<?> clazz, Long id, String methodName, Long siteId, UriInfo uriInfo) throws PortalException {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        MultivaluedMap pathParameters = uriInfo.getPathParameters();
        for (Map.Entry entry : pathParameters.entrySet()) {
            List value = (List)entry.getValue();
            parameterMap.put((String)entry.getKey(), value.get(0));
        }
        String firstParameterName = ActionUtil._getFirstParameterNameFromPath(clazz.getSuperclass(), methodName);
        if (Validator.isNull(firstParameterName)) {
            return parameterMap;
        }
        if (siteId != null && Objects.equals(firstParameterName, "assetLibraryId")) {
            DepotEntry depotEntry = DepotEntryServiceUtil.getGroupDepotEntry((long)siteId);
            parameterMap.put(firstParameterName, depotEntry.getDepotEntryId());
        } else if (siteId != null && Objects.equals(firstParameterName, "siteId")) {
            parameterMap.put(firstParameterName, siteId);
        } else {
            parameterMap.put(firstParameterName, id);
        }
        return parameterMap;
    }

    private static boolean _hasPermission(String actionName, Long id, Long ownerId, PermissionChecker permissionChecker, String permissionName, Long siteId) {
        return ownerId != null && permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), permissionName, id.longValue(), ownerId.longValue(), actionName) || permissionChecker.hasPermission(siteId.longValue(), permissionName, id.longValue(), actionName);
    }
}

