/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser;

import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser.util.OpenAPIParserUtil;
import com.liferay.portal.tools.rest.builder.internal.freemarker.util.OpenAPIUtil;
import com.liferay.portal.tools.rest.builder.internal.yaml.config.ConfigYAML;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Items;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.OpenAPIYAML;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class DTOOpenAPIParser {
    public static Map<String, Schema> getEnumSchemas(OpenAPIYAML openAPIYAML, Schema schema) {
        Map<String, Schema> propertySchemas = schema.getPropertySchemas();
        if (propertySchemas == null) {
            return Collections.emptyMap();
        }
        TreeMap<String, Schema> enumSchemas = new TreeMap<String, Schema>();
        for (Map.Entry<String, Schema> entry : propertySchemas.entrySet()) {
            Schema propertySchema = entry.getValue();
            List<String> enumValues = propertySchema.getEnumValues();
            if (enumValues == null || enumValues.isEmpty()) continue;
            String propertySchemaName = entry.getKey();
            enumSchemas.put(DTOOpenAPIParser._getEnumName(openAPIYAML, propertySchemaName), propertySchema);
        }
        return enumSchemas;
    }

    public static Map<String, String> getProperties(ConfigYAML configYAML, boolean excludeReadOnly, OpenAPIYAML openAPIYAML, Schema schema) {
        Map<String, String> javaDataTypeMap = OpenAPIParserUtil.getJavaDataTypeMap(configYAML, openAPIYAML);
        TreeMap<String, String> properties = new TreeMap<String, String>();
        Map<String, Schema> propertySchemas = DTOOpenAPIParser._getPropertySchemas(schema);
        for (Map.Entry<String, Schema> entry : propertySchemas.entrySet()) {
            Schema propertySchema = entry.getValue();
            if (excludeReadOnly && propertySchema.isReadOnly()) continue;
            String propertySchemaName = entry.getKey();
            properties.put(DTOOpenAPIParser._getPropertyName(propertySchema, propertySchemaName), DTOOpenAPIParser._getPropertyType(javaDataTypeMap, openAPIYAML, propertySchema, propertySchemaName));
        }
        return properties;
    }

    public static Map<String, String> getProperties(ConfigYAML configYAML, OpenAPIYAML openAPIYAML, Schema schema) {
        return DTOOpenAPIParser.getProperties(configYAML, false, openAPIYAML, schema);
    }

    public static Map<String, String> getProperties(ConfigYAML configYAML, OpenAPIYAML openAPIYAML, String schemaName) {
        Map<String, Schema> schemas = OpenAPIUtil.getAllSchemas(openAPIYAML);
        Schema schema = schemas.get(schemaName);
        return DTOOpenAPIParser.getProperties(configYAML, openAPIYAML, schema);
    }

    public static Schema getPropertySchema(String propertyName, Schema schema) {
        Map<String, Schema> propertySchemas = DTOOpenAPIParser._getPropertySchemas(schema);
        for (Map.Entry<String, Schema> entry : propertySchemas.entrySet()) {
            String propertySchemaName = entry.getKey();
            Schema propertySchema = entry.getValue();
            String curPropertyName = DTOOpenAPIParser._getPropertyName(propertySchema, propertySchemaName);
            if (!StringUtil.equalsIgnoreCase(curPropertyName, propertyName)) continue;
            return propertySchema;
        }
        return null;
    }

    public static boolean isSchemaProperty(OpenAPIYAML openAPIYAML, String propertyName, Schema schema) {
        Map<String, Schema> propertySchemas = DTOOpenAPIParser._getPropertySchemas(schema);
        for (Map.Entry<String, Schema> entry : propertySchemas.entrySet()) {
            String propertySchemaName = entry.getKey();
            if (!propertySchemaName.equals(propertyName)) continue;
            return DTOOpenAPIParser._isSchema(entry.getValue());
        }
        return false;
    }

    private static String _getEnumName(OpenAPIYAML openAPIYAML, String propertySchemaName) {
        Map<String, Schema> schemas = OpenAPIUtil.getAllSchemas(openAPIYAML);
        for (String schemaName : schemas.keySet()) {
            String suffix;
            if (propertySchemaName.length() <= schemaName.length() || !StringUtil.startsWith(StringUtil.toLowerCase(propertySchemaName), StringUtil.toLowerCase(schemaName)) || !Character.isUpperCase((suffix = propertySchemaName.substring(schemaName.length())).charAt(0))) continue;
            return schemaName + suffix;
        }
        return StringUtil.upperCaseFirstLetter(propertySchemaName);
    }

    private static String _getPropertyName(Schema propertySchema, String propertySchemaName) {
        String name = CamelCaseUtil.toCamelCase(propertySchemaName);
        if (StringUtil.equalsIgnoreCase(propertySchema.getType(), "object") && propertySchema.getItems() != null) {
            return OpenAPIUtil.formatSingular(name);
        }
        return name;
    }

    private static Map<String, Schema> _getPropertySchemas(Schema schema) {
        Map<String, Schema> propertySchemas = null;
        Items items = schema.getItems();
        propertySchemas = items != null ? items.getPropertySchemas() : (schema.getAllOfSchemas() != null ? OpenAPIParserUtil.getAllOfPropertySchemas(schema) : schema.getPropertySchemas());
        if (propertySchemas == null) {
            return Collections.emptyMap();
        }
        Set<Map.Entry<String, Schema>> entries = propertySchemas.entrySet();
        entries.forEach(entry -> {
            Schema propertySchema = (Schema)entry.getValue();
            propertySchema.setName((String)entry.getKey());
        });
        return propertySchemas;
    }

    private static String _getPropertyType(Map<String, String> javaDataTypeMap, OpenAPIYAML openAPIYAML, Schema propertySchema, String propertySchemaName) {
        String javaDataType;
        String name;
        List<String> enumValues = propertySchema.getEnumValues();
        if (enumValues != null && !enumValues.isEmpty()) {
            return DTOOpenAPIParser._getEnumName(openAPIYAML, propertySchemaName);
        }
        Items items = propertySchema.getItems();
        String type = propertySchema.getType();
        if (StringUtil.equals(type, "array") && items != null && StringUtil.equalsIgnoreCase(items.getType(), "object") && javaDataTypeMap.containsKey(name = OpenAPIUtil.formatSingular(StringUtil.upperCaseFirstLetter(propertySchemaName)))) {
            return name + "[]";
        }
        if (StringUtil.equalsIgnoreCase(type, "object") && (propertySchema.getAdditionalPropertySchema() == null || DTOOpenAPIParser._isEmpty(propertySchema.getAdditionalPropertySchema()))) {
            name = StringUtil.upperCaseFirstLetter(propertySchemaName);
            if (items != null) {
                name = OpenAPIUtil.formatSingular(name);
            }
            if (javaDataTypeMap.containsKey(name)) {
                return name;
            }
        }
        if ((javaDataType = OpenAPIParserUtil.getJavaDataType(javaDataTypeMap, propertySchema)).startsWith("[")) {
            String name2 = OpenAPIParserUtil.getElementClassName(javaDataType);
            if (name2.lastIndexOf(46) != -1) {
                name2 = name2.substring(name2.lastIndexOf(".") + 1);
            }
            return name2 + "[]";
        }
        if (javaDataType.startsWith("Map")) {
            int index = javaDataType.lastIndexOf(".");
            if (index != -1) {
                String mapType = javaDataType.substring(0, javaDataType.lastIndexOf(" "));
                return mapType + javaDataType.substring(index + 1);
            }
            return "Map<String, ?>";
        }
        String propertyType = javaDataType;
        if (propertyType.lastIndexOf(46) != -1) {
            propertyType = propertyType.substring(propertyType.lastIndexOf(".") + 1);
        }
        return propertyType;
    }

    private static boolean _isEmpty(Schema schema) {
        return schema.getAdditionalPropertySchema() == null && schema.getAllOfSchemas() == null && schema.getAnyOfSchemas() == null && schema.getItems() == null && schema.getOneOfSchemas() == null && schema.getPropertySchemas() == null && schema.getReference() == null && schema.getType() == null;
    }

    private static boolean _isObject(Schema schema, String type) {
        return Objects.equals(type, "object") && schema.getAdditionalPropertySchema() == null;
    }

    private static boolean _isSchema(Schema schema) {
        Items items = schema.getItems();
        return DTOOpenAPIParser._isObject(schema, schema.getType()) || schema.getAllOfSchemas() != null || schema.getReference() != null || items != null && (DTOOpenAPIParser._isObject(schema, items.getType()) || items.getReference() != null);
    }
}

