/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.rest.builder.internal.freemarker.tool;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.JavaMethodParameter;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.JavaMethodSignature;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser.DTOOpenAPIParser;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser.GraphQLOpenAPIParser;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser.ResourceOpenAPIParser;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser.ResourceTestCaseOpenAPIParser;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser.util.OpenAPIParserUtil;
import com.liferay.portal.tools.rest.builder.internal.yaml.config.Application;
import com.liferay.portal.tools.rest.builder.internal.yaml.config.ConfigYAML;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Components;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Content;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Get;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Info;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.OpenAPIYAML;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Operation;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Parameter;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.PathItem;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.RequestBody;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Schema;
import com.liferay.portal.vulcan.graphql.util.GraphQLNamingUtil;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class FreeMarkerTool {
    private static final DateFormat _dateFormat = FreeMarkerTool._getDateFormat("yyyy-MM-dd");
    private static final DateFormat _dateTimeDateFormat = FreeMarkerTool._getDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final FreeMarkerTool _freeMarkerTool = new FreeMarkerTool();

    public static FreeMarkerTool getInstance() {
        return _freeMarkerTool;
    }

    public boolean containsJavaMethodSignature(List<JavaMethodSignature> javaMethodSignatures, String text) {
        for (JavaMethodSignature javaMethodSignature : javaMethodSignatures) {
            String javaMethodSignatureMethodName = javaMethodSignature.getMethodName();
            if (!javaMethodSignatureMethodName.contains(text)) continue;
            return true;
        }
        return false;
    }

    public boolean containsParameterType(List<JavaMethodSignature> javaMethodSignatures, String parameterType) {
        for (JavaMethodSignature javaMethodSignature : javaMethodSignatures) {
            for (JavaMethodParameter javaMethodParameter : javaMethodSignature.getJavaMethodParameters()) {
                if (!StringUtil.equals(javaMethodParameter.getParameterType(), parameterType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean generateBatch(ConfigYAML configYAML, String javaDataType, List<JavaMethodSignature> javaMethodSignatures, String schemaName) {
        if (!configYAML.isGenerateBatch() || javaDataType == null || javaDataType.isEmpty()) {
            return false;
        }
        return ResourceOpenAPIParser.hasResourceBatchJavaMethodSignatures(javaMethodSignatures) || ResourceOpenAPIParser.hasResourceGetPageJavaMethodSignature(javaDataType, javaMethodSignatures);
    }

    public Map<String, Schema> getAllSchemas(Map<String, Schema> allExternalSchemas, OpenAPIYAML openAPIYAML, Map<String, Schema> schemas) {
        Map<String, PathItem> pathItems = openAPIYAML.getPathItems();
        if (pathItems == null) {
            return Collections.emptyMap();
        }
        Set<Map.Entry<String, PathItem>> entries = pathItems.entrySet();
        for (Map.Entry<String, PathItem> entry : entries) {
            List<Operation> operations = OpenAPIParserUtil.getOperations(entry.getValue());
            for (Operation operation : operations) {
                List<String> tags = operation.getTags();
                for (String tag : tags) {
                    if (schemas.containsKey(tag)) continue;
                    if (allExternalSchemas != null && allExternalSchemas.containsKey(tag)) {
                        schemas.put(tag, allExternalSchemas.get(tag));
                        continue;
                    }
                    schemas.put(tag, new Schema());
                }
            }
        }
        return schemas;
    }

    public List<JavaMethodParameter> getBodyJavaMethodParameters(JavaMethodSignature javaMethodSignature) {
        ArrayList<JavaMethodParameter> javaMethodParameters = new ArrayList<JavaMethodParameter>();
        for (JavaMethodParameter javaMethodParameter : javaMethodSignature.getJavaMethodParameters()) {
            boolean exists = false;
            for (JavaMethodParameter pathJavaMethodParameter : javaMethodSignature.getPathJavaMethodParameters()) {
                if (!Objects.equals(pathJavaMethodParameter.getParameterName(), javaMethodParameter.getParameterName()) || !Objects.equals(pathJavaMethodParameter.getParameterType(), javaMethodParameter.getParameterType())) continue;
                exists = true;
                break;
            }
            if (exists || this.isQueryParameter(javaMethodParameter, javaMethodSignature.getOperation())) continue;
            javaMethodParameters.add(javaMethodParameter);
        }
        return javaMethodParameters;
    }

    public String getClientParameters(List<JavaMethodParameter> javaMethodParameters, String schemaName, String schemaVarName) {
        StringBuilder sb = new StringBuilder();
        for (JavaMethodParameter javaMethodParameter : javaMethodParameters) {
            String parameterAnnotation;
            String parameter = OpenAPIParserUtil.getParameter(javaMethodParameter, parameterAnnotation = null);
            if (parameter.contains("dto")) {
                sb.append(parameter.substring(parameter.lastIndexOf(".") + 1));
            } else {
                sb.append(parameter);
            }
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        String parameter = sb.toString();
        parameter = StringUtil.replace(parameter, ".constant.", ".client.constant.");
        parameter = StringUtil.replace(parameter, "com.liferay.portal.kernel.search.filter.Filter filter", "String filterString");
        parameter = StringUtil.replace(parameter, "com.liferay.portal.kernel.search.Sort[] sorts", "String sortString");
        parameter = StringUtil.replace(parameter, "com.liferay.portal.vulcan.aggregation.Aggregation aggregation", "List<String> aggregations");
        parameter = StringUtil.replace(parameter, "com.liferay.portal.vulcan.multipart.MultipartBody multipartBody", StringBundler.concat(schemaName, " ", schemaVarName, ", Map<String, File> multipartFiles"));
        parameter = StringUtil.removeSubstring(parameter, "com.liferay.portal.vulcan.pagination.");
        parameter = StringUtil.removeSubstring(parameter, "com.liferay.portal.vulcan.permission.");
        return parameter;
    }

    public Map<String, Schema> getDTOEnumSchemas(OpenAPIYAML openAPIYAML, Schema schema) {
        return DTOOpenAPIParser.getEnumSchemas(openAPIYAML, schema);
    }

    public String getDTOParentClassName(OpenAPIYAML openAPIYAML, String schemaName) {
        Map<String, Schema> schemas = this.getSchemas(openAPIYAML);
        for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
            Schema schema = entry.getValue();
            if (schema.getOneOfSchemas() == null) continue;
            for (Schema oneOfSchema : schema.getOneOfSchemas()) {
                Map<String, Schema> propertySchemas = oneOfSchema.getPropertySchemas();
                Set<String> keys = propertySchemas.keySet();
                Iterator<String> iterator = keys.iterator();
                if (!StringUtil.equalsIgnoreCase(schemaName, iterator.next())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public Map<String, String> getDTOProperties(ConfigYAML configYAML, OpenAPIYAML openAPIYAML, Schema schema) {
        return DTOOpenAPIParser.getProperties(configYAML, openAPIYAML, schema);
    }

    public Map<String, String> getDTOProperties(ConfigYAML configYAML, OpenAPIYAML openAPIYAML, String schemaName) {
        return DTOOpenAPIParser.getProperties(configYAML, openAPIYAML, schemaName);
    }

    public Schema getDTOPropertySchema(String propertyName, Schema schema) {
        return DTOOpenAPIParser.getPropertySchema(propertyName, schema);
    }

    public String getEnumFieldName(String value) {
        String fieldName = TextFormatter.format(value, 7);
        fieldName = fieldName.replaceAll("[ \\-\\/]", "_");
        fieldName = fieldName.replaceAll("[^a-zA-Z0-9_]", "");
        fieldName = fieldName.replaceAll("_+", "_");
        return StringUtil.toUpperCase(fieldName);
    }

    public String getGraphQLArguments(List<JavaMethodParameter> javaMethodParameters, String schemaVarName) {
        HashMap<String, String> substitutions = HashMapBuilder.put("aggregation", "_aggregationBiFunction.apply(" + schemaVarName + "Resource, aggregations)").put("assetLibraryId", "Long.valueOf(assetLibraryId)").put("filter", "_filterBiFunction.apply(" + schemaVarName + "Resource, filterString)").put("siteId", "Long.valueOf(siteKey)").put("sorts", "_sortsBiFunction.apply(" + schemaVarName + "Resource, sortsString)").build();
        StringBuilder sb = new StringBuilder();
        for (JavaMethodParameter javaMethodParameter : javaMethodParameters) {
            sb.append(this._replaceGraphQLParameter(javaMethodParameter.getParameterName(), substitutions));
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return StringUtil.replace(sb.toString(), "pageSize,page", "Pagination.of(page, pageSize)");
    }

    public List<JavaMethodSignature> getGraphQLJavaMethodSignatures(ConfigYAML configYAML, String graphQLType, OpenAPIYAML openAPIYAML) throws Exception {
        return GraphQLOpenAPIParser.getJavaMethodSignatures(configYAML, openAPIYAML, operation -> {
            String requiredType = "mutation";
            if (operation instanceof Get) {
                requiredType = "query";
            }
            return requiredType.equals(graphQLType);
        });
    }

    public String getGraphQLJavaParameterName(ConfigYAML configYAML, OpenAPIYAML openAPIYAML, String schemaName, JavaMethodParameter javaMethodParameter) {
        Map<String, String> properties = this.getDTOProperties(configYAML, openAPIYAML, schemaName);
        return this._getParentProperty(schemaName, javaMethodParameter, properties.keySet());
    }

    public String getGraphQLMethodAnnotations(JavaMethodSignature javaMethodSignature) {
        return GraphQLOpenAPIParser.getMethodAnnotations(javaMethodSignature);
    }

    public String getGraphQLMethodJavadoc(JavaMethodSignature javaMethodSignature, List<JavaMethodSignature> javaMethodSignatures, OpenAPIYAML openAPIYAML) {
        return StringBundler.concat("Invoke this method with the command line:\n*\n* curl -H ", "'Content-Type: text/plain; charset=utf-8' -X 'POST' ", "'http://localhost:8080/o/graphql' -d $'", this._getGraphQLBody(javaMethodSignature, javaMethodSignatures, openAPIYAML), "' -u 'test@liferay.com:test'");
    }

    public String getGraphQLMutationName(String methodName) {
        return GraphQLNamingUtil.getGraphQLMutationName(methodName);
    }

    public String getGraphQLParameters(List<JavaMethodParameter> javaMethodParameters, Operation operation, boolean annotation) {
        String parameters = GraphQLOpenAPIParser.getParameters(javaMethodParameters, operation, annotation);
        parameters = StringUtil.replace(parameters, "@GraphQLName(\"assetLibraryId\") java.lang.Long assetLibraryId", "@GraphQLName(\"assetLibraryId\") @NotEmpty String assetLibraryId");
        parameters = StringUtil.replace(parameters, "@GraphQLName(\"siteId\") java.lang.Long siteId", "@GraphQLName(\"siteKey\") @NotEmpty String siteKey");
        parameters = StringUtil.replace(parameters, "com.liferay.portal.kernel.search.filter.Filter filter", "String filterString");
        parameters = StringUtil.replace(parameters, "com.liferay.portal.kernel.search.Sort[] sorts", "String sortsString");
        parameters = StringUtil.replace(parameters, "com.liferay.portal.vulcan.aggregation.Aggregation aggregation", "List<String> aggregations");
        return parameters;
    }

    public String getGraphQLPropertyName(JavaMethodSignature javaMethodSignature, List<JavaMethodSignature> javaMethodSignatures) {
        return GraphQLNamingUtil.getGraphQLPropertyName(javaMethodSignature.getMethodName(), javaMethodSignature.getReturnType(), ListUtil.toList(javaMethodSignatures, JavaMethodSignature::getMethodName));
    }

    public List<JavaMethodSignature> getGraphQLRelationJavaMethodSignatures(ConfigYAML configYAML, String graphQLType, OpenAPIYAML openAPIYAML) throws Exception {
        List<JavaMethodSignature> javaMethodSignatures = this._getSortedJavaMethodSignatures(configYAML, graphQLType, openAPIYAML);
        Map<String, Schema> schemas = this.getSchemas(openAPIYAML);
        HashMap<String, JavaMethodSignature> javaMethodSignatureMap = new HashMap<String, JavaMethodSignature>();
        for (JavaMethodSignature javaMethodSignature : javaMethodSignatures) {
            List<JavaMethodParameter> javaMethodParameters = javaMethodSignature.getJavaMethodParameters();
            if (javaMethodParameters.isEmpty()) continue;
            JavaMethodParameter javaMethodParameter = javaMethodParameters.get(0);
            String parameterName = javaMethodParameter.getParameterName();
            String methodName = javaMethodSignature.getMethodName();
            JavaMethodSignature relationJavaMethodSignature = this._getGraphQLPathRelation(javaMethodSignature, javaMethodSignatures, parameterName, schemas);
            if (relationJavaMethodSignature != null) {
                javaMethodSignatureMap.put(methodName, relationJavaMethodSignature);
            }
            for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
                Schema schema = entry.getValue();
                Map<String, Schema> propertySchemas = schema.getPropertySchemas();
                if (propertySchemas == null) continue;
                for (String propertyName : propertySchemas.keySet()) {
                    if (!this._isGraphQLPropertyRelation(javaMethodSignature, parameterName, propertyName, entry.getKey())) continue;
                    javaMethodSignatureMap.put(methodName, this._getJavaMethodSignature(javaMethodSignature, entry.getKey()));
                }
            }
        }
        return new ArrayList<JavaMethodSignature>(javaMethodSignatureMap.values());
    }

    public String getGraphQLRelationName(JavaMethodSignature javaMethodSignature, List<JavaMethodSignature> javaMethodSignatures) {
        String methodName = this.getGraphQLPropertyName(javaMethodSignature, javaMethodSignatures);
        return StringUtil.lowerCaseFirstLetter(methodName.replaceFirst(StringUtil.lowerCaseFirstLetter(javaMethodSignature.getParentSchemaName()), ""));
    }

    public Set<String> getGraphQLSchemaNames(List<JavaMethodSignature> javaMethodSignatures) {
        return OpenAPIParserUtil.getSchemaNames(javaMethodSignatures);
    }

    public String getHTTPMethod(Operation operation) {
        return OpenAPIParserUtil.getHTTPMethod(operation);
    }

    public String getJavaDataType(ConfigYAML configYAML, OpenAPIYAML openAPIYAML, Schema schema) {
        return OpenAPIParserUtil.getJavaDataType(OpenAPIParserUtil.getJavaDataTypeMap(configYAML, openAPIYAML), schema);
    }

    public String getJavaDataType(ConfigYAML configYAML, OpenAPIYAML openAPIYAML, String schemaName) {
        Map<String, String> javaDataTypeMap = OpenAPIParserUtil.getJavaDataTypeMap(configYAML, openAPIYAML);
        return javaDataTypeMap.get(schemaName);
    }

    public JavaMethodSignature getJavaMethodSignature(List<JavaMethodSignature> javaMethodSignatures, String methodName) {
        for (JavaMethodSignature javaMethodSignature : javaMethodSignatures) {
            if (!methodName.equals(javaMethodSignature.getMethodName())) continue;
            return javaMethodSignature;
        }
        return null;
    }

    public String getObjectFieldStringValue(String type, Object value) {
        if (value instanceof Date) {
            if (type.equals("Date")) {
                return _dateFormat.format(value);
            }
            return _dateTimeDateFormat.format(value);
        }
        return value.toString();
    }

    public List<JavaMethodSignature> getParentGraphQLRelationJavaMethodSignatures(ConfigYAML configYAML, String graphQLType, OpenAPIYAML openAPIYAML) throws Exception {
        Map<String, Schema> schemas = this.getSchemas(openAPIYAML);
        List<JavaMethodSignature> javaMethodSignatures = this._getSortedJavaMethodSignatures(configYAML, graphQLType, openAPIYAML);
        ArrayList<JavaMethodSignature> parentJavaMethodSignatures = new ArrayList<JavaMethodSignature>();
        for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
            Schema schema = entry.getValue();
            Map<String, Schema> propertySchemas = schema.getPropertySchemas();
            if (propertySchemas == null) continue;
            Set<String> propertyNames = propertySchemas.keySet();
            block1: for (String propertyName : propertyNames) {
                if (!propertyName.startsWith("parent") || propertyNames.contains(StringUtil.removeSubstring(propertyName, "Id"))) continue;
                propertyName = StringUtil.lowerCaseFirstLetter(StringUtil.removeSubstring(propertyName, "parent"));
                for (JavaMethodSignature javaMethodSignature : javaMethodSignatures) {
                    JavaMethodParameter javaMethodParameter;
                    List<JavaMethodParameter> javaMethodParameters = javaMethodSignature.getJavaMethodParameters();
                    if (javaMethodParameters.isEmpty() || !propertyName.equals((javaMethodParameter = javaMethodParameters.get(0)).getParameterName())) continue;
                    parentJavaMethodSignatures.add(this._getJavaMethodSignature(javaMethodSignature, entry.getKey()));
                    continue block1;
                }
            }
        }
        return parentJavaMethodSignatures;
    }

    public JavaMethodSignature getPostSchemaJavaMethodSignature(List<JavaMethodSignature> javaMethodSignatures, String parameterName, String schemaName) {
        for (JavaMethodSignature javaMethodSignature : javaMethodSignatures) {
            List<JavaMethodParameter> javaMethodParameters;
            Operation operation = javaMethodSignature.getOperation();
            if (!Objects.equals(this.getHTTPMethod(operation), "post")) continue;
            StringBundler sb = new StringBundler(3);
            sb.append(this.getHTTPMethod(operation));
            if (parameterName.startsWith("parent")) {
                parameterName = parameterName.substring(6);
            }
            if (parameterName.endsWith("Id")) {
                parameterName = parameterName.substring(0, parameterName.length() - 2);
            }
            sb.append(StringUtil.upperCaseFirstLetter(parameterName));
            sb.append(StringUtil.upperCaseFirstLetter(schemaName));
            if (!Objects.equals(javaMethodSignature.getMethodName(), sb.toString()) || (javaMethodParameters = javaMethodSignature.getJavaMethodParameters()).size() != 2 || SetUtil.isEmpty(javaMethodSignature.getRequestBodyMediaTypes())) continue;
            return javaMethodSignature;
        }
        return null;
    }

    public String getResourceArguments(List<JavaMethodParameter> javaMethodParameters) {
        return OpenAPIParserUtil.getArguments(javaMethodParameters);
    }

    public List<JavaMethodSignature> getResourceJavaMethodSignatures(ConfigYAML configYAML, OpenAPIYAML openAPIYAML, String schemaName) {
        return ResourceOpenAPIParser.getJavaMethodSignatures(configYAML, openAPIYAML, schemaName);
    }

    public String getResourceMethodAnnotations(JavaMethodSignature javaMethodSignature) {
        return ResourceOpenAPIParser.getMethodAnnotations(javaMethodSignature);
    }

    public String getResourceParameters(List<JavaMethodParameter> javaMethodParameters, OpenAPIYAML openAPIYAML, Operation operation, boolean annotation) {
        return ResourceOpenAPIParser.getParameters(javaMethodParameters, openAPIYAML, operation, annotation);
    }

    public String getResourceTestCaseArguments(List<JavaMethodParameter> javaMethodParameters) {
        return OpenAPIParserUtil.getArguments(javaMethodParameters);
    }

    public List<JavaMethodSignature> getResourceTestCaseJavaMethodSignatures(ConfigYAML configYAML, OpenAPIYAML openAPIYAML, String schemaName) {
        return ResourceTestCaseOpenAPIParser.getJavaMethodSignatures(configYAML, openAPIYAML, schemaName);
    }

    public String getResourceTestCaseParameters(List<JavaMethodParameter> javaMethodParameters, OpenAPIYAML openAPIYAML, Operation operation, boolean annotation) {
        return ResourceTestCaseOpenAPIParser.getParameters(javaMethodParameters, openAPIYAML, operation, annotation);
    }

    public String getRESTMethodJavadoc(ConfigYAML configYAML, JavaMethodSignature javaMethodSignature, OpenAPIYAML openAPIYAML) {
        StringBundler sb = new StringBundler(10);
        sb.append("Invoke this method with the command line:\n*\n* curl -X '");
        sb.append(StringUtil.toUpperCase(OpenAPIParserUtil.getHTTPMethod(javaMethodSignature.getOperation())));
        sb.append("' 'http://localhost:8080/o");
        Application application = configYAML.getApplication();
        sb.append(application.getBaseURI());
        sb.append("/");
        Info info = openAPIYAML.getInfo();
        sb.append(info.getVersion());
        sb.append(javaMethodSignature.getPath());
        sb.append("' ");
        sb.append(this._getRESTBody(javaMethodSignature, openAPIYAML));
        sb.append(" -u 'test@liferay.com:test'");
        return sb.toString();
    }

    public Map<String, Schema> getSchemas(OpenAPIYAML openAPIYAML) {
        Components components = openAPIYAML.getComponents();
        if (components == null) {
            return new HashMap<String, Schema>();
        }
        return new TreeMap<String, Schema>(components.getSchemas());
    }

    public String getSchemaVarName(String schemaName) {
        return OpenAPIParserUtil.getSchemaVarName(schemaName);
    }

    public String getVersion(OpenAPIYAML openAPIYAML) {
        return OpenAPIParserUtil.getVersion(openAPIYAML);
    }

    public Set<String> getVulcanBatchImplementationCreateStrategies(List<JavaMethodSignature> javaMethodSignatures, Map<String, String> properties) {
        return ResourceOpenAPIParser.getVulcanBatchImplementationCreateStrategies(javaMethodSignatures, properties);
    }

    public Set<String> getVulcanBatchImplementationUpdateStrategies(List<JavaMethodSignature> javaMethodSignatures) {
        return ResourceOpenAPIParser.getVulcanBatchImplementationUpdateStrategies(javaMethodSignatures);
    }

    public boolean hasHTTPMethod(JavaMethodSignature javaMethodSignature, String ... httpMethods) {
        return OpenAPIParserUtil.hasHTTPMethod(javaMethodSignature, httpMethods);
    }

    public boolean hasJavaMethodSignature(List<JavaMethodSignature> javaMethodSignatures, String methodName) {
        for (JavaMethodSignature javaMethodSignature : javaMethodSignatures) {
            String javaMethodSignatureMethodName = javaMethodSignature.getMethodName();
            if (!javaMethodSignatureMethodName.equals(methodName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasParameter(JavaMethodSignature javaMethodSignature, String parameterName) {
        List<JavaMethodParameter> javaMethodParameters = javaMethodSignature.getJavaMethodParameters();
        for (JavaMethodParameter javaMethodParameter : javaMethodParameters) {
            if (!parameterName.equals(javaMethodParameter.getParameterName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasPath(List<JavaMethodSignature> javaMethodSignatures, String path) {
        for (JavaMethodSignature javaMethodSignature : javaMethodSignatures) {
            String javaMethodSignaturePath = javaMethodSignature.getPath();
            if (!javaMethodSignaturePath.equals(path)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPathParameter(JavaMethodSignature javaMethodSignature) {
        List<JavaMethodParameter> javaMethodParameters = javaMethodSignature.getJavaMethodParameters();
        Operation operation = javaMethodSignature.getOperation();
        for (JavaMethodParameter javaMethodParameter : javaMethodParameters) {
            if (!this.isPathParameter(javaMethodParameter, operation)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPostSchemaJavaMethodSignature(List<JavaMethodSignature> javaMethodSignatures, String parameterName, String schemaName) {
        JavaMethodSignature javaMethodSignature = this.getPostSchemaJavaMethodSignature(javaMethodSignatures, parameterName, schemaName);
        return javaMethodSignature != null;
    }

    public boolean hasQueryParameter(JavaMethodSignature javaMethodSignature) {
        List<JavaMethodParameter> javaMethodParameters = javaMethodSignature.getJavaMethodParameters();
        Operation operation = javaMethodSignature.getOperation();
        for (JavaMethodParameter javaMethodParameter : javaMethodParameters) {
            if (!this.isQueryParameter(javaMethodParameter, operation)) continue;
            return true;
        }
        return false;
    }

    public boolean hasReadVulcanBatchImplementation(List<JavaMethodSignature> javaMethodSignatures) {
        return ResourceOpenAPIParser.hasReadVulcanBatchImplementation(javaMethodSignatures);
    }

    public boolean hasRequestBodyMediaType(JavaMethodSignature javaMethodSignature, String mediaType) {
        Operation operation = javaMethodSignature.getOperation();
        if (operation.getRequestBody() == null) {
            return false;
        }
        RequestBody requestBody = operation.getRequestBody();
        if (requestBody.getContent() == null) {
            return false;
        }
        Map<String, Content> contents = requestBody.getContent();
        Set<String> mediaTypes = contents.keySet();
        return mediaTypes.contains(mediaType);
    }

    public boolean isCollection(JavaMethodSignature javaMethodSignaturePathItem, List<JavaMethodSignature> javaMethodSignatures, String schemaNames) {
        PathItem pathItem = javaMethodSignaturePathItem.getPathItem();
        Get getOperation = pathItem.getGet();
        if (getOperation != null) {
            return StringUtil.endsWith(getOperation.getOperationId(), "Page");
        }
        for (JavaMethodSignature javaMethodSignature : javaMethodSignatures) {
            if (!StringUtil.equals(javaMethodSignature.getMethodName(), "get" + schemaNames + "Page")) continue;
            return true;
        }
        return false;
    }

    public boolean isDTOSchemaProperty(OpenAPIYAML openAPIYAML, String propertyName, Schema schema) {
        return DTOOpenAPIParser.isSchemaProperty(openAPIYAML, propertyName, schema);
    }

    public boolean isParameter(JavaMethodParameter javaMethodParameter, Operation operation, String type) {
        String name = javaMethodParameter.getParameterName();
        for (Parameter parameter : operation.getParameters()) {
            if (!Objects.equals(parameter.getName(), name) || !Objects.equals(parameter.getIn(), type)) continue;
            return true;
        }
        return false;
    }

    public boolean isParameterNameSchemaRelated(String parameterName, String path, String schemaName) {
        String parameterNameSubpath = "/{" + parameterName + "}";
        if (StringUtil.endsWith(path, parameterNameSubpath)) {
            return true;
        }
        String prefixPath = path.substring(0, path.indexOf(parameterNameSubpath));
        return prefixPath.contains(TextFormatter.format(schemaName, 8)) || prefixPath.contains(TextFormatter.format(schemaName, 10));
    }

    public boolean isPathParameter(JavaMethodParameter javaMethodParameter, Operation operation) {
        return this.isParameter(javaMethodParameter, operation, "path");
    }

    public boolean isQueryParameter(JavaMethodParameter javaMethodParameter, Operation operation) {
        return this.isParameter(javaMethodParameter, operation, "query") || Objects.equals(javaMethodParameter.getParameterName(), "pagination") && Objects.equals(javaMethodParameter.getParameterType(), Pagination.class.getName()) || Objects.equals(javaMethodParameter.getParameterName(), "sorts") && Objects.equals(javaMethodParameter.getParameterType(), Sort[].class.getName());
    }

    public boolean isReturnTypeRelatedSchema(JavaMethodSignature javaMethodSignature, List<String> relatedSchemaNames) {
        String returnType = javaMethodSignature.getReturnType();
        String[] returnTypeParts = returnType.split("\\.");
        if (returnTypeParts.length > 0) {
            String string = returnTypeParts[returnTypeParts.length - 1];
            return relatedSchemaNames.contains(string);
        }
        return false;
    }

    public boolean isVersionCompatible(ConfigYAML configYAML, int version) {
        return configYAML.getCompatibilityVersion() >= version;
    }

    private static DateFormat _getDateFormat(String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setTimeZone(TimeZoneUtil.GMT);
        return dateFormat;
    }

    private FreeMarkerTool() {
    }

    private String _getGraphQLBody(JavaMethodSignature javaMethodSignature, List<JavaMethodSignature> javaMethodSignatures, OpenAPIYAML openAPIYAML) {
        StringBundler sb = new StringBundler("{\"query\": \"query {");
        sb.append(this.getGraphQLPropertyName(javaMethodSignature, javaMethodSignatures));
        TreeSet<String> javaMethodParameterNames = new TreeSet<String>();
        for (JavaMethodParameter javaMethodParameter : javaMethodSignature.getJavaMethodParameters()) {
            javaMethodParameterNames.add(javaMethodParameter.getParameterName());
        }
        if (!javaMethodParameterNames.isEmpty()) {
            sb.append("(");
            Iterator iterator = javaMethodParameterNames.iterator();
            while (iterator.hasNext()) {
                String javaMethodParameterName = (String)iterator.next();
                javaMethodParameterName = StringUtil.replace(javaMethodParameterName, "siteId", "siteKey");
                sb.append(javaMethodParameterName);
                sb.append(": ___");
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        sb.append("{");
        String returnType = javaMethodSignature.getReturnType();
        if (returnType.startsWith("java.util.Collection<")) {
            sb.append("items {__}, page, pageSize, totalCount");
        } else {
            String returnSchema;
            Map<String, Schema> schemas = this.getSchemas(openAPIYAML);
            if (schemas.containsKey(returnSchema = returnType.substring(returnType.lastIndexOf(".") + 1))) {
                Schema schema = schemas.get(returnSchema);
                Map<String, Schema> propertySchemas = schema.getPropertySchemas();
                Set<String> strings = propertySchemas.keySet();
                Iterator<String> iterator = strings.iterator();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    sb.append(key);
                    if (!iterator.hasNext()) continue;
                    sb.append(", ");
                }
            }
        }
        sb.append("}}\"}");
        return sb.toString();
    }

    private JavaMethodSignature _getGraphQLPathRelation(JavaMethodSignature parentJavaMethodSignature, List<JavaMethodSignature> javaMethodSignatures, String parameterName, Map<String, Schema> schemas) {
        for (JavaMethodSignature javaMethodSignature : javaMethodSignatures) {
            String schemaName;
            List<JavaMethodParameter> javaMethodParameters;
            if (parentJavaMethodSignature == javaMethodSignature || (javaMethodParameters = javaMethodSignature.getJavaMethodParameters()).size() != 1) continue;
            JavaMethodParameter javaMethodParameter = javaMethodParameters.get(0);
            String propertyName = StringUtil.upperCaseFirstLetter(javaMethodParameter.getParameterName());
            String returnType = javaMethodSignature.getReturnType();
            if ((!returnType.endsWith(schemaName = javaMethodSignature.getSchemaName()) || parameterName.equals("id") || !parameterName.equals(javaMethodParameter.getParameterName())) && !parameterName.equals("parent" + propertyName)) continue;
            JavaMethodSignature relationJavaMethodSignature = this._getJavaMethodSignature(parentJavaMethodSignature, schemaName);
            Schema schema = schemas.get(schemaName);
            Map<String, Schema> propertySchemas = schema.getPropertySchemas();
            if (propertySchemas.containsKey(this.getGraphQLRelationName(relationJavaMethodSignature, javaMethodSignatures))) {
                return null;
            }
            if (relationJavaMethodSignature.getParentSchemaName() != null && !returnType.contains("Collection<")) {
                Schema parentSchema = schemas.get(relationJavaMethodSignature.getParentSchemaName());
                Map<String, Schema> parentPropertySchemas = parentSchema.getPropertySchemas();
                String parentProperty = this._getParentProperty(relationJavaMethodSignature.getParentSchemaName(), javaMethodParameter, parentPropertySchemas.keySet());
                if (parentProperty == null) continue;
            }
            return relationJavaMethodSignature;
        }
        return null;
    }

    private JavaMethodSignature _getJavaMethodSignature(JavaMethodSignature javaMethodSignature, String parentSchemaName) {
        return new JavaMethodSignature(javaMethodSignature.getPath(), javaMethodSignature.getPathItem(), javaMethodSignature.getOperation(), javaMethodSignature.getRequestBodyMediaTypes(), javaMethodSignature.getSchemaName(), javaMethodSignature.getJavaMethodParameters(), javaMethodSignature.getMethodName(), javaMethodSignature.getReturnType(), parentSchemaName);
    }

    private String _getParentProperty(String schemaName, JavaMethodParameter javaMethodParameter, Set<String> properties) {
        String parameterName = StringUtil.toLowerCase(javaMethodParameter.getParameterName());
        schemaName = StringUtil.toLowerCase(schemaName);
        String shortParameterName = StringUtil.removeSubstring(parameterName, schemaName);
        shortParameterName = StringUtil.removeSubstring(shortParameterName, "parent");
        for (String propertyKey : properties) {
            if (!StringUtil.equalsIgnoreCase(parameterName, propertyKey) && !StringUtil.equalsIgnoreCase(shortParameterName, propertyKey)) continue;
            return StringUtil.upperCaseFirstLetter(propertyKey);
        }
        return null;
    }

    private String _getRESTBody(JavaMethodSignature javaMethodSignature, OpenAPIYAML openAPIYAML) {
        StringBundler sb = new StringBundler();
        TreeSet<String> properties = new TreeSet<String>();
        Map<String, Schema> schemas = this.getSchemas(openAPIYAML);
        List<JavaMethodParameter> javaMethodParameters = javaMethodSignature.getJavaMethodParameters();
        for (JavaMethodParameter javaMethodParameter : javaMethodParameters) {
            Schema schema;
            Map<String, Schema> propertySchemas;
            String parameterType = javaMethodParameter.getParameterType();
            String schemaName = parameterType.substring(parameterType.lastIndexOf(".") + 1);
            if (!schemas.containsKey(schemaName) || (propertySchemas = (schema = schemas.get(schemaName)).getPropertySchemas()) == null) continue;
            for (Map.Entry<String, Schema> entry : propertySchemas.entrySet()) {
                Schema propertySchema = entry.getValue();
                if (propertySchema.isReadOnly()) continue;
                properties.add(entry.getKey());
            }
        }
        if (!properties.isEmpty()) {
            sb.append("-d $'{");
            Iterator iterator = properties.iterator();
            while (iterator.hasNext()) {
                sb.append("\"");
                sb.append((String)iterator.next());
                sb.append("\": ___");
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("}' --header 'Content-Type: application/json'");
        }
        return sb.toString();
    }

    private List<JavaMethodSignature> _getSortedJavaMethodSignatures(ConfigYAML configYAML, String graphQLType, OpenAPIYAML openAPIYAML) throws Exception {
        List<JavaMethodSignature> javaMethodSignatures = this.getGraphQLJavaMethodSignatures(configYAML, graphQLType, openAPIYAML);
        javaMethodSignatures.sort(Comparator.comparingInt(javaMethodSignature -> StringUtil.count(javaMethodSignature.getPath(), "/")));
        return javaMethodSignatures;
    }

    private boolean _isGraphQLPropertyRelation(JavaMethodSignature javaMethodSignature, String parameterName, String propertyName, String schemaName) {
        String returnType = StringUtil.toLowerCase(javaMethodSignature.getReturnType());
        String parameterSchemaName = StringUtil.removeSubstring(parameterName, "Id");
        return !StringUtil.equalsIgnoreCase(schemaName, parameterSchemaName) && StringUtil.equals(propertyName, parameterName) && returnType.endsWith(StringUtil.toLowerCase(parameterSchemaName));
    }

    private String _replaceGraphQLParameter(String parameterName, Map<String, String> substitutions) {
        for (Map.Entry<String, String> entry : substitutions.entrySet()) {
            if (!parameterName.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return parameterName;
    }
}

