/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import java.util.Locale;

public class LocaleThreadLocal {
    private static final ThreadLocal<Locale> _defaultLocale = new CentralizedThreadLocal<Locale>(LocaleThreadLocal.class + "._defaultLocale");
    private static final ThreadLocal<Locale> _siteDefaultLocale = new CentralizedThreadLocal<Locale>(LocaleThreadLocal.class + "._siteDefaultLocale");
    private static final ThreadLocal<Locale> _themeDisplayLocale = new CentralizedThreadLocal<Locale>(LocaleThreadLocal.class + "._themeDisplayLocale");

    public static Locale getDefaultLocale() {
        User defaultUser;
        if (_defaultLocale.get() == null && CompanyThreadLocal.getCompanyId() != 0L && (defaultUser = UserLocalServiceUtil.fetchDefaultUser((long)CompanyThreadLocal.getCompanyId())) != null) {
            _defaultLocale.set(defaultUser.getLocale());
        }
        return _defaultLocale.get();
    }

    public static Locale getSiteDefaultLocale() {
        return _siteDefaultLocale.get();
    }

    public static Locale getThemeDisplayLocale() {
        return _themeDisplayLocale.get();
    }

    public static void setDefaultLocale(Locale locale) {
        _defaultLocale.set(locale);
    }

    public static void setSiteDefaultLocale(Locale locale) {
        _siteDefaultLocale.set(locale);
    }

    public static void setThemeDisplayLocale(Locale locale) {
        _themeDisplayLocale.set(locale);
    }
}

