/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.extension;

import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.vulcan.extension.validation.DefaultPropertyValidator;
import com.liferay.portal.vulcan.extension.validation.PropertyValidator;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertyDefinition {
    private static final Map<PropertyType, Set<Class<?>>> _propertyTypeClasses = HashMapBuilder.put(PropertyType.BIG_DECIMAL, SetUtil.fromArray(BigDecimal.class, Double.class, Float.class, Integer.class, Long.class)).put(PropertyType.BOOLEAN, SetUtil.fromArray(Boolean.class)).put(PropertyType.DECIMAL, SetUtil.fromArray(Float.class, Integer.class, Long.class)).put(PropertyType.DOUBLE, SetUtil.fromArray(Double.class, Float.class)).put(PropertyType.INTEGER, SetUtil.fromArray(Integer.class)).put(PropertyType.LONG, SetUtil.fromArray(Integer.class, Long.class)).put(PropertyType.TEXT, SetUtil.fromArray(String.class)).build();
    private String _propertyClassDescription;
    private final Set<Class<?>> _propertyClasses;
    private String _propertyClassName;
    private List<PropertyDefinition> _propertyDefinitions;
    private final String _propertyDescription;
    private final String _propertyName;
    private final PropertyType _propertyType;
    private final PropertyValidator _propertyValidator;
    private final boolean _required;

    public PropertyDefinition(Set<Class<?>> propertyClasses, String propertyClassDescription, String propertyClassName, String propertyDescription, String propertyName, PropertyType propertyType, PropertyValidator propertyValidator, boolean required) {
        this._propertyClasses = propertyClasses;
        this._propertyClassDescription = propertyClassDescription;
        this._propertyClassName = propertyClassName;
        this._propertyDescription = propertyDescription;
        this._propertyName = propertyName;
        this._propertyType = propertyType;
        this._propertyValidator = propertyValidator;
        this._required = required;
    }

    public PropertyDefinition(String propertyDescription, String propertyName, PropertyType propertyType, boolean required) {
        this._propertyDescription = propertyDescription;
        this._propertyName = propertyName;
        this._propertyType = propertyType;
        this._required = required;
        this._propertyClasses = _propertyTypeClasses.get((Object)propertyType);
        this._propertyValidator = new DefaultPropertyValidator();
    }

    public PropertyDefinition(String propertyDescription, String propertyName, PropertyType propertyType, PropertyValidator propertyValidator, boolean required) {
        this._propertyDescription = propertyDescription;
        this._propertyName = propertyName;
        this._propertyType = propertyType;
        this._propertyValidator = propertyValidator;
        this._required = required;
        this._propertyClasses = _propertyTypeClasses.get((Object)propertyType);
    }

    public String getPropertyClassDescription() {
        return this._propertyClassDescription;
    }

    public Set<Class<?>> getPropertyClasses() {
        return this._propertyClasses;
    }

    public String getPropertyClassName() {
        return this._propertyClassName;
    }

    public List<PropertyDefinition> getPropertyDefinitions() {
        return this._propertyDefinitions;
    }

    public String getPropertyDescription() {
        return this._propertyDescription;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public PropertyType getPropertyType() {
        return this._propertyType;
    }

    public PropertyValidator getPropertyValidator() {
        return this._propertyValidator;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setPropertyDefinitions(List<PropertyDefinition> propertyDefinitions) {
        this._propertyDefinitions = propertyDefinitions;
    }

    public static enum PropertyType {
        BIG_DECIMAL,
        BOOLEAN,
        DATE_TIME,
        DECIMAL,
        DOUBLE,
        INTEGER,
        LONG,
        MULTIPLE_ELEMENT,
        SINGLE_ELEMENT,
        TEXT;

    }
}

