/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.io.unsync;

import com.liferay.petra.io.unsync.BoundaryCheckerUtil;
import java.io.IOException;
import java.io.Reader;

public class UnsyncStringReader
extends Reader {
    private int _index;
    private int _markIndex;
    private String _string;
    private final int _stringLength;

    public UnsyncStringReader(String string) {
        this._string = string;
        this._stringLength = string.length();
    }

    @Override
    public void close() {
        this._string = null;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (this._string == null) {
            throw new IOException("String is null");
        }
        this._markIndex = this._index;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this._string == null) {
            throw new IOException("String is null");
        }
        if (this._index >= this._stringLength) {
            return -1;
        }
        return this._string.charAt(this._index++);
    }

    @Override
    public int read(char[] chars) throws IOException {
        return this.read(chars, 0, chars.length);
    }

    @Override
    public int read(char[] chars, int offset, int length) throws IOException {
        if (this._string == null) {
            throw new IOException("String is null");
        }
        BoundaryCheckerUtil.check((int)chars.length, (int)offset, (int)length);
        if (length == 0) {
            return 0;
        }
        if (this._index >= this._stringLength) {
            return -1;
        }
        int read = length;
        if (this._index + read > this._stringLength) {
            read = this._stringLength - this._index;
        }
        this._string.getChars(this._index, this._index + read, chars, offset);
        this._index += read;
        return read;
    }

    @Override
    public boolean ready() throws IOException {
        if (this._string == null) {
            throw new IOException("String is null");
        }
        return true;
    }

    @Override
    public void reset() throws IOException {
        if (this._string == null) {
            throw new IOException("String is null");
        }
        this._index = this._markIndex;
    }

    @Override
    public long skip(long skip) throws IOException {
        if (skip < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        if (this._string == null) {
            throw new IOException("String is null");
        }
        if (this._index >= this._stringLength) {
            return 0L;
        }
        if (skip + (long)this._index > (long)this._stringLength) {
            skip = this._stringLength - this._index;
        }
        this._index = (int)((long)this._index + skip);
        return skip;
    }
}

