/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.util;

import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Locale;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;

public class ContentLanguageUtil {
    public static void addContentLanguageHeader(String[] availableLocaleIds, String defaultLocaleId, HttpServletResponse httpServletResponse, Locale requestedLocale) {
        if (httpServletResponse == null) {
            return;
        }
        Locale contentLocale = Stream.of(availableLocaleIds).map(LocaleUtil::fromLanguageId).filter(locale -> LocaleUtil.equals(locale, requestedLocale)).findFirst().orElse(LocaleUtil.fromLanguageId(defaultLocaleId));
        httpServletResponse.addHeader("Content-Language", LocaleUtil.toW3cLanguageId(contentLocale));
    }
}

