/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.rest.builder;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.StringUtil_IW;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.Validator_IW;
import com.liferay.portal.tools.rest.builder.RESTBuilderArgs;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.FreeMarkerTool;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.JavaMethodSignature;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser.util.OpenAPIParserUtil;
import com.liferay.portal.tools.rest.builder.internal.freemarker.util.FreeMarkerUtil;
import com.liferay.portal.tools.rest.builder.internal.freemarker.util.OpenAPIUtil;
import com.liferay.portal.tools.rest.builder.internal.util.FileUtil;
import com.liferay.portal.tools.rest.builder.internal.yaml.YAMLUtil;
import com.liferay.portal.tools.rest.builder.internal.yaml.config.Application;
import com.liferay.portal.tools.rest.builder.internal.yaml.config.ConfigYAML;
import com.liferay.portal.tools.rest.builder.internal.yaml.exception.OpenAPIValidatorException;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Components;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Content;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Info;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Items;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.License;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.OpenAPIYAML;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Operation;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Parameter;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.PathItem;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.RequestBody;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Response;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.ResponseCode;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Schema;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;

public class RESTBuilder {
    private static final int _DESCRIPTION_MAX_LINE_LENGTH = 120;
    private static final Log _log = LogFactoryUtil.getLog(RESTBuilder.class);
    private final File _configDir;
    private final ConfigYAML _configYAML;
    private final File _copyrightFile;
    private final List<File> _files = new ArrayList<File>();

    public static void main(String[] args) throws Exception {
        RESTBuilderArgs restBuilderArgs = new RESTBuilderArgs();
        JCommander jCommander = new JCommander(restBuilderArgs);
        try {
            ProtectionDomain protectionDomain = RESTBuilder.class.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URL url = codeSource.getLocation();
            File jarFile = new File(url.toURI());
            if (jarFile.isFile()) {
                jCommander.setProgramName("java -jar " + jarFile.getName());
            } else {
                jCommander.setProgramName(RESTBuilder.class.getName());
            }
            jCommander.parse(args);
            if (restBuilderArgs.isHelp()) {
                RESTBuilder._printHelp(jCommander);
            } else {
                RESTBuilder restBuilder = new RESTBuilder(restBuilderArgs);
                restBuilder.build();
            }
        }
        catch (ParameterException parameterException) {
            RESTBuilder._printHelp(jCommander);
            throw new RuntimeException(parameterException.getMessage(), parameterException);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error generating REST API\n" + exception.getMessage(), exception);
        }
    }

    public RESTBuilder(File copyrightFile, File configDir, Boolean forceClientVersionDescription, Boolean forcePredictableOperationId) throws Exception {
        this._copyrightFile = copyrightFile;
        this._configDir = configDir;
        File configFile = new File(this._configDir, "rest-config.yaml");
        try (FileInputStream inputStream = new FileInputStream(configFile);){
            this._configYAML = YAMLUtil.loadConfigYAML(StringUtil.read(inputStream));
            if (forceClientVersionDescription != null) {
                this._configYAML.setForceClientVersionDescription(forceClientVersionDescription);
            }
            if (forcePredictableOperationId != null) {
                this._configYAML.setForcePredictableOperationId(forcePredictableOperationId);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error in file \"rest-config.yaml\": " + exception.getMessage());
        }
    }

    public RESTBuilder(RESTBuilderArgs restBuilderArgs) throws Exception {
        this(restBuilderArgs.getCopyrightFile(), restBuilderArgs.getRESTConfigDir(), restBuilderArgs.isForceClientVersionDescription(), restBuilderArgs.isForcePredictableOperationId());
    }

    public void build() throws Exception {
        File[] files;
        FreeMarkerTool freeMarkerTool = FreeMarkerTool.getInstance();
        HashMap<String, Object> context = HashMapBuilder.put("configYAML", this._configYAML).put("freeMarkerTool", (ConfigYAML)((Object)freeMarkerTool)).put("stringUtil", (ConfigYAML)((Object)StringUtil_IW.getInstance())).put("validator", (ConfigYAML)((Object)Validator_IW.getInstance())).build();
        if (this._configYAML.isGenerateREST() && this._configYAML.getApplication() != null) {
            this._createApplicationFile(context);
        }
        if (Validator.isNotNull(this._configYAML.getClientDir())) {
            this._createClientAggregationFile(context);
            this._createClientBaseJSONParserFile(context);
            this._createClientFacetFile(context);
            this._createClientHttpInvokerFile(context);
            this._createClientPageFile(context);
            this._createClientPaginationFile(context);
            this._createClientPermissionFile(context);
            this._createClientProblemFile(context);
            this._createClientUnsafeSupplierFile(context);
        }
        ArrayList<String> validationErrorMessages = new ArrayList<String>();
        for (File file : files = FileUtil.getFiles(this._configDir, "rest-openapi", ".yaml")) {
            try {
                this._checkOpenAPIYAMLFile(freeMarkerTool, file);
            }
            catch (Exception exception) {
                _log.error(exception);
                throw new RuntimeException(StringBundler.concat("Error in file \"", file.getName(), "\": ", exception.getMessage()));
            }
            String yamlString = FileUtil.read(file);
            if (!this._validateOpenAPIYAML(file.getName(), yamlString, validationErrorMessages)) continue;
            OpenAPIYAML openAPIYAML = this._loadOpenAPIYAML(yamlString);
            Map<String, Schema> allSchemas = OpenAPIUtil.getAllSchemas(openAPIYAML);
            Map<String, Schema> allExternalSchemas = OpenAPIUtil.getAllExternalSchemas(openAPIYAML);
            context.put("allExternalSchemas", allExternalSchemas);
            context.put("allSchemas", allSchemas);
            String escapedVersion = OpenAPIUtil.escapeVersion(openAPIYAML);
            context.put("escapedVersion", escapedVersion);
            Map<String, Schema> globalEnumSchemas = OpenAPIUtil.getGlobalEnumSchemas(openAPIYAML);
            context.put("globalEnumSchemas", globalEnumSchemas);
            Map<String, String> javaDataTypeMap = OpenAPIParserUtil.getJavaDataTypeMap(this._configYAML, openAPIYAML);
            context.put("javaDataTypeMap", javaDataTypeMap);
            context.put("openAPIYAML", openAPIYAML);
            if (this._configYAML.isGenerateGraphQL() && this._configYAML.getApplication() != null) {
                this._createGraphQLMutationFile(context, escapedVersion);
                this._createGraphQLQueryFile(context, escapedVersion);
                this._createGraphQLServletDataFile(context, escapedVersion);
            }
            context.put("schemaName", "openapi");
            if (this._configYAML.isGenerateOpenAPI() && this._configYAML.getResourceApplicationSelect() == null) {
                this._createOpenAPIResourceFile(context, escapedVersion);
                this._createPropertiesFile(context, escapedVersion, "openapi");
            }
            Map<String, Schema> schemas = freeMarkerTool.getSchemas(openAPIYAML);
            this._createExternalSchemaFiles(allExternalSchemas, context, escapedVersion);
            HashSet<Map.Entry<String, Schema>> set = new HashSet<Map.Entry<String, Schema>>(allSchemas.entrySet());
            for (Map.Entry entry : set) {
                Schema schema = (Schema)entry.getValue();
                String schemaName = (String)entry.getKey();
                this._putSchema(context, escapedVersion, javaDataTypeMap, schema, schemaName, new HashSet<String>());
                this._createDTOFile(context, escapedVersion, schemaName);
                if (!Validator.isNotNull(this._configYAML.getClientDir())) continue;
                this._createClientDTOFile(context, escapedVersion, schemaName);
                this._createClientSerDesFile(context, escapedVersion, schemaName);
            }
            for (Map.Entry entry : globalEnumSchemas.entrySet()) {
                this._putSchema(context, escapedVersion, javaDataTypeMap, (Schema)entry.getValue(), (String)entry.getKey(), new HashSet<String>());
                this._createEnumFile(context, escapedVersion, (String)entry.getKey());
                if (!Validator.isNotNull(this._configYAML.getClientDir())) continue;
                this._createClientEnumFile(context, escapedVersion, (String)entry.getKey());
            }
            schemas = freeMarkerTool.getAllSchemas(allExternalSchemas, openAPIYAML, schemas);
            for (Map.Entry entry : schemas.entrySet()) {
                String schemaName = (String)entry.getKey();
                List<JavaMethodSignature> javaMethodSignatures = freeMarkerTool.getResourceJavaMethodSignatures(this._configYAML, openAPIYAML, schemaName);
                if (javaMethodSignatures.isEmpty()) continue;
                Schema schema = (Schema)entry.getValue();
                this._putSchema(context, escapedVersion, javaDataTypeMap, schema, schemaName, this._getRelatedSchemaNames(allSchemas, javaMethodSignatures));
                this._createBaseResourceImplFile(context, escapedVersion, schemaName);
                this._createLiberalPermissionCheckerFile(context);
                this._createPropertiesFile(context, escapedVersion, String.valueOf(context.get("schemaPath")));
                if (this._configYAML.getApplication() != null) {
                    this._createResourceFactoryImplFile(context, escapedVersion, schemaName);
                }
                this._createResourceFile(context, escapedVersion, schemaName);
                this._createResourceImplFile(context, escapedVersion, schemaName);
                if (Validator.isNotNull(this._configYAML.getClientDir())) {
                    this._createClientResourceFile(context, escapedVersion, schemaName);
                }
                if (!Validator.isNotNull(this._configYAML.getTestDir())) continue;
                this._createBaseResourceTestCaseFile(context, escapedVersion, schemaName);
                this._createResourceTestFile(context, escapedVersion, schemaName);
            }
        }
        if (!validationErrorMessages.isEmpty()) {
            String validationErrorMessagesString = StringUtil.merge(validationErrorMessages, "\n");
            throw new RuntimeException("OpenAPI validation errors:\n" + validationErrorMessagesString);
        }
        FileUtil.deleteFiles(this._configYAML.getApiDir(), this._files);
        if (Validator.isNotNull(this._configYAML.getClientDir())) {
            FileUtil.deleteFiles(this._configYAML.getClientDir(), this._files);
        }
        FileUtil.deleteFiles(this._configYAML.getImplDir(), this._files);
        FileUtil.deleteFiles(this._configYAML.getImplDir() + "/../resources/OSGI-INF/", this._files);
        if (Validator.isNotNull(this._configYAML.getTestDir())) {
            FileUtil.deleteFiles(this._configYAML.getTestDir(), this._files);
        }
    }

    private static void _printHelp(JCommander jCommander) {
        jCommander.usage();
    }

    private String _addClientVersionDescription(String yamlString) {
        String clientMavenGroupId = this._getClientMavenGroupId(this._configYAML.getApiPackagePath());
        Optional<String> clientVersionOptional = this._getClientVersionOptional();
        int licenseIndex = yamlString.indexOf("    license:");
        if (clientMavenGroupId == null || !clientVersionOptional.isPresent() || licenseIndex == -1) {
            return yamlString;
        }
        OpenAPIYAML openAPIYAML = this._loadOpenAPIYAML(yamlString);
        Info info = openAPIYAML.getInfo();
        String description = info.getDescription();
        if (description == null) {
            return yamlString;
        }
        String clientVersion = clientVersionOptional.get();
        String clientMessage = StringBundler.concat("A Java client JAR is available for use with the group ID '", clientMavenGroupId, "', artifact ID '", this._configYAML.getApiPackagePath(), ".client', and version '");
        if (description.contains(clientMessage)) {
            description = StringUtil.removeSubstring(description, description.substring(description.indexOf(clientMessage)));
        }
        description = !description.isEmpty() && !description.endsWith(". ") ? StringBundler.concat(description, ". ", clientMessage, clientVersion, "'.") : StringBundler.concat(description, clientMessage, clientVersion, "'.");
        String formattedDescription = this._formatDescrition("        ", "\"" + description + "\"");
        String descriptionBlock = "    description:\n" + formattedDescription + "\n";
        return StringUtil.replace(yamlString, yamlString.substring(yamlString.indexOf("    description:", yamlString.indexOf("info:")), licenseIndex), descriptionBlock);
    }

    private void _checkOpenAPIYAMLFile(FreeMarkerTool freeMarkerTool, File file) throws Exception {
        String yamlString = this._fixOpenAPILicense(FileUtil.read(file));
        yamlString = this._fixOpenAPIPaths(yamlString);
        yamlString = this._fixOpenAPIPathParameters(yamlString);
        if (this._configYAML.isForcePredictableSchemaPropertyName()) {
            yamlString = this._fixOpenAPISchemaPropertyNames(freeMarkerTool, yamlString);
        }
        if (this._configYAML.isForcePredictableOperationId()) {
            yamlString = this._fixOpenAPIOperationIds(freeMarkerTool, yamlString);
        }
        if (this._configYAML.isForcePredictableContentApplicationXML()) {
            yamlString = this._fixOpenAPIContentApplicationXML(yamlString);
        }
        if (this._configYAML.isForceClientVersionDescription()) {
            yamlString = this._addClientVersionDescription(yamlString);
        }
        if (this._configYAML.isWarningsEnabled()) {
            this._validate(yamlString);
        }
        FileUtil.write(file, yamlString);
    }

    private void _createApplicationFile(Map<String, Object> context) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append(this._configYAML.getImplDir());
        sb.append("/");
        sb.append(StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'));
        sb.append("/internal/jaxrs/application/");
        Application application = this._configYAML.getApplication();
        sb.append(application.getClassName());
        sb.append(".java");
        File file = new File(sb.toString());
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "application", context));
    }

    private void _createBaseResourceImplFile(Map<String, Object> context, String escapedVersion, String schemaName) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getImplDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/internal/resource/", escapedVersion, "/Base", schemaName, "ResourceImpl.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "base_resource_impl", context));
    }

    private void _createBaseResourceTestCaseFile(Map<String, Object> context, String escapedVersion, String schemaName) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getTestDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/resource/", escapedVersion, "/test/Base", schemaName, "ResourceTestCase.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "base_resource_test_case", context));
    }

    private void _createClientAggregationFile(Map<String, Object> context) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getClientDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/client/aggregation/Aggregation.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "client_aggregation", context));
    }

    private void _createClientBaseJSONParserFile(Map<String, Object> context) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getClientDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/client/json/BaseJSONParser.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "client_base_json_parser", context));
    }

    private void _createClientDTOFile(Map<String, Object> context, String escapedVersion, String schemaName) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getClientDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/client/dto/", escapedVersion, "/", schemaName, ".java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "client_dto", context));
    }

    private void _createClientEnumFile(Map<String, Object> context, String escapedVersion, String schemaName) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getClientDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/client/constant/", escapedVersion, "/", schemaName, ".java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "client_enum", context));
    }

    private void _createClientFacetFile(Map<String, Object> context) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getClientDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/client/aggregation/Facet.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "client_facet", context));
    }

    private void _createClientHttpInvokerFile(Map<String, Object> context) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getClientDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/client/http/HttpInvoker.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "client_http_invoker", context));
    }

    private void _createClientPageFile(Map<String, Object> context) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getClientDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/client/pagination/Page.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "client_page", context));
    }

    private void _createClientPaginationFile(Map<String, Object> context) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getClientDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/client/pagination/Pagination.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "client_pagination", context));
    }

    private void _createClientPermissionFile(Map<String, Object> context) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getClientDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/client/permission/Permission.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "client_permission", context));
    }

    private void _createClientProblemFile(Map<String, Object> context) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getClientDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/client/problem/Problem.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "client_problem", context));
    }

    private void _createClientResourceFile(Map<String, Object> context, String escapedVersion, String schemaName) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getClientDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/client/resource/", escapedVersion, "/", schemaName, "Resource.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "client_resource", context));
    }

    private void _createClientSerDesFile(Map<String, Object> context, String escapedVersion, String schemaName) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getClientDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/client/serdes/", escapedVersion, "/", schemaName, "SerDes.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "client_serdes", context));
    }

    private void _createClientUnsafeSupplierFile(Map<String, Object> context) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getClientDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/client/function/UnsafeSupplier.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "client_unsafe_supplier", context));
    }

    private void _createDTOFile(Map<String, Object> context, String escapedVersion, String schemaName) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getApiDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/dto/", escapedVersion, "/", schemaName, ".java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "dto", context));
    }

    private void _createEnumFile(Map<String, Object> context, String escapedVersion, String schemaName) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getApiDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/constant/", escapedVersion, "/", schemaName, ".java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "enum", context));
    }

    private void _createExternalSchemaFiles(Map<String, Schema> allExternalSchemas, Map<String, Object> context, String escapedVersion) throws Exception {
        for (Map.Entry<String, Schema> entry : allExternalSchemas.entrySet()) {
            String schemaName = entry.getKey();
            this._putSchema(context, escapedVersion, Collections.singletonMap(schemaName, schemaName), entry.getValue(), schemaName, new HashSet<String>());
            if (!Validator.isNotNull(this._configYAML.getClientDir())) continue;
            this._createClientDTOFile(context, escapedVersion, schemaName);
            this._createClientSerDesFile(context, escapedVersion, schemaName);
        }
    }

    private void _createGraphQLMutationFile(Map<String, Object> context, String escapedVersion) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getImplDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/internal/graphql/mutation/", escapedVersion, "/Mutation.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "graphql_mutation", context));
    }

    private void _createGraphQLQueryFile(Map<String, Object> context, String escapedVersion) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getImplDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/internal/graphql/query/", escapedVersion, "/Query.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "graphql_query", context));
    }

    private void _createGraphQLServletDataFile(Map<String, Object> context, String escapedVersion) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getImplDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/internal/graphql/servlet/", escapedVersion, "/ServletDataImpl.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "graphql_servlet_data", context));
    }

    private void _createLiberalPermissionCheckerFile(Map<String, Object> context) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getImplDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/internal/security/permission/LiberalPermissionChecker.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "liberal_permission_checker", context));
    }

    private void _createOpenAPIResourceFile(Map<String, Object> context, String escapedVersion) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getImplDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/internal/resource/", escapedVersion, "/OpenAPIResourceImpl.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "openapi_resource_impl", context));
    }

    private void _createPropertiesFile(Map<String, Object> context, String escapedVersion, String schemaPath) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getImplDir(), "/../resources/OSGI-INF/liferay/rest/", escapedVersion, "/", StringUtil.toLowerCase(schemaPath), ".properties"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(null, "properties", context));
    }

    private void _createResourceFactoryImplFile(Map<String, Object> context, String escapedVersion, String schemaName) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getImplDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/internal/resource/", escapedVersion, "/factory/", schemaName, "ResourceFactoryImpl.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "resource_factory_impl", context));
    }

    private void _createResourceFile(Map<String, Object> context, String escapedVersion, String schemaName) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getApiDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/resource/", escapedVersion, "/", schemaName, "Resource.java"));
        this._files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "resource", context));
    }

    private void _createResourceImplFile(Map<String, Object> context, String escapedVersion, String schemaName) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getImplDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/internal/resource/", escapedVersion, "/", schemaName, "ResourceImpl.java"));
        this._files.add(file);
        if (file.exists()) {
            return;
        }
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "resource_impl", context));
    }

    private void _createResourceTestFile(Map<String, Object> context, String escapedVersion, String schemaName) throws Exception {
        File file = new File(StringBundler.concat(this._configYAML.getTestDir(), "/", StringUtil.replace(this._configYAML.getApiPackagePath(), '.', '/'), "/resource/", escapedVersion, "/test/", schemaName, "ResourceTest.java"));
        this._files.add(file);
        if (file.exists()) {
            return;
        }
        FileUtil.write(file, FreeMarkerUtil.processTemplate(this._copyrightFile, "resource_test", context));
    }

    private String _fixOpenAPIContentApplicationXML(Map<String, Content> contents, int index, String s) {
        if (contents == null) {
            return s;
        }
        Set<String> mediaTypes = contents.keySet();
        if (!mediaTypes.contains("application/json") || mediaTypes.contains("application/xml")) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int startIndex = s.lastIndexOf("\n", s.indexOf("application/json", index)) + 1;
        int endIndex = this._getLineEndIndex(s, startIndex);
        String line = s.substring(startIndex, endIndex);
        String leadingWhitespace = line.replaceAll("^(\\s+).+", "$1");
        while (line.startsWith(leadingWhitespace)) {
            sb.append(line);
            sb.append("\n");
            startIndex = endIndex + 1;
            endIndex = this._getLineEndIndex(s, startIndex);
            line = s.substring(Math.min(startIndex, endIndex), endIndex);
        }
        sb.setLength(sb.length() - 1);
        String oldSub = sb.toString();
        String replacement = "\n";
        replacement = replacement + StringUtil.replace(oldSub, "application/json", "application/xml");
        return StringUtil.replaceFirst(s, oldSub, oldSub + replacement, index);
    }

    private String _fixOpenAPIContentApplicationXML(String yamlString) {
        OpenAPIYAML openAPIYAML = this._loadOpenAPIYAML(yamlString);
        Map<String, PathItem> pathItems = openAPIYAML.getPathItems();
        if (pathItems == null) {
            return yamlString;
        }
        for (Map.Entry<String, PathItem> entry1 : pathItems.entrySet()) {
            String path = entry1.getKey();
            int x = yamlString.indexOf(StringUtil.quote(path, '\"') + ":");
            if (x == -1) {
                x = yamlString.indexOf(path + ":");
            }
            for (Operation operation : OpenAPIParserUtil.getOperations(entry1.getValue())) {
                RequestBody requestBody = operation.getRequestBody();
                String httpMethod = OpenAPIParserUtil.getHTTPMethod(operation);
                int y = yamlString.indexOf(httpMethod + ":", x);
                if (requestBody != null) {
                    Map<String, Content> contents = requestBody.getContent();
                    int index = yamlString.indexOf("requestBody:", y);
                    yamlString = this._fixOpenAPIContentApplicationXML(contents, index, yamlString);
                }
                Map<ResponseCode, Response> responses = operation.getResponses();
                for (Map.Entry<ResponseCode, Response> entry2 : responses.entrySet()) {
                    Response response = entry2.getValue();
                    if (response == null) continue;
                    Map<String, Content> contents = response.getContent();
                    int index = yamlString.indexOf(entry2.getKey() + ":", y);
                    yamlString = this._fixOpenAPIContentApplicationXML(contents, index, yamlString);
                }
            }
        }
        return yamlString;
    }

    private String _fixOpenAPILicense(String yamlString) {
        OpenAPIYAML openAPIYAML = this._loadOpenAPIYAML(yamlString);
        String licenseName = this._configYAML.getLicenseName();
        String licenseURL = this._configYAML.getLicenseURL();
        StringBundler licenseSB = new StringBundler(6);
        licenseSB.append("        name: \"");
        licenseSB.append(licenseName);
        licenseSB.append("\"\n");
        licenseSB.append("        url: \"");
        licenseSB.append(licenseURL);
        licenseSB.append("\"");
        Info info = openAPIYAML.getInfo();
        if (info == null) {
            return StringBundler.concat("info:\n", licenseSB.toString(), Character.valueOf('\n'), yamlString);
        }
        License license = info.getLicense();
        if (license != null && licenseName.equals(license.getName()) && licenseURL.equals(license.getUrl())) {
            return yamlString;
        }
        int x = yamlString.indexOf("\ninfo:");
        int y = yamlString.indexOf(10, x + 1);
        String line = yamlString.substring(y + 1, yamlString.indexOf("\n", y + 1));
        String leadingWhiteSpace = line.replaceAll("^(\\s+).+", "$1");
        TreeMap<String, String> fieldMap = new TreeMap<String, String>();
        String fieldName = "";
        String fieldValue = "";
        while (line.matches("^" + leadingWhiteSpace + ".*")) {
            if (line.matches("^" + leadingWhiteSpace + "\\w.*")) {
                if (Validator.isNotNull(fieldName)) {
                    fieldMap.put(fieldName, fieldValue);
                    fieldValue = "";
                }
                fieldName = line.replaceAll("^\\s+(\\w+):.*", "$1");
                fieldValue = line.replaceAll("^\\s+\\w+:\\s*(.*)\\s*", "$1");
            } else {
                fieldValue = Validator.isNull(fieldValue) ? line : fieldValue + '\n' + line;
            }
            if (yamlString.indexOf(10, y + 1) == -1) {
                y = yamlString.length();
                break;
            }
            line = yamlString.substring(y + 1, yamlString.indexOf(10, y + 1));
            y = yamlString.indexOf(10, y + 1);
        }
        if (Validator.isNull(fieldName)) {
            return yamlString;
        }
        fieldMap.put(fieldName, fieldValue);
        fieldMap.put("license", licenseSB.toString());
        StringBundler sb = new StringBundler();
        sb.append(yamlString.substring(0, yamlString.indexOf(10, x + 1) + 1));
        for (Map.Entry entry : fieldMap.entrySet()) {
            sb.append(leadingWhiteSpace);
            sb.append((String)entry.getKey());
            String value = (String)entry.getValue();
            if (value.matches("(?s)^\\s*\\w+:.*")) {
                sb.append(":\n");
            } else {
                sb.append(": ");
            }
            sb.append(value);
            sb.append('\n');
        }
        sb.append(yamlString.substring(yamlString.lastIndexOf(10, y - 1) + 1));
        return sb.toString();
    }

    private String _fixOpenAPIOperationIds(FreeMarkerTool freeMarkerTool, String yamlString) throws Exception {
        OpenAPIYAML openAPIYAML = this._loadOpenAPIYAML(yamlString);
        yamlString = yamlString.replaceAll("\n\\s+operationId:.+", "");
        Map<String, Schema> allExternalSchemas = OpenAPIUtil.getAllExternalSchemas(openAPIYAML);
        Map<String, Schema> schemas = freeMarkerTool.getSchemas(openAPIYAML);
        MapUtil.merge(allExternalSchemas, schemas);
        for (String schemaName : schemas.keySet()) {
            HashSet<String> methodNames = new HashSet<String>();
            List<JavaMethodSignature> javaMethodSignatures = freeMarkerTool.getResourceJavaMethodSignatures(this._configYAML, openAPIYAML, schemaName);
            for (JavaMethodSignature javaMethodSignature : javaMethodSignatures) {
                String text;
                String methodName = javaMethodSignature.getMethodName();
                if (methodNames.contains(methodName) || methodName.endsWith("Batch")) continue;
                methodNames.add(methodName);
                int x = yamlString.indexOf(StringUtil.quote(javaMethodSignature.getPath(), '\"') + ":");
                if (x == -1) {
                    x = yamlString.indexOf(javaMethodSignature.getPath() + ":");
                }
                String pathLine = yamlString.substring(yamlString.lastIndexOf("\n", x) + 1, yamlString.indexOf("\n", x));
                String httpMethod = OpenAPIParserUtil.getHTTPMethod(javaMethodSignature.getOperation());
                int y = yamlString.indexOf(httpMethod + ":", x);
                String httpMethodLine = yamlString.substring(yamlString.lastIndexOf("\n", y) + 1, yamlString.indexOf("\n", y));
                String leadingWhiteSpace = pathLine.replaceAll("^(\\s+).+", "$1") + httpMethodLine.replaceAll("^(\\s+).+", "$1");
                int z = yamlString.indexOf(10, y);
                String line = yamlString.substring(z + 1, yamlString.indexOf("\n", z + 1));
                while (line.startsWith(leadingWhiteSpace) && (!line.matches(leadingWhiteSpace + "\\w.*") || (text = line.trim()).compareTo("operationId:") <= 0 && yamlString.indexOf(10, z + 1) != -1)) {
                    z = yamlString.indexOf(10, z + 1);
                    line = yamlString.substring(z + 1, yamlString.indexOf("\n", z + 1));
                }
                yamlString = StringBundler.concat(yamlString.substring(0, z + 1), leadingWhiteSpace, "operationId: ", methodName, "\n", yamlString.substring(z + 1));
            }
        }
        return yamlString;
    }

    private String _fixOpenAPIPathParameters(String yamlString) {
        OpenAPIYAML openAPIYAML = this._loadOpenAPIYAML(yamlString);
        Map<String, PathItem> pathItems = openAPIYAML.getPathItems();
        if (pathItems == null) {
            return yamlString;
        }
        for (Map.Entry<String, PathItem> entry : pathItems.entrySet()) {
            String path = entry.getKey();
            int x = yamlString.indexOf(StringUtil.quote(path, '\"') + ":");
            if (x == -1) {
                x = yamlString.indexOf(path + ":");
            }
            String pathLine = yamlString.substring(yamlString.lastIndexOf("\n", x) + 1, yamlString.indexOf("\n", x));
            for (Operation operation : OpenAPIParserUtil.getOperations(entry.getValue())) {
                int y = yamlString.indexOf(OpenAPIParserUtil.getHTTPMethod(operation) + ":", x);
                for (Parameter parameter : operation.getParameters()) {
                    String in = parameter.getIn();
                    String parameterName = parameter.getName();
                    if (!in.equals("path") || !parameterName.contains("-")) continue;
                    String newParameterName = CamelCaseUtil.toCamelCase(parameterName);
                    int z = yamlString.indexOf(" " + parameterName + "\n", y);
                    yamlString = StringBundler.concat(yamlString.substring(0, z + 1), newParameterName, "\n", yamlString.substring(z + parameterName.length() + 2));
                    String newPathLine = StringUtil.replace(pathLine, "{" + parameterName + "}", "{" + newParameterName + "}");
                    yamlString = StringUtil.replace(yamlString, pathLine, newPathLine);
                }
            }
            ArrayList<String> pathSegments = new ArrayList<String>();
            for (String pathSegment : path.split("/")) {
                if (!Validator.isNotNull(pathSegment)) continue;
                pathSegments.add(pathSegment);
            }
            if (pathSegments.size() != 3 || Objects.equals(pathSegments.get(1), "{id}") || !StringUtil.startsWith((String)pathSegments.get(1), "{") || !StringUtil.endsWith((String)pathSegments.get(1), "Id}")) continue;
            String string2 = (String)pathSegments.get(1);
            string2 = string2.substring(1, string2.length() - 1);
            String text = CamelCaseUtil.fromCamelCase(string2);
            text = TextFormatter.formatPlural(text.substring(0, text.length() - 3));
            StringBuilder sb = new StringBuilder();
            sb.append('/');
            sb.append(text);
            sb.append('/');
            sb.append((String)pathSegments.get(1));
            sb.append('/');
            sb.append(text);
            if (!path.equals(sb.toString()) && !path.equals(sb.toString() + "/")) continue;
            String newParameterName = "parent" + StringUtil.upperCaseFirstLetter(string2);
            for (Operation operation : OpenAPIParserUtil.getOperations(entry.getValue())) {
                int y = yamlString.indexOf(OpenAPIParserUtil.getHTTPMethod(operation) + ":", x);
                for (Parameter parameter : operation.getParameters()) {
                    String in = parameter.getIn();
                    String parameterName = parameter.getName();
                    if (!in.equals("path") || !parameterName.equals(string2)) continue;
                    int z = yamlString.indexOf(" " + parameterName + "\n", y);
                    sb.setLength(0);
                    sb.append(yamlString.substring(0, z + 1));
                    sb.append(newParameterName);
                    sb.append("\n");
                    sb.append(yamlString.substring(z + parameterName.length() + 2));
                    yamlString = sb.toString();
                    String newPathLine = StringUtil.replace(pathLine, "{" + parameterName + "}", "{" + newParameterName + "}");
                    yamlString = StringUtil.replace(yamlString, pathLine, newPathLine);
                }
            }
            String newPathLine = StringUtil.replace(pathLine, "{" + string2 + "}", "{" + newParameterName + "}");
            yamlString = StringUtil.replace(yamlString, pathLine, newPathLine);
        }
        return yamlString;
    }

    private String _fixOpenAPIPaths(String yamlString) {
        OpenAPIYAML openAPIYAML = this._loadOpenAPIYAML(yamlString);
        Map<String, PathItem> pathItems = openAPIYAML.getPathItems();
        if (pathItems == null) {
            return yamlString;
        }
        for (Map.Entry<String, PathItem> entry : pathItems.entrySet()) {
            String path = entry.getKey();
            if (!path.endsWith("/")) continue;
            String newPath = path.substring(0, path.length() - 1);
            int x = yamlString.indexOf(StringUtil.quote(path, '\"') + ":");
            if (x != -1) {
                String newSub = StringUtil.quote(newPath, '\"');
                String oldSub = StringUtil.quote(path, '\"');
                yamlString = StringUtil.replaceFirst(yamlString, oldSub, newSub, x);
                continue;
            }
            x = yamlString.indexOf(path + ":");
            if (x == -1) continue;
            yamlString = StringUtil.replaceFirst(yamlString, path, newPath, x);
        }
        return yamlString;
    }

    private String _fixOpenAPISchemaPropertyNames(FreeMarkerTool freeMarkerTool, String yamlString) {
        OpenAPIYAML openAPIYAML = this._loadOpenAPIYAML(yamlString);
        Map<String, Schema> schemas = freeMarkerTool.getSchemas(openAPIYAML);
        for (Map.Entry<String, Schema> entry1 : schemas.entrySet()) {
            Schema schema = entry1.getValue();
            Map<String, Schema> propertySchemas = schema.getPropertySchemas();
            if (propertySchemas == null) continue;
            for (Map.Entry<String, Schema> entry2 : propertySchemas.entrySet()) {
                Schema propertySchema = entry2.getValue();
                String description = propertySchema.getDescription();
                String reference = null;
                if (StringUtil.startsWith(description, "https://www.schema.org/")) {
                    reference = description;
                } else if (propertySchema.getItems() != null) {
                    Items items = propertySchema.getItems();
                    reference = items.getReference();
                }
                if (reference == null) continue;
                String propertyName = entry2.getKey();
                String schemaVarName = this._getSchemaVarName(freeMarkerTool, reference);
                int x = yamlString.indexOf(' ' + entry1.getKey() + ':');
                int y = yamlString.indexOf(' ' + entry2.getKey() + ':', x);
                int z = yamlString.indexOf(58, y);
                if (Objects.equals(propertySchema.getType(), "array")) {
                    String plural = TextFormatter.formatPlural(schemaVarName);
                    if (propertyName.endsWith(StringUtil.upperCaseFirstLetter(plural)) && propertyName.matches("[a-zA-Z]+")) continue;
                    yamlString = yamlString.substring(0, y + 1) + plural + yamlString.substring(z);
                    continue;
                }
                if (propertyName.endsWith(StringUtil.upperCaseFirstLetter(schemaVarName)) && propertyName.matches("[a-zA-Z]+")) continue;
                yamlString = yamlString.substring(0, y + 1) + schemaVarName + yamlString.substring(z);
            }
        }
        return yamlString;
    }

    private String _formatDescrition(String indent, String descriton) {
        if (Validator.isNull(descriton)) {
            return "";
        }
        if (indent.length() + descriton.length() <= 120) {
            return indent + descriton;
        }
        descriton = indent + descriton;
        int x = descriton.indexOf(32, indent.length());
        if (x == -1) {
            return descriton;
        }
        if (x > 120) {
            String s = descriton.substring(x + 1);
            return descriton.substring(0, x) + "\n" + this._formatDescrition(indent, s);
        }
        x = descriton.lastIndexOf(32, 120);
        String s = descriton.substring(x + 1);
        return descriton.substring(0, x) + "\n" + this._formatDescrition(indent, s);
    }

    private String _getClientMavenGroupId(String apiPackagePath) {
        if (apiPackagePath.startsWith("com.liferay.commerce")) {
            return "com.liferay.commerce";
        }
        if (apiPackagePath.startsWith("com.liferay")) {
            return "com.liferay";
        }
        return this._configYAML.getClientMavenGroupId();
    }

    private Optional<String> _getClientVersionOptional() {
        try {
            String directory = StringUtil.removeSubstring(this._configYAML.getClientDir(), "src/main/java");
            Stream<String> stream = Files.lines(Paths.get(directory + "/bnd.bnd", new String[0]), StandardCharsets.UTF_8);
            return stream.filter(line -> line.startsWith("Bundle-Version: ")).map(line -> StringUtil.removeSubstring(line, "Bundle-Version: ")).findFirst();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return Optional.empty();
        }
    }

    private int _getLineEndIndex(String s, int startIndex) {
        int endIndex = s.indexOf("\n", startIndex);
        if (endIndex < 0) {
            endIndex = s.length();
        }
        return endIndex;
    }

    private Set<String> _getRelatedSchemaNames(Map<String, Schema> schemas, List<JavaMethodSignature> javaMethodSignatures) {
        HashSet<String> relatedSchemaNames = new HashSet<String>();
        for (JavaMethodSignature javaMethodSignature : javaMethodSignatures) {
            String string;
            String returnType = javaMethodSignature.getReturnType();
            String[] returnTypeParts = returnType.split("\\.");
            if (returnTypeParts.length <= 0 || (string = returnTypeParts[returnTypeParts.length - 1]).equals(javaMethodSignature.getSchemaName()) || !schemas.containsKey(string)) continue;
            relatedSchemaNames.add(string);
        }
        return relatedSchemaNames;
    }

    private String _getSchemaVarName(FreeMarkerTool freeMarkerTool, String reference) {
        int index = Math.max(reference.lastIndexOf(35), reference.lastIndexOf(47));
        return freeMarkerTool.getSchemaVarName(reference.substring(index + 1));
    }

    private OpenAPIYAML _loadOpenAPIYAML(String yamlString) {
        OpenAPIYAML openAPIYAML = YAMLUtil.loadOpenAPIYAML(yamlString);
        Map<String, PathItem> pathItems = openAPIYAML.getPathItems();
        if (pathItems == null) {
            return openAPIYAML;
        }
        Components components = openAPIYAML.getComponents();
        if (components == null) {
            return openAPIYAML;
        }
        Map<String, Parameter> parameterMap = components.getParameters();
        for (Map.Entry<String, PathItem> entry : pathItems.entrySet()) {
            PathItem pathItem = entry.getValue();
            ArrayList<Operation> operations = new ArrayList<Operation>();
            if (pathItem.getDelete() != null) {
                operations.add(pathItem.getDelete());
            }
            if (pathItem.getGet() != null) {
                operations.add(pathItem.getGet());
            }
            if (pathItem.getHead() != null) {
                operations.add(pathItem.getHead());
            }
            if (pathItem.getOptions() != null) {
                operations.add(pathItem.getOptions());
            }
            if (pathItem.getPatch() != null) {
                operations.add(pathItem.getPatch());
            }
            if (pathItem.getPost() != null) {
                operations.add(pathItem.getPost());
            }
            if (pathItem.getPut() != null) {
                operations.add(pathItem.getPut());
            }
            for (Operation operation : operations) {
                List<Parameter> parameters = operation.getParameters();
                for (int i = 0; i < parameters.size(); ++i) {
                    String key;
                    Parameter parameter = parameters.get(i);
                    if (!Validator.isNotNull(parameter.getReference()) || !parameterMap.containsKey(key = OpenAPIParserUtil.getReferenceName(parameter.getReference()))) continue;
                    parameters.set(i, parameterMap.get(key));
                }
            }
        }
        return openAPIYAML;
    }

    private void _putSchema(Map<String, Object> context, String escapedVersion, Map<String, String> javaDataTypeMap, Schema schema, String schemaName, Set<String> relatedSchemaNames) {
        context.put("schema", schema);
        String javaType = javaDataTypeMap.get(schemaName);
        if (javaType == null) {
            context.put("schemaClientJavaType", "Object");
            context.put("schemaJavaType", "Object");
        } else {
            context.put("schemaClientJavaType", StringBundler.concat(this._configYAML.getApiPackagePath(), ".client.dto.", escapedVersion, ".", schemaName));
            context.put("schemaJavaType", javaType);
        }
        context.put("schemaName", schemaName);
        context.put("schemaNames", TextFormatter.formatPlural(schemaName));
        context.put("schemaPath", TextFormatter.format(schemaName, 10));
        String schemaVarName = OpenAPIParserUtil.getSchemaVarName(schemaName);
        context.put("schemaVarName", schemaVarName);
        context.put("schemaVarNames", TextFormatter.formatPlural(schemaVarName));
        context.put("relatedSchemaNames", relatedSchemaNames);
    }

    private void _validate(String yamlString) {
        OpenAPIYAML openAPIYAML = this._loadOpenAPIYAML(yamlString);
        Components components = openAPIYAML.getComponents();
        if (components == null) {
            return;
        }
        Map<String, Schema> schemas = components.getSchemas();
        for (Map.Entry<String, Schema> entry1 : schemas.entrySet()) {
            Schema schema = entry1.getValue();
            Map<String, Schema> propertySchemas = schema.getPropertySchemas();
            if (propertySchemas == null) continue;
            for (Map.Entry<String, Schema> entry2 : propertySchemas.entrySet()) {
                Schema propertySchema = entry2.getValue();
                if (!Objects.equals(propertySchema.getType(), "number") || Objects.equals(propertySchema.getFormat(), "bigdecimal") || Objects.equals(propertySchema.getFormat(), "double") || Objects.equals(propertySchema.getFormat(), "float")) continue;
                System.out.println(StringBundler.concat("The property \"", entry1.getKey(), Character.valueOf('.'), entry2.getKey(), "\" should use \"type: integer\" instead of ", "\"type: number\""));
            }
            if (schema.getRequiredPropertySchemaNames() == null) continue;
            List<String> requiredPropertySchemaNames = schema.getRequiredPropertySchemaNames();
            Set<String> propertySchemaNames = propertySchemas.keySet();
            for (String requiredPropertySchemaName : requiredPropertySchemaNames) {
                if (propertySchemaNames.contains(requiredPropertySchemaName)) continue;
                System.out.println(StringBundler.concat("The required property \"", requiredPropertySchemaName, "\" is not defined in ", entry1.getKey()));
            }
        }
    }

    private boolean _validateOpenAPIYAML(String fileName, String yamlString, List<String> validationErrors) {
        try {
            YAMLUtil.validateOpenAPIYAML(fileName, yamlString);
            return true;
        }
        catch (OpenAPIValidatorException openAPIValidatorException) {
            validationErrors.add(openAPIValidatorException.getMessage());
            return false;
        }
    }
}

