/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.util;

import com.liferay.petra.function.UnsafeConsumer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EntityExtensionUtil {
    public static <T, S extends T> S extend(T baseEntity, Class<T> baseEntityClass, Class<S> extendedEntityClass, UnsafeConsumer<S, ? extends Exception> unsafeConsumer) throws Exception {
        S extendedEntity = extendedEntityClass.newInstance();
        Class<S> extendedEntityClassSuperclass = extendedEntityClass.getSuperclass();
        Field[] extendedEntityFields = extendedEntityClassSuperclass.getDeclaredFields();
        Stream<Field> extendedEntityFieldsStream = Arrays.stream(extendedEntityFields);
        Map extendedEntityFieldsMap = extendedEntityFieldsStream.collect(Collectors.toMap(Field::getName, Function.identity()));
        for (Field baseEntityField : baseEntityClass.getDeclaredFields()) {
            int modifiers = baseEntityField.getModifiers();
            if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers)) continue;
            Field extendedEntityField = (Field)extendedEntityFieldsMap.get(baseEntityField.getName());
            baseEntityField.setAccessible(true);
            extendedEntityField.setAccessible(true);
            extendedEntityField.set(extendedEntity, baseEntityField.get(baseEntity));
        }
        unsafeConsumer.accept(extendedEntity);
        return extendedEntity;
    }
}

