/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class Response
implements AutoCloseable {
    protected Response() {
    }

    public abstract int getStatus();

    public abstract StatusType getStatusInfo();

    public abstract Object getEntity();

    public abstract <T> T readEntity(Class<T> var1);

    public abstract <T> T readEntity(GenericType<T> var1);

    public abstract <T> T readEntity(Class<T> var1, Annotation[] var2);

    public abstract <T> T readEntity(GenericType<T> var1, Annotation[] var2);

    public abstract boolean hasEntity();

    public abstract boolean bufferEntity();

    @Override
    public abstract void close();

    public abstract MediaType getMediaType();

    public abstract Locale getLanguage();

    public abstract int getLength();

    public abstract Set<String> getAllowedMethods();

    public abstract Map<String, NewCookie> getCookies();

    public abstract EntityTag getEntityTag();

    public abstract Date getDate();

    public abstract Date getLastModified();

    public abstract URI getLocation();

    public abstract Set<Link> getLinks();

    public abstract boolean hasLink(String var1);

    public abstract Link getLink(String var1);

    public abstract Link.Builder getLinkBuilder(String var1);

    public abstract MultivaluedMap<String, Object> getMetadata();

    public MultivaluedMap<String, Object> getHeaders() {
        return this.getMetadata();
    }

    public abstract MultivaluedMap<String, String> getStringHeaders();

    public abstract String getHeaderString(String var1);

    public static ResponseBuilder fromResponse(Response response) {
        ResponseBuilder b = Response.status(response.getStatus());
        if (response.hasEntity()) {
            b.entity(response.getEntity());
        }
        for (String headerName : response.getHeaders().keySet()) {
            List headerValues = (List)response.getHeaders().get((Object)headerName);
            for (Object headerValue : headerValues) {
                b.header(headerName, headerValue);
            }
        }
        return b;
    }

    public static ResponseBuilder status(StatusType status) {
        return ResponseBuilder.newInstance().status(status);
    }

    public static ResponseBuilder status(Status status) {
        return Response.status((StatusType)status);
    }

    public static ResponseBuilder status(int status) {
        return ResponseBuilder.newInstance().status(status);
    }

    public static ResponseBuilder status(int status, String reasonPhrase) {
        return ResponseBuilder.newInstance().status(status, reasonPhrase);
    }

    public static ResponseBuilder ok() {
        return Response.status(Status.OK);
    }

    public static ResponseBuilder ok(Object entity) {
        ResponseBuilder b = Response.ok();
        b.entity(entity);
        return b;
    }

    public static ResponseBuilder ok(Object entity, MediaType type) {
        return Response.ok().entity(entity).type(type);
    }

    public static ResponseBuilder ok(Object entity, String type) {
        return Response.ok().entity(entity).type(type);
    }

    public static ResponseBuilder ok(Object entity, Variant variant) {
        return Response.ok().entity(entity).variant(variant);
    }

    public static ResponseBuilder serverError() {
        return Response.status(Status.INTERNAL_SERVER_ERROR);
    }

    public static ResponseBuilder created(URI location) {
        return Response.status(Status.CREATED).location(location);
    }

    public static ResponseBuilder accepted() {
        return Response.status(Status.ACCEPTED);
    }

    public static ResponseBuilder accepted(Object entity) {
        return Response.accepted().entity(entity);
    }

    public static ResponseBuilder noContent() {
        return Response.status(Status.NO_CONTENT);
    }

    public static ResponseBuilder notModified() {
        return Response.status(Status.NOT_MODIFIED);
    }

    public static ResponseBuilder notModified(EntityTag tag) {
        return Response.notModified().tag(tag);
    }

    public static ResponseBuilder notModified(String tag) {
        return Response.notModified().tag(tag);
    }

    public static ResponseBuilder seeOther(URI location) {
        return Response.status(Status.SEE_OTHER).location(location);
    }

    public static ResponseBuilder temporaryRedirect(URI location) {
        return Response.status(Status.TEMPORARY_REDIRECT).location(location);
    }

    public static ResponseBuilder notAcceptable(List<Variant> variants) {
        return Response.status(Status.NOT_ACCEPTABLE).variants(variants);
    }
}

