/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.util;

import com.liferay.petra.function.UnsafeFunction;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TransformUtil {
    public static <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        if (collection == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>(collection.size());
        for (T item : collection) {
            try {
                Object newItem = unsafeFunction.apply(item);
                if (newItem == null) continue;
                list.add(newItem);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return list;
    }

    public static <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        List<R> list = TransformUtil.transformToList(array, unsafeFunction);
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        List<R> list = TransformUtil.transform(collection, unsafeFunction);
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        if (array == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>(array.length);
        for (T item : array) {
            try {
                Object newItem = unsafeFunction.apply(item);
                if (newItem == null) continue;
                list.add(newItem);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return list;
    }
}

