/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.util.ArrayList;
import java.util.List;

public class TreeNode<T extends Comparable<T>> {
    private final List<TreeNode<T>> _childNodes;
    private final TreeNode<T> _parentNode;
    private final T _value;

    public TreeNode(T value) {
        this(value, null);
    }

    public TreeNode(T value, TreeNode<T> parentNode) {
        this(value, parentNode, new ArrayList<TreeNode<T>>());
    }

    public TreeNode(T value, TreeNode<T> parentNode, List<TreeNode<T>> childNodes) {
        this._value = value;
        this._parentNode = parentNode;
        this._childNodes = childNodes;
    }

    public TreeNode<T> addChildNode(T value) {
        TreeNode<T> childNode = new TreeNode<T>(value, this);
        this._childNodes.add(childNode);
        return childNode;
    }

    public List<TreeNode<T>> getChildNodes() {
        return this._childNodes;
    }

    public List<T> getChildValues() {
        ArrayList<T> values = new ArrayList<T>(this._childNodes.size());
        for (TreeNode<T> childNode : this._childNodes) {
            values.add(childNode.getValue());
        }
        return values;
    }

    public TreeNode<T> getParentNode() {
        return this._parentNode;
    }

    public T getValue() {
        return this._value;
    }

    public boolean isRootNode() {
        return this._parentNode == null;
    }
}

