/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.JavaMethodParameter;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.JavaMethodSignature;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser.ResourceOpenAPIParser;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser.util.OpenAPIParserUtil;
import com.liferay.portal.tools.rest.builder.internal.freemarker.util.OpenAPIUtil;
import com.liferay.portal.tools.rest.builder.internal.yaml.config.ConfigYAML;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Components;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.OpenAPIYAML;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Operation;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Parameter;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Schema;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;

public class GraphQLOpenAPIParser {
    public static List<JavaMethodSignature> getJavaMethodSignatures(ConfigYAML configYAML, OpenAPIYAML openAPIYAML, Predicate<Operation> predicate) throws Exception {
        ArrayList<JavaMethodSignature> javaMethodSignatures = new ArrayList<JavaMethodSignature>();
        TreeMap<String, Schema> schemas = new TreeMap<String, Schema>();
        Components components = openAPIYAML.getComponents();
        if (components != null) {
            schemas.putAll(components.getSchemas());
        }
        schemas.putAll(OpenAPIUtil.getAllExternalSchemas(openAPIYAML));
        for (String schemaName : schemas.keySet()) {
            javaMethodSignatures.addAll(GraphQLOpenAPIParser._getJavaMethodSignatures(configYAML, openAPIYAML, predicate, schemaName));
        }
        return javaMethodSignatures;
    }

    public static String getMethodAnnotations(JavaMethodSignature javaMethodSignature) {
        String methodAnnotation;
        TreeSet<String> methodAnnotations = new TreeSet<String>();
        Operation operation = javaMethodSignature.getOperation();
        String httpMethod = OpenAPIParserUtil.getHTTPMethod(operation);
        if (httpMethod != null) {
            StringBundler sb = new StringBundler("@GraphQLField(");
            if (operation.getDescription() != null) {
                sb.append("description=\"");
                sb.append(operation.getDescription());
                sb.append("\"");
            }
            sb.append(")");
            methodAnnotations.add(sb.toString());
        }
        if ((methodAnnotation = GraphQLOpenAPIParser._getMethodAnnotationGraphQLName(javaMethodSignature)) != null) {
            methodAnnotations.add(methodAnnotation);
        }
        return StringUtil.merge(methodAnnotations, "\n");
    }

    public static String getParameters(List<JavaMethodParameter> javaMethodParameters, Operation operation, boolean annotation) {
        StringBuilder sb = new StringBuilder();
        for (JavaMethodParameter javaMethodParameter : javaMethodParameters) {
            String parameterAnnotation = null;
            if (annotation) {
                parameterAnnotation = GraphQLOpenAPIParser._getParameterAnnotation(javaMethodParameter, operation);
            }
            String parameter = OpenAPIParserUtil.getParameter(javaMethodParameter, parameterAnnotation);
            sb.append(parameter);
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static List<JavaMethodParameter> _getJavaMethodParameters(JavaMethodSignature resourceJavaMethodSignature) {
        ArrayList<JavaMethodParameter> javaMethodParameters = new ArrayList<JavaMethodParameter>();
        for (JavaMethodParameter javaMethodParameter : resourceJavaMethodSignature.getJavaMethodParameters()) {
            if (Objects.equals(javaMethodParameter.getParameterType(), Pagination.class.getName())) {
                javaMethodParameters.add(new JavaMethodParameter("pageSize", Integer.TYPE.getName()));
                javaMethodParameters.add(new JavaMethodParameter("page", Integer.TYPE.getName()));
                continue;
            }
            javaMethodParameters.add(javaMethodParameter);
        }
        return javaMethodParameters;
    }

    private static List<JavaMethodSignature> _getJavaMethodSignatures(ConfigYAML configYAML, OpenAPIYAML openAPIYAML, Predicate<Operation> predicate, String schemaName) {
        ArrayList<JavaMethodSignature> javaMethodSignatures = new ArrayList<JavaMethodSignature>();
        List<JavaMethodSignature> resourceJavaMethodSignatures = ResourceOpenAPIParser.getJavaMethodSignatures(configYAML, openAPIYAML, schemaName);
        for (JavaMethodSignature resourceJavaMethodSignature : resourceJavaMethodSignatures) {
            Operation operation = resourceJavaMethodSignature.getOperation();
            if (!predicate.test(operation)) continue;
            String returnType = resourceJavaMethodSignature.getReturnType();
            if (returnType.startsWith(Page.class.getName() + "<")) {
                String pageClassName = Page.class.getName();
                String className = returnType.substring(pageClassName.length() + 1, returnType.length() - 1);
                returnType = StringBundler.concat(Collection.class.getName(), "<", className, ">");
            }
            List<JavaMethodParameter> javaMethodParameters = GraphQLOpenAPIParser._getJavaMethodParameters(resourceJavaMethodSignature);
            javaMethodSignatures.add(new JavaMethodSignature(resourceJavaMethodSignature.getPath(), resourceJavaMethodSignature.getPathItem(), operation, resourceJavaMethodSignature.getRequestBodyMediaTypes(), resourceJavaMethodSignature.getSchemaName(), javaMethodParameters, resourceJavaMethodSignature.getMethodName(), returnType));
        }
        return javaMethodSignatures;
    }

    private static String _getMethodAnnotationGraphQLName(JavaMethodSignature javaMethodSignature) {
        Set<String> requestBodyMediaTypes = javaMethodSignature.getRequestBodyMediaTypes();
        if (requestBodyMediaTypes.isEmpty() || requestBodyMediaTypes.contains("application/json")) {
            return null;
        }
        List<JavaMethodParameter> javaMethodParameters = javaMethodSignature.getJavaMethodParameters();
        StringBundler sb = new StringBundler("@GraphQLName(value=\"");
        sb.append(javaMethodSignature.getMethodName());
        for (JavaMethodParameter javaMethodParameter : javaMethodParameters) {
            sb.append(StringUtil.upperCaseFirstLetter(javaMethodParameter.getParameterName()));
        }
        Operation operation = javaMethodSignature.getOperation();
        sb.append("\", description=\"");
        sb.append(operation.getDescription());
        sb.append("\")");
        return sb.toString();
    }

    private static String _getParameterAnnotation(JavaMethodParameter javaMethodParameter, Operation operation) {
        for (Parameter parameter : operation.getParameters()) {
            Schema schema;
            String parameterName = CamelCaseUtil.toCamelCase(parameter.getName());
            if (!Objects.equals(parameterName, javaMethodParameter.getParameterName()) || (schema = parameter.getSchema()).getType() == null) continue;
            return StringBundler.concat("@GraphQLName(\"", parameter.getName(), "\")");
        }
        StringBundler sb = new StringBundler(3);
        sb.append("@GraphQLName(\"");
        String parameterName = javaMethodParameter.getParameterName();
        if (parameterName.equals("sorts")) {
            sb.append("sort");
        } else {
            sb.append(javaMethodParameter.getParameterName());
        }
        sb.append("\")");
        return sb.toString();
    }
}

