/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;

public class StringUtil {
    protected static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String[] _EMPTY_STRING_ARRAY = new String[0];
    private static final char[] _RANDOM_STRING_CHAR_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public static String add(String s, String add) {
        return StringUtil.add(s, add, ",");
    }

    public static String add(String s, String add, String delimiter) {
        return StringUtil.add(s, add, delimiter, false);
    }

    public static String add(String s, String add, String delimiter, boolean allowDuplicates) {
        if (add == null || delimiter == null) {
            return null;
        }
        if (s == null) {
            s = "";
        }
        if (allowDuplicates || !StringUtil.contains(s, add, delimiter)) {
            StringBundler sb = new StringBundler(4);
            sb.append(s);
            if (Validator.isNull(s) || s.endsWith(delimiter)) {
                sb.append(add);
                sb.append(delimiter);
            } else {
                sb.append(delimiter);
                sb.append(add);
                sb.append(delimiter);
            }
            s = sb.toString();
        }
        return s;
    }

    public static String appendParentheticalSuffix(String s, int suffix) {
        if (Pattern.matches(".* \\(" + String.valueOf(suffix - 1) + "\\)", s)) {
            int pos = s.lastIndexOf(" (");
            s = s.substring(0, pos);
        }
        return StringUtil.appendParentheticalSuffix(s, String.valueOf(suffix));
    }

    public static String appendParentheticalSuffix(String s, String suffix) {
        return StringBundler.concat(s, " ", "(", suffix, ")");
    }

    public static String bytesToHexString(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i * 2] = HEX_DIGITS[(bytes[i] & 0xFF) >> 4];
            chars[i * 2 + 1] = HEX_DIGITS[bytes[i] & 0xF];
        }
        return new String(chars);
    }

    public static boolean contains(String s, String text) {
        return StringUtil.contains(s, text, ",");
    }

    public static boolean contains(String s, String text, String delimiter) {
        String dtd;
        int pos;
        if (s == null || text == null || delimiter == null) {
            return false;
        }
        if (!s.endsWith(delimiter)) {
            s = s.concat(delimiter);
        }
        if ((pos = s.indexOf(dtd = StringBundler.concat(delimiter, text, delimiter))) == -1) {
            String td = text.concat(delimiter);
            return s.startsWith(td);
        }
        return true;
    }

    public static boolean containsIgnoreCase(String s, String text) {
        return StringUtil.containsIgnoreCase(s, text, ",");
    }

    public static boolean containsIgnoreCase(String s, String text, String delimiter) {
        if (s == null || text == null || delimiter == null) {
            return false;
        }
        return StringUtil.contains(StringUtil.toLowerCase(s), StringUtil.toLowerCase(text), delimiter);
    }

    public static int count(String s, char c) {
        return StringUtil.count(s, 0, s.length(), c);
    }

    public static int count(String s, int start, int end, char c) {
        if (s == null || s.isEmpty() || end - start < 1) {
            return 0;
        }
        int count = 0;
        for (int pos = start; pos < end && (pos = s.indexOf(c, pos)) != -1; ++pos) {
            if (pos >= end) continue;
            ++count;
        }
        return count;
    }

    public static int count(String s, int start, int end, String text) {
        if (s == null || s.isEmpty() || end - start < 1 || text == null || text.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (int pos = start; pos < end && (pos = s.indexOf(text, pos)) != -1; pos += text.length()) {
            if (pos >= end) continue;
            ++count;
        }
        return count;
    }

    public static int count(String s, String text) {
        return StringUtil.count(s, 0, s.length(), text);
    }

    public static boolean endsWith(String s, char end) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        return StringUtil.equalsIgnoreCase(s.charAt(s.length() - 1), end);
    }

    public static boolean endsWith(String s, String end) {
        if (s == null || end == null || end.length() > s.length()) {
            return false;
        }
        String temp = s.substring(s.length() - end.length());
        return StringUtil.equalsIgnoreCase(temp, end);
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean equalsIgnoreBreakLine(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        s1 = StringUtil.removeChars(s1, '\r', '\n');
        s2 = StringUtil.removeChars(s2, '\r', '\n');
        if (s1.length() != s2.length()) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean equalsIgnoreCase(char c1, char c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 > '\u007f' || c2 > '\u007f') {
            return Character.toLowerCase(c1) == Character.toLowerCase(c2) || Character.toUpperCase(c1) == Character.toUpperCase(c2);
        }
        if (c1 < 'A' || c1 > 'z' || c2 < 'A' || c2 > 'z') {
            return false;
        }
        int delta = c1 - c2;
        return delta == 32 || delta == -32;
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null || s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (StringUtil.equalsIgnoreCase(s1.charAt(i), s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String extractChars(String s) {
        char[] chars;
        if (s == null) {
            return "";
        }
        StringBundler sb = new StringBundler();
        for (char c : chars = s.toCharArray()) {
            if (!Validator.isChar(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String extractDigits(String s) {
        char[] chars;
        if (s == null) {
            return "";
        }
        StringBundler sb = new StringBundler();
        for (char c : chars = s.toCharArray()) {
            if (!Validator.isDigit(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String extractFirst(String s, char delimiter) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(delimiter);
        if (index < 0) {
            return null;
        }
        return s.substring(0, index);
    }

    public static String extractFirst(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(delimiter);
        if (index < 0) {
            return null;
        }
        return s.substring(0, index);
    }

    public static String extractLast(String s, char delimiter) {
        if (s == null) {
            return null;
        }
        int index = s.lastIndexOf(delimiter);
        if (index < 0) {
            return null;
        }
        return s.substring(index + 1);
    }

    public static String extractLast(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        int index = s.lastIndexOf(delimiter);
        if (index < 0) {
            return null;
        }
        return s.substring(index + delimiter.length());
    }

    public static String extractLeadingDigits(String s) {
        char[] chars;
        if (s == null) {
            return "";
        }
        StringBundler sb = new StringBundler();
        for (char c : chars = s.toCharArray()) {
            if (!Validator.isDigit(c)) {
                return sb.toString();
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static int indexOfAny(String s, char[] chars) {
        if (s == null) {
            return -1;
        }
        return StringUtil.indexOfAny(s, chars, 0, s.length() - 1);
    }

    public static int indexOfAny(String s, char[] chars, int fromIndex) {
        if (s == null) {
            return -1;
        }
        return StringUtil.indexOfAny(s, chars, fromIndex, s.length() - 1);
    }

    public static int indexOfAny(String s, char[] chars, int fromIndex, int toIndex) {
        if (s == null || toIndex < fromIndex || ArrayUtil.isEmpty(chars) || fromIndex >= s.length()) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex >= s.length()) {
            toIndex = s.length() - 1;
        }
        for (int i = fromIndex; i <= toIndex; ++i) {
            char c1 = s.charAt(i);
            for (char c2 : chars) {
                if (c1 != c2) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfAny(String s, String[] texts) {
        if (s == null) {
            return -1;
        }
        return StringUtil.indexOfAny(s, texts, 0, s.length() - 1);
    }

    public static int indexOfAny(String s, String[] texts, int fromIndex) {
        if (s == null) {
            return -1;
        }
        return StringUtil.indexOfAny(s, texts, fromIndex, s.length() - 1);
    }

    public static int indexOfAny(String s, String[] texts, int fromIndex, int toIndex) {
        if (s == null || toIndex < fromIndex || ArrayUtil.isEmpty(texts) || fromIndex >= s.length()) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex >= s.length()) {
            toIndex = s.length() - 1;
        }
        for (int i = fromIndex; i <= toIndex; ++i) {
            for (String text : texts) {
                if (text == null || i + text.length() > toIndex + 1 || !s.startsWith(text, i)) continue;
                return i;
            }
        }
        return -1;
    }

    public static String insert(String s, String insert, int offset) {
        if (s == null) {
            return null;
        }
        if (insert == null) {
            return s;
        }
        if (offset > s.length()) {
            return s.concat(insert);
        }
        String prefix = s.substring(0, offset);
        String postfix = s.substring(offset);
        return StringBundler.concat(prefix, insert, postfix);
    }

    public static boolean isLowerCase(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(c <= '\u007f' ? c >= 'A' && c <= 'Z' : Character.isLetter(c) && Character.isUpperCase(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(c <= '\u007f' ? c >= 'a' && c <= 'z' : Character.isLetter(c) && Character.isLowerCase(c))) continue;
            return false;
        }
        return true;
    }

    public static int lastIndexOfAny(String s, char[] chars) {
        if (s == null) {
            return -1;
        }
        return StringUtil.lastIndexOfAny(s, chars, 0, s.length() - 1);
    }

    public static int lastIndexOfAny(String s, char[] chars, int toIndex) {
        if (s == null) {
            return -1;
        }
        return StringUtil.lastIndexOfAny(s, chars, 0, toIndex);
    }

    public static int lastIndexOfAny(String s, char[] chars, int fromIndex, int toIndex) {
        if (s == null || toIndex < fromIndex || ArrayUtil.isEmpty(chars) || fromIndex >= s.length()) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex >= s.length()) {
            toIndex = s.length() - 1;
        }
        for (int i = toIndex; i >= fromIndex; --i) {
            char c1 = s.charAt(i);
            for (char c2 : chars) {
                if (c1 != c2) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOfAny(String s, String[] texts) {
        if (s == null) {
            return -1;
        }
        return StringUtil.lastIndexOfAny(s, texts, 0, s.length() - 1);
    }

    public static int lastIndexOfAny(String s, String[] texts, int toIndex) {
        if (s == null) {
            return -1;
        }
        return StringUtil.lastIndexOfAny(s, texts, 0, toIndex);
    }

    public static int lastIndexOfAny(String s, String[] texts, int fromIndex, int toIndex) {
        if (s == null || toIndex < fromIndex || ArrayUtil.isEmpty(texts) || fromIndex >= s.length()) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex >= s.length()) {
            toIndex = s.length() - 1;
        }
        for (int i = toIndex; i >= fromIndex; --i) {
            for (String text : texts) {
                if (text == null || i + text.length() > toIndex + 1 || !s.startsWith(text, i)) continue;
                return i;
            }
        }
        return -1;
    }

    public static String lowerCase(String s) {
        return StringUtil.toLowerCase(s);
    }

    public static void lowerCase(String ... array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = StringUtil.toLowerCase(array[i]);
            }
        }
    }

    public static String lowerCaseFirstLetter(String s) {
        char[] chars = s.toCharArray();
        if (chars[0] >= 'A' && chars[0] <= 'Z') {
            chars[0] = (char)(chars[0] + 32);
        }
        return new String(chars);
    }

    public static boolean matches(String s, String pattern) {
        String[] array;
        for (String element : array = pattern.split("\\*")) {
            int pos = s.indexOf(element);
            if (pos == -1) {
                return false;
            }
            s = s.substring(pos + element.length());
        }
        return true;
    }

    public static boolean matchesIgnoreCase(String s, String pattern) {
        return StringUtil.matches(StringUtil.lowerCase(s), StringUtil.lowerCase(pattern));
    }

    public static String merge(boolean[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(boolean[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String merge(char[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(char[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String merge(Collection<?> col) {
        return StringUtil.merge(col, ",");
    }

    public static String merge(Collection<?> col, String delimiter) {
        if (col == null) {
            return null;
        }
        if (col.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * col.size());
        for (Object object : col) {
            String objectString = String.valueOf(object);
            sb.append(objectString.trim());
            sb.append(delimiter);
        }
        if (!delimiter.isEmpty()) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    public static String merge(double[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(double[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String merge(float[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(float[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String merge(int[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(int[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String merge(long[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(long[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String merge(Object[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(Object[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            String value = String.valueOf(array[i]);
            sb.append(value.trim());
        }
        return sb.toString();
    }

    public static String merge(short[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(short[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String quote(String s) {
        return StringUtil.quote(s, '\'');
    }

    public static String quote(String s, char quote) {
        if (s == null) {
            return null;
        }
        return StringUtil.quote(s, String.valueOf(quote));
    }

    public static String quote(String s, String quote) {
        if (s == null) {
            return null;
        }
        return StringBundler.concat(quote, s, quote);
    }

    public static String randomId() {
        return StringUtil.randomId(4);
    }

    public static String randomId(int length) {
        Random random = new Random();
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(97 + random.nextInt(26));
        }
        return new String(chars);
    }

    public static String randomString() {
        return StringUtil.randomString(8);
    }

    public static String randomString(int length) {
        Random random = new Random();
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(_RANDOM_STRING_CHAR_TABLE.length);
            chars[i] = _RANDOM_STRING_CHAR_TABLE[index];
        }
        return new String(chars);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(Class<?> clazz, String name) {
        try (InputStream inputStream = clazz.getResourceAsStream(name);){
            String string = StringUtil.read(inputStream);
            return string;
        }
        catch (IOException ioException) {
            return (String)ReflectionUtil.throwException((Throwable)ioException);
        }
    }

    public static String read(ClassLoader classLoader, String name) throws IOException {
        return StringUtil.read(classLoader, name, false);
    }

    public static String read(ClassLoader classLoader, String name, boolean all) throws IOException {
        if (all) {
            StringBundler sb = new StringBundler();
            Enumeration<URL> enumeration = classLoader.getResources(name);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                InputStream inputStream = url.openStream();
                Throwable throwable = null;
                try {
                    String s = StringUtil.read(inputStream);
                    if (s == null) continue;
                    sb.append(s);
                    sb.append("\n");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            String s = sb.toString();
            return s.trim();
        }
        try (InputStream inputStream = classLoader.getResourceAsStream(name);){
            if (inputStream == null) {
                throw new IOException(StringBundler.concat("Unable to open resource ", name, " in class loader ", classLoader));
            }
            String string = StringUtil.read(inputStream);
            return string;
        }
    }

    public static String read(InputStream inputStream) throws IOException {
        String s = StringUtil._read(inputStream);
        s = StringUtil.replace(s, "\r\n", "\n");
        s = StringUtil.replace(s, '\r', '\n');
        return s.trim();
    }

    public static void readLines(InputStream inputStream, Collection<String> lines) throws IOException {
        StringUtil._splitLines(StringUtil._read(inputStream), lines);
    }

    public static String removeChar(String s, char oldSub) {
        if (s == null) {
            return null;
        }
        int y = s.indexOf(oldSub);
        if (y >= 0) {
            StringBundler sb = new StringBundler();
            int x = 0;
            while (x <= y) {
                sb.append(s.substring(x, y));
                x = y + 1;
                y = s.indexOf(oldSub, x);
            }
            sb.append(s.substring(x));
            return sb.toString();
        }
        return s;
    }

    public static String removeChars(String s, char ... oldSubs) {
        if (s == null) {
            return null;
        }
        if (oldSubs == null) {
            return s;
        }
        StringBundler sb = new StringBundler(s.length());
        block0: for (int i = 0; i < s.length(); ++i) {
            char c1 = s.charAt(i);
            for (char c2 : oldSubs) {
                if (c1 == c2) continue block0;
            }
            sb.append(c1);
        }
        if (s.length() == sb.length()) {
            return s;
        }
        return sb.toString();
    }

    public static String removeFromList(String s, String element) {
        return StringUtil.removeFromList(s, element, ",");
    }

    public static String removeFromList(String s, String element, String delimiter) {
        if (s == null || element == null || delimiter == null) {
            return null;
        }
        if (Validator.isNotNull(s) && !s.endsWith(delimiter)) {
            s = s + delimiter;
        }
        String drd = StringBundler.concat(delimiter, element, delimiter);
        String rd = element.concat(delimiter);
        while (StringUtil.contains(s, element, delimiter)) {
            int y;
            int x;
            int pos = s.indexOf(drd);
            if (pos == -1) {
                if (!s.startsWith(rd)) continue;
                x = element.length() + delimiter.length();
                y = s.length();
                s = s.substring(x, y);
                continue;
            }
            x = pos + element.length() + delimiter.length();
            y = s.length();
            String temp = s.substring(0, pos);
            s = temp.concat(s.substring(x, y));
        }
        return s;
    }

    public static String removeSubstring(String s, String oldSub) {
        if (s == null) {
            return null;
        }
        if (oldSub == null) {
            return s;
        }
        int y = s.indexOf(oldSub);
        if (y >= 0) {
            StringBundler sb = new StringBundler();
            int length = oldSub.length();
            int x = 0;
            while (x <= y) {
                sb.append(s.substring(x, y));
                x = y + length;
                y = s.indexOf(oldSub, x);
            }
            sb.append(s.substring(x));
            return sb.toString();
        }
        return s;
    }

    public static String removeSubstrings(String s, String ... oldSubs) {
        if (s == null) {
            return null;
        }
        if (ArrayUtil.isEmpty(oldSubs)) {
            return s;
        }
        for (String oldSub : oldSubs) {
            s = StringUtil.removeSubstring(s, oldSub);
        }
        return s;
    }

    public static String replace(String s, char oldSub, char newSub) {
        if (s == null) {
            return null;
        }
        return s.replace(oldSub, newSub);
    }

    public static String replace(String s, char oldSub, String newSub) {
        if (s == null || newSub == null) {
            return null;
        }
        int index = s.indexOf(oldSub);
        if (index == -1) {
            return s;
        }
        int previousIndex = index;
        StringBundler sb = new StringBundler();
        if (previousIndex != 0) {
            sb.append(s.substring(0, previousIndex));
        }
        sb.append(newSub);
        while ((index = s.indexOf(oldSub, previousIndex + 1)) != -1) {
            sb.append(s.substring(previousIndex + 1, index));
            sb.append(newSub);
            previousIndex = index;
        }
        index = previousIndex + 1;
        if (index < s.length()) {
            sb.append(s.substring(index));
        }
        return sb.toString();
    }

    public static String replace(String s, char[] oldSubs, char[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        sb.append(s);
        boolean modified = false;
        block0: for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            for (int j = 0; j < oldSubs.length; ++j) {
                if (c != oldSubs[j]) continue;
                sb.setCharAt(i, newSubs[j]);
                modified = true;
                continue block0;
            }
        }
        if (modified) {
            return sb.toString();
        }
        return s;
    }

    public static String replace(String s, char[] oldSubs, String[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        StringBundler sb = null;
        int lastReplacementIndex = 0;
        block0: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            for (int j = 0; j < oldSubs.length; ++j) {
                if (c != oldSubs[j]) continue;
                if (sb == null) {
                    sb = new StringBundler();
                }
                if (i > lastReplacementIndex) {
                    sb.append(s.substring(lastReplacementIndex, i));
                }
                sb.append(newSubs[j]);
                lastReplacementIndex = i + 1;
                continue block0;
            }
        }
        if (sb == null) {
            return s;
        }
        if (lastReplacementIndex < s.length()) {
            sb.append(s.substring(lastReplacementIndex));
        }
        return sb.toString();
    }

    public static String replace(String s, String oldSub, String newSub) {
        return StringUtil.replace(s, oldSub, newSub, 0);
    }

    public static String replace(String s, String oldSub, String newSub, int fromIndex) {
        int y;
        if (s == null) {
            return null;
        }
        if (oldSub == null || oldSub.equals("")) {
            return s;
        }
        if (newSub == null) {
            newSub = "";
        }
        if ((y = s.indexOf(oldSub, fromIndex)) >= 0) {
            StringBundler sb = new StringBundler();
            int length = oldSub.length();
            int x = 0;
            while (x <= y) {
                sb.append(s.substring(x, y));
                sb.append(newSub);
                x = y + length;
                y = s.indexOf(oldSub, x);
            }
            sb.append(s.substring(x));
            return sb.toString();
        }
        return s;
    }

    public static String replace(String s, String begin, String end, Map<String, String> values) {
        StringBundler sb = StringUtil.replaceToStringBundler(s, begin, end, values);
        return sb.toString();
    }

    public static String replace(String s, String[] oldSubs, String[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        for (int i = 0; i < oldSubs.length; ++i) {
            s = StringUtil.replace(s, oldSubs[i], newSubs[i]);
        }
        return s;
    }

    public static String replace(String s, String[] oldSubs, String[] newSubs, boolean exactMatch) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        if (!exactMatch) {
            return StringUtil.replace(s, oldSubs, newSubs);
        }
        for (int i = 0; i < oldSubs.length; ++i) {
            s = s.replaceAll("\\b" + oldSubs[i] + "\\b", newSubs[i]);
        }
        return s;
    }

    public static String replaceFirst(String s, char oldSub, char newSub) {
        if (s == null) {
            return null;
        }
        return StringUtil.replaceFirst(s, String.valueOf(oldSub), String.valueOf(newSub));
    }

    public static String replaceFirst(String s, char oldSub, String newSub) {
        if (s == null || newSub == null) {
            return null;
        }
        return StringUtil.replaceFirst(s, String.valueOf(oldSub), newSub);
    }

    public static String replaceFirst(String s, String oldSub, String newSub) {
        return StringUtil.replaceFirst(s, oldSub, newSub, 0);
    }

    public static String replaceFirst(String s, String oldSub, String newSub, int fromIndex) {
        if (s == null || oldSub == null || newSub == null) {
            return null;
        }
        if (oldSub.equals(newSub)) {
            return s;
        }
        int y = s.indexOf(oldSub, fromIndex);
        if (y >= 0) {
            return StringBundler.concat(s.substring(0, y), newSub, s.substring(y + oldSub.length()));
        }
        return s;
    }

    public static String replaceFirst(String s, String[] oldSubs, String[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        for (int i = 0; i < oldSubs.length; ++i) {
            s = StringUtil.replaceFirst(s, oldSubs[i], newSubs[i]);
        }
        return s;
    }

    public static String replaceLast(String s, char oldSub, char newSub) {
        if (s == null) {
            return null;
        }
        return StringUtil.replaceLast(s, String.valueOf(oldSub), String.valueOf(newSub));
    }

    public static String replaceLast(String s, char oldSub, String newSub) {
        if (s == null || newSub == null) {
            return null;
        }
        return StringUtil.replaceLast(s, String.valueOf(oldSub), newSub);
    }

    public static String replaceLast(String s, String oldSub, String newSub) {
        if (s == null || oldSub == null || newSub == null) {
            return null;
        }
        if (oldSub.equals(newSub)) {
            return s;
        }
        int y = s.lastIndexOf(oldSub);
        if (y >= 0) {
            return StringBundler.concat(s.substring(0, y), newSub, s.substring(y + oldSub.length()));
        }
        return s;
    }

    public static String replaceLast(String s, String[] oldSubs, String[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        for (int i = 0; i < oldSubs.length; ++i) {
            s = StringUtil.replaceLast(s, oldSubs[i], newSubs[i]);
        }
        return s;
    }

    public static StringBundler replaceToStringBundler(String s, String begin, String end, Map<String, String> values) {
        if (Validator.isBlank(s) || Validator.isBlank(begin) || Validator.isBlank(end) || MapUtil.isEmpty(values)) {
            return new StringBundler(s);
        }
        StringBundler sb = new StringBundler(values.size() * 2 + 1);
        int pos = 0;
        while (true) {
            int x = s.indexOf(begin, pos);
            int y = s.indexOf(end, x + begin.length());
            if (x == -1 || y == -1) break;
            sb.append(s.substring(pos, x));
            String oldValue = s.substring(x + begin.length(), y);
            String newValue = values.get(oldValue);
            if (newValue == null) {
                newValue = oldValue;
            }
            sb.append(newValue);
            pos = y + end.length();
        }
        sb.append(s.substring(pos));
        return sb;
    }

    public static StringBundler replaceWithStringBundler(String s, String begin, String end, Map<String, StringBundler> values) {
        if (Validator.isBlank(s) || Validator.isBlank(begin) || Validator.isBlank(end) || MapUtil.isEmpty(values)) {
            return new StringBundler(s);
        }
        int size = values.size() + 1;
        for (StringBundler valueSB : values.values()) {
            size += valueSB.index();
        }
        StringBundler sb = new StringBundler(size);
        int pos = 0;
        while (true) {
            int x = s.indexOf(begin, pos);
            int y = s.indexOf(end, x + begin.length());
            if (x == -1 || y == -1) break;
            sb.append(s.substring(pos, x));
            String oldValue = s.substring(x + begin.length(), y);
            StringBundler newValueSB = values.get(oldValue);
            if (newValueSB == null) {
                sb.append(oldValue);
            } else {
                sb.append(newValueSB);
            }
            pos = y + end.length();
        }
        sb.append(s.substring(pos));
        return sb;
    }

    public static String shorten(String s) {
        return StringUtil.shorten(s, 20);
    }

    public static String shorten(String s, int length) {
        return StringUtil.shorten(s, length, "...");
    }

    public static String shorten(String s, int length, String suffix) {
        if (s == null || suffix == null) {
            return null;
        }
        if (s.codePointCount(0, s.length()) <= length) {
            return s;
        }
        s = Normalizer.normalize(s, Normalizer.Form.NFC);
        if (length < suffix.length()) {
            return s.substring(0, s.offsetByCodePoints(0, length));
        }
        int curLength = length;
        for (int j = curLength - suffix.length() + 1; j > 0; --j) {
            int offset = s.offsetByCodePoints(0, j);
            if (!Character.isWhitespace(s.codePointBefore(offset))) continue;
            curLength = j - 1;
            break;
        }
        if (curLength == length) {
            curLength = length - suffix.length();
        }
        String temp = s.substring(0, s.offsetByCodePoints(0, curLength));
        return temp.concat(suffix);
    }

    public static String shorten(String s, String suffix) {
        return StringUtil.shorten(s, 20, suffix);
    }

    public static String[] split(String s) {
        return StringUtil.split(s, ',');
    }

    public static boolean[] split(String s, boolean x) {
        return StringUtil.split(s, ",", x);
    }

    public static String[] split(String s, char delimiter) {
        if (Validator.isNull(s)) {
            return _EMPTY_STRING_ARRAY;
        }
        if ((s = s.trim()).length() == 0) {
            return _EMPTY_STRING_ARRAY;
        }
        ArrayList<String> nodeValues = new ArrayList<String>();
        StringUtil._split(nodeValues, s, 0, delimiter);
        return nodeValues.toArray(new String[0]);
    }

    public static double[] split(String s, double x) {
        return StringUtil.split(s, ",", x);
    }

    public static float[] split(String s, float x) {
        return StringUtil.split(s, ",", x);
    }

    public static int[] split(String s, int x) {
        return StringUtil.split(s, ",", x);
    }

    public static long[] split(String s, long x) {
        return StringUtil.split(s, ",", x);
    }

    public static short[] split(String s, short x) {
        return StringUtil.split(s, ",", x);
    }

    public static String[] split(String s, String delimiter) {
        if (Validator.isNull(s) || delimiter == null || delimiter.equals("")) {
            return _EMPTY_STRING_ARRAY;
        }
        if ((s = s.trim()).equals(delimiter)) {
            return _EMPTY_STRING_ARRAY;
        }
        if (delimiter.length() == 1) {
            return StringUtil.split(s, delimiter.charAt(0));
        }
        ArrayList<String> nodeValues = new ArrayList<String>();
        int offset = 0;
        int pos = s.indexOf(delimiter, offset);
        while (pos != -1) {
            nodeValues.add(s.substring(offset, pos));
            offset = pos + delimiter.length();
            pos = s.indexOf(delimiter, offset);
        }
        if (offset < s.length()) {
            nodeValues.add(s.substring(offset));
        }
        return nodeValues.toArray(new String[0]);
    }

    public static boolean[] split(String s, String delimiter, boolean x) {
        String[] array = StringUtil.split(s, delimiter);
        boolean[] newArray = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            boolean value = x;
            try {
                Boolean booleanValue = Boolean.valueOf(array[i]);
                value = booleanValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
            newArray[i] = value;
        }
        return newArray;
    }

    public static double[] split(String s, String delimiter, double x) {
        String[] array = StringUtil.split(s, delimiter);
        double[] newArray = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            double value = x;
            try {
                value = Double.parseDouble(array[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            newArray[i] = value;
        }
        return newArray;
    }

    public static float[] split(String s, String delimiter, float x) {
        String[] array = StringUtil.split(s, delimiter);
        float[] newArray = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            float value = x;
            try {
                value = Float.parseFloat(array[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            newArray[i] = value;
        }
        return newArray;
    }

    public static int[] split(String s, String delimiter, int x) {
        String[] array = StringUtil.split(s, delimiter);
        int[] newArray = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            int value = x;
            try {
                value = Integer.parseInt(array[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            newArray[i] = value;
        }
        return newArray;
    }

    public static long[] split(String s, String delimiter, long x) {
        String[] array = StringUtil.split(s, delimiter);
        long[] newArray = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            long value = x;
            try {
                value = Long.parseLong(array[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            newArray[i] = value;
        }
        return newArray;
    }

    public static short[] split(String s, String delimiter, short x) {
        String[] array = StringUtil.split(s, delimiter);
        short[] newArray = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            short value = x;
            try {
                value = Short.parseShort(array[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            newArray[i] = value;
        }
        return newArray;
    }

    public static String[] splitLines(String s) {
        if (Validator.isNull(s)) {
            return _EMPTY_STRING_ARRAY;
        }
        s = s.trim();
        ArrayList<String> lines = new ArrayList<String>();
        StringUtil._splitLines(s, lines);
        return lines.toArray(new String[0]);
    }

    public static boolean startsWith(String s, char begin) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        return StringUtil.equalsIgnoreCase(s.charAt(0), begin);
    }

    public static boolean startsWith(String s, String start) {
        if (s == null || start == null || start.length() > s.length()) {
            return false;
        }
        for (int i = 0; i < start.length(); ++i) {
            if (StringUtil.equalsIgnoreCase(s.charAt(i), start.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int startsWithWeight(String s1, String s2) {
        int i;
        if (s1 == null || s2 == null) {
            return 0;
        }
        char[] chars1 = s1.toCharArray();
        char[] chars2 = s2.toCharArray();
        for (i = 0; i < chars1.length && i < chars2.length && chars1[i] == chars2[i]; ++i) {
        }
        return i;
    }

    public static String stripBetween(String s, String begin, String end) {
        if (Validator.isBlank(s) || Validator.isBlank(begin) || Validator.isBlank(end)) {
            return s;
        }
        StringBundler sb = new StringBundler(s.length());
        int pos = 0;
        while (true) {
            int x = s.indexOf(begin, pos);
            int y = s.indexOf(end, x + begin.length());
            if (x == -1 || y == -1) break;
            sb.append(s.substring(pos, x));
            pos = y + end.length();
        }
        sb.append(s.substring(pos));
        return sb.toString();
    }

    public static String stripCDATA(String s) {
        if (s == null) {
            return s;
        }
        if (s.startsWith("<![CDATA[") && s.endsWith("]]>")) {
            s = s.substring("<![CDATA[".length(), s.length() - "]]>".length());
        }
        return s;
    }

    public static String stripParentheticalSuffix(String s) {
        int x = s.lastIndexOf("(");
        int y = s.lastIndexOf(")");
        if (x == -1 || y == -1 || x > y || !s.endsWith(")") || s.charAt(x - 1) != ' ') {
            return s;
        }
        String part = s.substring(0, x - 1);
        return part.concat(s.substring(y + 1));
    }

    public static String toCharCode(String s) {
        StringBundler sb = new StringBundler(s.length());
        for (int i = 0; i < s.length(); ++i) {
            sb.append(s.codePointAt(i));
        }
        return sb.toString();
    }

    public static String toHexString(int i) {
        char[] buffer = new char[8];
        int index = 8;
        do {
            buffer[--index] = HEX_DIGITS[i & 0xF];
        } while ((i >>>= 4) != 0);
        return new String(buffer, index, 8 - index);
    }

    public static String toHexString(long l) {
        char[] buffer = new char[16];
        int index = 16;
        do {
            buffer[--index] = HEX_DIGITS[(int)(l & 0xFL)];
        } while ((l >>>= 4) != 0L);
        return new String(buffer, index, 16 - index);
    }

    public static String toHexString(Object object) {
        if (object instanceof Integer) {
            Integer integerObj = (Integer)object;
            return StringUtil.toHexString(integerObj);
        }
        if (object instanceof Long) {
            Long longObj = (Long)object;
            return StringUtil.toHexString(longObj);
        }
        return String.valueOf(object);
    }

    public static String toLowerCase(String s) {
        return StringUtil.toLowerCase(s, null);
    }

    public static String toLowerCase(String s, Locale locale) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                if (locale == null) {
                    locale = LocaleUtil.getDefault();
                }
                return s.toLowerCase(locale);
            }
            if (c < 'A' || c > 'Z') continue;
            if (sb == null) {
                sb = new StringBuilder(s);
            }
            sb.setCharAt(i, (char)(c + 32));
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }

    public static String toUpperCase(String s) {
        return StringUtil.toUpperCase(s, null);
    }

    public static String toUpperCase(String s, Locale locale) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                if (locale == null) {
                    locale = LocaleUtil.getDefault();
                }
                return s.toUpperCase(locale);
            }
            if (c < 'a' || c > 'z') continue;
            if (sb == null) {
                sb = new StringBuilder(s);
            }
            sb.setCharAt(i, (char)(c - 32));
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }

    public static String trim(String s) {
        char c;
        int y;
        char c2;
        int x;
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return s;
        }
        for (x = 0; x < len && ((c2 = s.charAt(x)) <= ' ' || c2 >= '\u0080') && Character.isWhitespace(c2); ++x) {
        }
        if (x == len) {
            return "";
        }
        for (y = len - 1; x < y && ((c = s.charAt(y)) <= ' ' || c >= '\u0080') && Character.isWhitespace(c); --y) {
        }
        if (x > 0 || ++y < len) {
            return s.substring(x, y);
        }
        return s;
    }

    public static String trim(String s, char c) {
        return StringUtil.trim(s, new char[]{c});
    }

    public static String trim(String s, char[] exceptions) {
        int len;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (ArrayUtil.isEmpty(exceptions)) {
            return StringUtil.trim(s);
        }
        int x = len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (StringUtil._isTrimable(c, exceptions)) continue;
            x = i;
            break;
        }
        if (x == len) {
            return "";
        }
        int y = x + 1;
        for (int i = len - 1; i > x; --i) {
            char c = s.charAt(i);
            if (StringUtil._isTrimable(c, exceptions)) continue;
            y = i + 1;
            break;
        }
        if (x == 0 && y == len) {
            return s;
        }
        return s.substring(x, y);
    }

    public static String trimLeading(String s) {
        int len;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        int x = len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            x = i;
            break;
        }
        if (x == len) {
            return "";
        }
        if (x == 0) {
            return s;
        }
        return s.substring(x);
    }

    public static String trimLeading(String s, char c) {
        return StringUtil.trimLeading(s, new char[]{c});
    }

    public static String trimLeading(String s, char[] exceptions) {
        int len;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (ArrayUtil.isEmpty(exceptions)) {
            return StringUtil.trimLeading(s);
        }
        int x = len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (StringUtil._isTrimable(c, exceptions)) continue;
            x = i;
            break;
        }
        if (x == len) {
            return "";
        }
        if (x == 0) {
            return s;
        }
        return s.substring(x);
    }

    public static String trimTrailing(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        int len = s.length();
        int x = 0;
        for (int i = len - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            x = i + 1;
            break;
        }
        if (x == 0) {
            return "";
        }
        if (x == len) {
            return s;
        }
        return s.substring(0, x);
    }

    public static String trimTrailing(String s, char c) {
        return StringUtil.trimTrailing(s, new char[]{c});
    }

    public static String trimTrailing(String s, char[] exceptions) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (ArrayUtil.isEmpty(exceptions)) {
            return StringUtil.trimTrailing(s);
        }
        int len = s.length();
        int x = 0;
        for (int i = len - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (StringUtil._isTrimable(c, exceptions)) continue;
            x = i + 1;
            break;
        }
        if (x == 0) {
            return "";
        }
        if (x == len) {
            return s;
        }
        return s.substring(0, x);
    }

    public static String unquote(String s) {
        if (Validator.isNull(s) || s.length() == 1) {
            return s;
        }
        if (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            return s.substring(1, s.length() - 1);
        }
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String upperCase(String s) {
        return StringUtil.toUpperCase(s);
    }

    public static String upperCaseFirstLetter(String s) {
        char[] chars = s.toCharArray();
        if (chars[0] >= 'a' && chars[0] <= 'z') {
            chars[0] = (char)(chars[0] - 32);
        }
        return new String(chars);
    }

    public static boolean wildcardMatches(String s, String wildcard, char singleWildcardCharacter, char multipleWildcardCharacter, char escapeWildcardCharacter, boolean caseSensitive) {
        char c;
        int index;
        if (!caseSensitive) {
            s = StringUtil.toLowerCase(s);
            wildcard = StringUtil.toLowerCase(wildcard);
        }
        if ((index = wildcard.indexOf(escapeWildcardCharacter)) != -1) {
            char newSingleWildcardCharacter = '\u0000';
            while (wildcard.indexOf(newSingleWildcardCharacter) != -1) {
                newSingleWildcardCharacter = (char)(newSingleWildcardCharacter + 1);
            }
            char newMultipleWildcardCharacter = (char)(newSingleWildcardCharacter + 1);
            while (wildcard.indexOf(newMultipleWildcardCharacter) != -1) {
                newMultipleWildcardCharacter = (char)(newMultipleWildcardCharacter + '\u0001');
            }
            StringBuilder sb = new StringBuilder(wildcard);
            for (int i = 0; i < sb.length(); ++i) {
                c = sb.charAt(i);
                if (c == escapeWildcardCharacter) {
                    sb.deleteCharAt(i);
                    continue;
                }
                if (c == singleWildcardCharacter) {
                    sb.setCharAt(i, newSingleWildcardCharacter);
                    continue;
                }
                if (c != multipleWildcardCharacter) continue;
                sb.setCharAt(i, newMultipleWildcardCharacter);
            }
            wildcard = sb.toString();
            singleWildcardCharacter = newSingleWildcardCharacter;
            multipleWildcardCharacter = newMultipleWildcardCharacter;
        }
        for (index = 0; index < s.length(); ++index) {
            if (index >= wildcard.length()) {
                return false;
            }
            char c2 = wildcard.charAt(index);
            if (c2 == multipleWildcardCharacter) break;
            if (s.charAt(index) == c2 || c2 == singleWildcardCharacter) continue;
            return false;
        }
        int sIndex = index;
        int wildcardIndex = index;
        int matchPoint = 0;
        int comparePoint = 0;
        while (sIndex < s.length()) {
            if (wildcardIndex == wildcard.length()) {
                return false;
            }
            c = wildcard.charAt(wildcardIndex);
            if (c == multipleWildcardCharacter) {
                if (++wildcardIndex == wildcard.length()) {
                    return true;
                }
                matchPoint = wildcardIndex;
                comparePoint = sIndex + 1;
                continue;
            }
            if (c == s.charAt(sIndex) || c == singleWildcardCharacter) {
                ++sIndex;
                ++wildcardIndex;
                continue;
            }
            wildcardIndex = matchPoint;
            sIndex = comparePoint++;
        }
        while (wildcardIndex < wildcard.length() && wildcard.charAt(wildcardIndex) == multipleWildcardCharacter) {
            ++wildcardIndex;
        }
        return wildcardIndex == wildcard.length();
    }

    private static boolean _isTrimable(char c, char[] exceptions) {
        for (char exception : exceptions) {
            if (c != exception) continue;
            return false;
        }
        return Character.isWhitespace(c);
    }

    private static String _read(InputStream inputStream) throws IOException {
        int count;
        byte[] buffer = new byte[8192];
        int offset = 0;
        while ((count = inputStream.read(buffer, offset, buffer.length - offset)) != -1) {
            if ((offset += count) != buffer.length) continue;
            byte[] newBuffer = new byte[buffer.length << 1];
            System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
            buffer = newBuffer;
        }
        if (offset == 0) {
            return "";
        }
        return new String(buffer, 0, offset, "UTF-8");
    }

    private static void _split(Collection<String> values, String s, int offset, char delimiter) {
        int pos = s.indexOf(delimiter, offset);
        while (pos != -1) {
            values.add(s.substring(offset, pos));
            offset = pos + 1;
            pos = s.indexOf(delimiter, offset);
        }
        if (offset < s.length()) {
            values.add(s.substring(offset));
        }
    }

    private static void _splitLines(String s, Collection<String> lines) {
        int lastIndex = 0;
        while (true) {
            int returnIndex;
            if ((returnIndex = s.indexOf(13, lastIndex)) == -1) {
                StringUtil._split(lines, s, lastIndex, '\n');
                return;
            }
            int newLineIndex = s.indexOf(10, lastIndex);
            if (newLineIndex == -1) {
                StringUtil._split(lines, s, lastIndex, '\r');
                return;
            }
            if (newLineIndex < returnIndex) {
                lines.add(s.substring(lastIndex, newLineIndex));
                lastIndex = newLineIndex + 1;
                continue;
            }
            lines.add(s.substring(lastIndex, returnIndex));
            lastIndex = returnIndex + 1;
            if (lastIndex != newLineIndex) continue;
            ++lastIndex;
        }
    }
}

