/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.text.DateFormat;

public class ObjectMapperUtil {
    private static final ObjectMapper _objectMapper = new ObjectMapper(){
        {
            this.configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true);
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            this.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
            this.enable(SerializationFeature.INDENT_OUTPUT);
            this.setDateFormat((DateFormat)new ISO8601DateFormat());
            this.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            this.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        }
    };

    public static <T> T readValue(Class<?> clazz, String json) {
        try {
            return (T)_objectMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return null;
        }
    }
}

