/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.aggregation;

import com.liferay.portal.kernel.search.facet.collector.FacetCollector;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.aggregation.AggregationResult;
import com.liferay.portal.search.aggregation.HierarchicalAggregationResult;
import com.liferay.portal.search.aggregation.bucket.BucketAggregationResult;
import com.liferay.portal.vulcan.aggregation.Facet;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FacetUtil {
    public static Facet toFacet(BucketAggregationResult bucketAggregationResult) {
        return new Facet(bucketAggregationResult.getName(), TransformUtil.transform(bucketAggregationResult.getBuckets(), bucket -> new Facet.FacetValue(GetterUtil.getInteger(bucket.getDocCount()), bucket.getKey())));
    }

    public static Facet toFacet(com.liferay.portal.kernel.search.facet.Facet facet) {
        FacetCollector facetCollector = facet.getFacetCollector();
        List termCollectors = facetCollector.getTermCollectors();
        if (termCollectors.isEmpty()) {
            return null;
        }
        return new Facet(FacetUtil._getFacetCriteria(facet), TransformUtil.transform(termCollectors, termCollector -> new Facet.FacetValue(termCollector.getFrequency(), termCollector.getTerm())));
    }

    public static List<Facet> toFacets(AggregationResult aggregationResult) {
        ArrayList<Facet> facets = new ArrayList<Facet>();
        if (aggregationResult instanceof BucketAggregationResult) {
            facets.add(FacetUtil.toFacet((BucketAggregationResult)aggregationResult));
        } else if (aggregationResult instanceof HierarchicalAggregationResult) {
            facets.addAll(FacetUtil.toFacets((HierarchicalAggregationResult)aggregationResult));
        }
        return facets;
    }

    public static List<Facet> toFacets(HierarchicalAggregationResult hierarchicalAggregationResult) {
        ArrayList<Facet> facets = new ArrayList<Facet>();
        Map aggregationResults = hierarchicalAggregationResult.getChildrenAggregationResultsMap();
        for (AggregationResult aggregationResult : aggregationResults.values()) {
            facets.addAll(FacetUtil.toFacets(aggregationResult));
        }
        return facets;
    }

    private static String _getFacetCriteria(com.liferay.portal.kernel.search.facet.Facet facet) {
        FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
        if (facetConfiguration.getLabel() != null) {
            return facetConfiguration.getLabel();
        }
        return facet.getFieldName();
    }
}

