/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.multipart;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;

public class MultipartBody {
    private final Map<String, BinaryFile> _binaryFiles;
    private final ObjectMapperProvider _objectMapperProvider;
    private final Map<String, String> _values;

    public static MultipartBody of(Map<String, BinaryFile> binaryFiles, ObjectMapperProvider objectMapperProvider, Map<String, String> values) {
        return new MultipartBody(binaryFiles, objectMapperProvider, values);
    }

    public BinaryFile getBinaryFile(String key) {
        return this._binaryFiles.get(key);
    }

    public byte[] getBinaryFileAsBytes(String key) throws IOException {
        BinaryFile binaryFile = this.getBinaryFile(key);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamUtil.transfer(binaryFile.getInputStream(), byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public <T> T getValueAsInstance(String key, Class<T> clazz) throws IOException {
        String valueAsString = this.getValueAsString(key);
        if (valueAsString == null) {
            throw new BadRequestException("Missing JSON property with the key: " + key);
        }
        return this._parseValue(valueAsString, clazz);
    }

    public <T> Optional<T> getValueAsInstanceOptional(String key, Class<T> clazz) throws IOException {
        String valueAsString = this.getValueAsString(key);
        if (valueAsString == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this._parseValue(valueAsString, clazz));
    }

    public String getValueAsString(String key) {
        if (this._values != null && this._values.containsKey(key)) {
            return this._values.get(key);
        }
        return null;
    }

    public Map<String, String> getValues() {
        return this._values;
    }

    private MultipartBody(Map<String, BinaryFile> binaryFiles, ObjectMapperProvider objectMapperProvider, Map<String, String> values) {
        this._binaryFiles = binaryFiles;
        this._objectMapperProvider = objectMapperProvider;
        this._values = values;
    }

    private <T> T _parseValue(String valueAsString, Class<T> clazz) throws IOException {
        ObjectMapper objectMapper = this._objectMapperProvider.provide(clazz);
        if (objectMapper == null) {
            throw new InternalServerErrorException("Unable to get object mapper for class " + clazz.getName());
        }
        return (T)objectMapper.readValue(valueAsString, clazz);
    }

    public static interface ObjectMapperProvider {
        public ObjectMapper provide(Class<?> var1);
    }
}

