/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.pagination;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.aggregation.Facet;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JacksonXmlRootElement(localName="page")
public class Page<T> {
    private final Map<String, Map<String, String>> _actions;
    private List<Facet> _facets = new ArrayList<Facet>();
    private final Collection<T> _items;
    private final long _page;
    private final long _pageSize;
    private final long _totalCount;

    public static <T> Page<T> of(Collection<T> items) {
        return new Page<T>(new HashMap<String, Map<String, String>>(), items);
    }

    public static <T> Page<T> of(Collection<T> items, Pagination pagination, long totalCount) {
        return new Page<T>(new HashMap<String, Map<String, String>>(), new ArrayList<Facet>(), items, pagination, totalCount);
    }

    public static <T> Page<T> of(Map<String, Map<String, String>> actions, Collection<T> items) {
        return new Page<T>(actions, items);
    }

    public static <T> Page<T> of(Map<String, Map<String, String>> actions, Collection<T> items, Pagination pagination, long totalCount) {
        return new Page<T>(actions, new ArrayList<Facet>(), items, pagination, totalCount);
    }

    public static <T> Page<T> of(Map<String, Map<String, String>> actions, List<Facet> facets, Collection<T> items, Pagination pagination, long totalCount) {
        return new Page<T>(actions, facets, items, pagination, totalCount);
    }

    @JsonProperty(value="actions")
    public Map<String, Map<String, String>> getActions() {
        return this._actions;
    }

    @JsonProperty(value="facets")
    public List<Facet> getFacets() {
        return this._facets;
    }

    @JacksonXmlElementWrapper(localName="items")
    @JacksonXmlProperty(localName="item")
    public Collection<T> getItems() {
        return new ArrayList<T>(this._items);
    }

    public long getLastPage() {
        if (this._pageSize == 0L || this._totalCount == 0L) {
            return 1L;
        }
        return -Math.floorDiv(-this._totalCount, this._pageSize);
    }

    @JsonProperty(value="page")
    public long getPage() {
        return this._page;
    }

    @JsonProperty(value="pageSize")
    public long getPageSize() {
        return this._pageSize;
    }

    public long getTotalCount() {
        return this._totalCount;
    }

    public boolean hasNext() {
        return this.getLastPage() > this._page;
    }

    public boolean hasPrevious() {
        return this._page > 1L;
    }

    public String toString() {
        StringBundler sb = new StringBundler("{\"actions\": ");
        sb.append(this._toString(this._actions));
        sb.append(", \"items\": [");
        Iterator<T> iterator = this._items.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("], \"page\": ");
        sb.append(this._page);
        sb.append(", \"pageSize\": ");
        sb.append(this._pageSize);
        sb.append(", \"totalCount\": ");
        sb.append(this._totalCount);
        sb.append("}");
        return sb.toString();
    }

    private Page(Map<String, Map<String, String>> actions, Collection<T> items) {
        this._actions = actions;
        this._items = items;
        this._page = 1L;
        this._pageSize = items.size();
        this._totalCount = items.size();
    }

    private Page(Map<String, Map<String, String>> actions, List<Facet> facets, Collection<T> items, Pagination pagination, long totalCount) {
        this._actions = actions;
        this._facets = facets;
        this._items = items;
        if (pagination == null) {
            this._page = 0L;
            this._pageSize = 0L;
        } else {
            this._page = pagination.getPage();
            this._pageSize = pagination.getPageSize();
        }
        this._totalCount = totalCount;
    }

    private String _toString(Map<String, Object> map) {
        StringBundler sb = new StringBundler("{");
        Set<Map.Entry<String, Object>> entries = map.entrySet();
        Iterator<Map.Entry<String, Object>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            if (value instanceof Map) {
                sb.append(this._toString((Map)value));
            } else {
                sb.append("\"");
                sb.append(value);
                sb.append("\"");
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

