/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;
import java.util.Map;

public class OrderByComparatorFactoryUtil {
    private static final Log _log = LogFactoryUtil.getLog(OrderByComparatorFactoryUtil.class);

    public static <T extends BaseModel<T>> OrderByComparator<T> create(String tableName, Object ... columns) {
        if (columns.length == 0 || columns.length % 2 != 0) {
            throw new IllegalArgumentException("Columns length is not an even number");
        }
        return new DefaultOrderByComparator(tableName, columns);
    }

    protected static class DefaultOrderByComparator<T extends BaseModel<T>>
    extends OrderByComparator<T> {
        private static final String _ORDER_BY_ASC = " ASC";
        private static final String _ORDER_BY_DESC = " DESC";
        private static final Map<Class<?>, Object> _primitiveObjects = HashMapBuilder.put(Boolean.TYPE, Boolean.TRUE).put(Byte.TYPE, (Boolean)((Object)Byte.valueOf("0"))).put(Character.TYPE, (Boolean)((Object)Character.valueOf('0'))).put(Double.TYPE, (Boolean)((Object)Double.valueOf(0.0))).put(Float.TYPE, (Boolean)((Object)Float.valueOf(0.0f))).put(Integer.TYPE, (Boolean)((Object)Integer.valueOf(0))).put(Long.TYPE, (Boolean)((Object)Long.valueOf(0L))).put(Short.TYPE, (Boolean)((Object)Short.valueOf("0"))).build();
        private final Object[] _columns;
        private final String _tableName;

        @Override
        public int compare(T object1, T object2) {
            for (int i = 0; i < this._columns.length; i += 2) {
                Comparable columnValueComparable2;
                Comparable columnValueComparable1;
                int value;
                Object columnInstance;
                boolean columnAscending;
                String columnName;
                block8: {
                    columnName = String.valueOf(this._columns[i]);
                    columnAscending = Boolean.valueOf(String.valueOf(this._columns[i + 1]));
                    columnInstance = null;
                    Class columnClass = BeanPropertiesUtil.getObjectTypeSilent(object1, (String)columnName);
                    if (columnClass.isPrimitive()) {
                        columnInstance = _primitiveObjects.get(columnClass);
                    } else {
                        try {
                            columnInstance = columnClass.newInstance();
                        }
                        catch (Exception exception) {
                            if (!_log.isDebugEnabled()) break block8;
                            _log.debug(exception, exception);
                        }
                    }
                }
                Object columnValue1 = BeanPropertiesUtil.getObjectSilent(object1, (String)columnName);
                Object columnValue2 = BeanPropertiesUtil.getObjectSilent(object2, (String)columnName);
                if (columnInstance instanceof Date) {
                    Date columnValueDate1 = (Date)columnValue1;
                    Date columnValueDate2 = (Date)columnValue2;
                    value = DateUtil.compareTo(columnValueDate1, columnValueDate2);
                    if (value == 0) continue;
                    if (columnAscending) {
                        return value;
                    }
                    return -value;
                }
                if (!(columnInstance instanceof Comparable) || (value = (columnValueComparable1 = (Comparable)columnValue1).compareTo(columnValueComparable2 = (Comparable)columnValue2)) == 0) continue;
                if (columnAscending) {
                    return value;
                }
                return -value;
            }
            return 0;
        }

        @Override
        public String getOrderBy() {
            StringBundler sb = new StringBundler(5 * this._columns.length - 1);
            for (int i = 0; i < this._columns.length; i += 2) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this._tableName);
                sb.append(".");
                String columnName = String.valueOf(this._columns[i]);
                boolean columnAscending = Boolean.valueOf(String.valueOf(this._columns[i + 1]));
                sb.append(columnName);
                if (columnAscending) {
                    sb.append(_ORDER_BY_ASC);
                    continue;
                }
                sb.append(_ORDER_BY_DESC);
            }
            return sb.toString();
        }

        @Override
        public boolean isAscending(String field) {
            String orderBy = this.getOrderBy();
            if (orderBy == null) {
                return false;
            }
            int x = orderBy.indexOf("." + field + " ");
            if (x == -1) {
                return false;
            }
            int y = orderBy.indexOf(_ORDER_BY_ASC, x);
            if (y == -1) {
                return false;
            }
            int z = orderBy.indexOf(_ORDER_BY_DESC, x);
            return z < 0 || z >= y;
        }

        private DefaultOrderByComparator(String tableName, Object ... columns) {
            this._tableName = tableName;
            this._columns = columns;
        }
    }
}

