/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.permission;

import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.vulcan.permission.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.BadRequestException;

public class PermissionUtil {
    private static final Log _log = LogFactoryUtil.getLog(PermissionUtil.class);

    public static void checkPermission(String actionId, GroupLocalService groupLocalService, String resourceName, long resourceId, Long siteId) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        Group group = groupLocalService.fetchGroup(siteId.longValue());
        if (group != null && group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (!permissionChecker.hasPermission(group, resourceName, resourceId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, resourceName, siteId.longValue(), new String[]{actionId});
        }
    }

    public static List<Role> getRoles(Company company, RoleLocalService roleLocalService, String[] roleNames) throws PortalException {
        ArrayList<String> invalidRoleNames = new ArrayList<String>();
        ArrayList<Role> roles = new ArrayList<Role>();
        for (String roleName : roleNames) {
            try {
                Role role = roleLocalService.getRole(company.getCompanyId(), roleName);
                roles.add(role);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                if (_log.isDebugEnabled()) {
                    _log.debug(roleName, noSuchRoleException);
                }
                invalidRoleNames.add(roleName);
            }
        }
        if (!invalidRoleNames.isEmpty()) {
            throw new BadRequestException("Invalid roles: " + ArrayUtil.toStringArray(invalidRoleNames));
        }
        return roles;
    }

    public static Permission toPermission(Long companyId, Long id, List<ResourceAction> resourceActions, String resourceName, ResourcePermissionLocalService resourcePermissionLocalService, final Role role) {
        ResourcePermission resourcePermission = resourcePermissionLocalService.fetchResourcePermission(companyId.longValue(), resourceName, 4, String.valueOf(id), role.getRoleId());
        if (resourcePermission == null) {
            return null;
        }
        final HashSet<String> actionsIdsSet = new HashSet<String>();
        long actionIds = resourcePermission.getActionIds();
        for (ResourceAction resourceAction : resourceActions) {
            long bitwiseValue = resourceAction.getBitwiseValue();
            if ((actionIds & bitwiseValue) != bitwiseValue) continue;
            actionsIdsSet.add(resourceAction.getActionId());
        }
        return new Permission(){
            {
                this.actionIds = actionsIdsSet.toArray(new String[0]);
                this.roleName = role.getName();
            }
        };
    }
}

