/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.rest.builder.internal.freemarker.util;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.JavaMethodSignature;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser.GraphQLOpenAPIParser;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser.util.OpenAPIParserUtil;
import com.liferay.portal.tools.rest.builder.internal.yaml.config.ConfigYAML;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Components;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Info;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Items;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.OpenAPIYAML;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Operation;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Schema;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpenAPIUtil {
    private static final Pattern _leadingUnderscorePattern = Pattern.compile("^_+");
    private static final Pattern _nondigitPattern = Pattern.compile("\\D");

    public static String escapeVersion(OpenAPIYAML openAPIYAML) {
        Info info = openAPIYAML.getInfo();
        String version = info.getVersion();
        if (Validator.isNull(version)) {
            return null;
        }
        Matcher matcher = _nondigitPattern.matcher(version);
        String escapedVersion = matcher.replaceAll("_");
        matcher = _leadingUnderscorePattern.matcher(escapedVersion);
        return "v" + matcher.replaceFirst("");
    }

    public static String formatSingular(String s) {
        if (s.endsWith("ases")) {
            s = s.substring(0, s.length() - 1);
        } else if (s.endsWith("ses")) {
            s = s.substring(0, s.length() - 2);
        } else if (s.endsWith("ies")) {
            s = s.substring(0, s.length() - 3) + "y";
        } else if (s.endsWith("s")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static Map<String, Schema> getAllSchemas(OpenAPIYAML openAPIYAML) {
        TreeMap<String, Schema> allSchemas = new TreeMap<String, Schema>();
        Components components = openAPIYAML.getComponents();
        if (components == null) {
            return allSchemas;
        }
        LinkedList<Map<String, Schema>> queue = new LinkedList<Map<String, Schema>>();
        queue.add(components.getSchemas());
        Map map = null;
        while ((map = (Map)queue.poll()) != null) {
            for (Map.Entry entry : map.entrySet()) {
                Schema schema = (Schema)entry.getValue();
                Map<String, Schema> propertySchemas = null;
                Items items = schema.getItems();
                propertySchemas = items != null ? items.getPropertySchemas() : (schema.getAllOfSchemas() != null ? OpenAPIParserUtil.getAllOfPropertySchemas(schema) : schema.getPropertySchemas());
                if (propertySchemas == null) continue;
                String schemaName = StringUtil.upperCaseFirstLetter((String)entry.getKey());
                if (items != null) {
                    schemaName = OpenAPIUtil.formatSingular(schemaName);
                }
                allSchemas.put(schemaName, schema);
                if (schema.getOneOfSchemas() != null) {
                    for (Schema oneOfSchema : schema.getOneOfSchemas()) {
                        Map<String, Schema> schemas = oneOfSchema.getPropertySchemas();
                        Set<String> keys = schemas.keySet();
                        Iterator<String> iterator = keys.iterator();
                        String schemaKey = StringUtil.upperCaseFirstLetter(iterator.next());
                        if (allSchemas.containsKey(schemaKey)) continue;
                        allSchemas.put(schemaKey, oneOfSchema);
                        queue.add(schemas);
                    }
                }
                queue.add(propertySchemas);
            }
        }
        return allSchemas;
    }

    public static Map<String, Schema> getGlobalEnumSchemas(OpenAPIYAML openAPIYAML) {
        TreeMap<String, Schema> globalEnumSchemas = new TreeMap<String, Schema>();
        Components components = openAPIYAML.getComponents();
        if (components == null) {
            return globalEnumSchemas;
        }
        Map<String, Schema> schemas = components.getSchemas();
        for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
            Schema schema = entry.getValue();
            Map<String, Schema> propertySchemas = null;
            Items items = schema.getItems();
            propertySchemas = items != null ? items.getPropertySchemas() : (schema.getAllOfSchemas() != null ? OpenAPIParserUtil.getAllOfPropertySchemas(schema) : schema.getPropertySchemas());
            if (propertySchemas != null || schema.getEnumValues() == null) continue;
            String schemaName = StringUtil.upperCaseFirstLetter(entry.getKey());
            if (items != null) {
                schemaName = OpenAPIUtil.formatSingular(schemaName);
            }
            globalEnumSchemas.put(schemaName, schema);
        }
        return globalEnumSchemas;
    }

    public static List<JavaMethodSignature> getJavaMethodSignatures(ConfigYAML configYAML, OpenAPIYAML openAPIYAML, Predicate<Operation> predicate) {
        return GraphQLOpenAPIParser.getJavaMethodSignatures(configYAML, openAPIYAML, predicate);
    }
}

